/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import org.apache.commons.text.translate.UnicodeUnescaper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class UnicodeUnescaperTest {
    UnicodeUnescaperTest() {
    }

    @Test
    void testLessThanFour() {
        UnicodeUnescaper escaper = new UnicodeUnescaper();
        String input = "\\0047\\u006";
        Assertions.assertThrows(IllegalArgumentException.class, () -> escaper.translate((CharSequence)"\\0047\\u006"));
    }

    @Test
    void testUPlus() {
        UnicodeUnescaper escaper = new UnicodeUnescaper();
        String input = "\\u+0047";
        Assertions.assertEquals((Object)"G", (Object)escaper.translate((CharSequence)"\\u+0047"), (String)"Failed to unescape Unicode characters with 'u+' notation");
    }

    @Test
    void testUuuuu() {
        UnicodeUnescaper escaper = new UnicodeUnescaper();
        String input = "\\uuuuuuuu0047";
        String result = escaper.translate((CharSequence)"\\uuuuuuuu0047");
        Assertions.assertEquals((Object)"G", (Object)result, (String)"Failed to unescape Unicode characters with many 'u' characters");
    }
}

