/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.security.authentication.validator;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.security.authentication.basic.BasicAuthenticationProviderView;
import org.apache.ignite.internal.security.authentication.configuration.AuthenticationProviderView;
import org.apache.ignite.internal.security.authentication.configuration.validator.AuthenticationProvidersValidator;
import org.apache.ignite.internal.security.configuration.SecurityExtensionConfiguration;
import org.apache.ignite.internal.security.configuration.SecurityExtensionView;

public class AuthenticationProvidersValidatorImpl
implements Validator<AuthenticationProvidersValidator, NamedListView<? extends AuthenticationProviderView>> {
    public static final AuthenticationProvidersValidatorImpl INSTANCE = new AuthenticationProvidersValidatorImpl();

    public void validate(AuthenticationProvidersValidator annotation, ValidationContext<NamedListView<? extends AuthenticationProviderView>> ctx) {
        NamedListView view = (NamedListView)ctx.getNewValue();
        if (view.isEmpty()) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "At least one provider is required."));
            return;
        }
        List basicProviders = view.stream().filter(BasicAuthenticationProviderView.class::isInstance).map(BasicAuthenticationProviderView.class::cast).collect(Collectors.toList());
        if (basicProviders.isEmpty()) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Basic provider is required."));
            return;
        }
        if (basicProviders.size() > 1) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Only one basic provider is supported."));
            return;
        }
        boolean enabled = ((SecurityExtensionView)ctx.getNewRoot(SecurityExtensionConfiguration.KEY)).security().enabled();
        if (enabled && ((BasicAuthenticationProviderView)basicProviders.get(0)).users().isEmpty()) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Basic provider must have at least one user."));
        }
    }
}

