/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extensions.federation.hadoop;

import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.polaris.core.catalog.ExternalCatalogFactory;
import org.apache.polaris.core.catalog.GenericTableCatalog;
import org.apache.polaris.core.connection.AuthenticationParametersDpo;
import org.apache.polaris.core.connection.AuthenticationType;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.hadoop.HadoopConnectionConfigInfoDpo;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Identifier(value="hadoop")
public class HadoopFederatedCatalogFactory
implements ExternalCatalogFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopFederatedCatalogFactory.class);

    public Catalog createCatalog(ConnectionConfigInfoDpo connectionConfigInfoDpo, UserSecretsManager userSecretsManager) {
        AuthenticationParametersDpo authenticationParametersDpo = connectionConfigInfoDpo.getAuthenticationParameters();
        if (authenticationParametersDpo.getAuthenticationTypeCode() != AuthenticationType.IMPLICIT.getCode()) {
            throw new IllegalStateException("Hadoop federation only supports IMPLICIT authentication.");
        }
        Configuration conf = new Configuration();
        String warehouse = ((HadoopConnectionConfigInfoDpo)connectionConfigInfoDpo).getWarehouse();
        HadoopCatalog hadoopCatalog = new HadoopCatalog(conf, warehouse);
        hadoopCatalog.initialize(warehouse, connectionConfigInfoDpo.asIcebergCatalogProperties(userSecretsManager));
        return hadoopCatalog;
    }

    public GenericTableCatalog createGenericCatalog(ConnectionConfigInfoDpo connectionConfig, UserSecretsManager userSecretsManager) {
        throw new UnsupportedOperationException("Generic table federation to this catalog is not supported.");
    }
}

