/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.config;

import jakarta.annotation.Nullable;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.CatalogEntity;

public class RealmConfigImpl
implements RealmConfig {
    private final PolarisConfigurationStore configurationStore;
    private final RealmContext realmContext;

    public RealmConfigImpl(PolarisConfigurationStore configurationStore, RealmContext realmContext) {
        this.configurationStore = configurationStore;
        this.realmContext = realmContext;
    }

    @Override
    @Nullable
    public <T> T getConfig(String configName) {
        return this.configurationStore.getConfiguration(this.realmContext, configName);
    }

    @Override
    public <T> T getConfig(String configName, T defaultValue) {
        return this.configurationStore.getConfiguration(this.realmContext, configName, defaultValue);
    }

    @Override
    public <T> T getConfig(PolarisConfiguration<T> config) {
        return this.configurationStore.getConfiguration(this.realmContext, config);
    }

    @Override
    public <T> T getConfig(PolarisConfiguration<T> config, CatalogEntity catalogEntity) {
        return this.configurationStore.getConfiguration(this.realmContext, catalogEntity, config);
    }
}

