/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.PolicyScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourcePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourcePolicy> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyName").getter(ResourcePolicy.getter(ResourcePolicy::policyName)).setter(ResourcePolicy.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyDocument").getter(ResourcePolicy.getter(ResourcePolicy::policyDocument)).setter(ResourcePolicy.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()}).build();
    private static final SdkField<Long> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastUpdatedTime").getter(ResourcePolicy.getter(ResourcePolicy::lastUpdatedTime)).setter(ResourcePolicy.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> POLICY_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyScope").getter(ResourcePolicy.getter(ResourcePolicy::policyScopeAsString)).setter(ResourcePolicy.setter(Builder::policyScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyScope").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(ResourcePolicy.getter(ResourcePolicy::resourceArn)).setter(ResourcePolicy.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(ResourcePolicy.getter(ResourcePolicy::revisionId)).setter(ResourcePolicy.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD, POLICY_DOCUMENT_FIELD, LAST_UPDATED_TIME_FIELD, POLICY_SCOPE_FIELD, RESOURCE_ARN_FIELD, REVISION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourcePolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String policyName;
    private final String policyDocument;
    private final Long lastUpdatedTime;
    private final String policyScope;
    private final String resourceArn;
    private final String revisionId;

    private ResourcePolicy(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.policyScope = builder.policyScope;
        this.resourceArn = builder.resourceArn;
        this.revisionId = builder.revisionId;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final Long lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final PolicyScope policyScope() {
        return PolicyScope.fromValue(this.policyScope);
    }

    public final String policyScopeAsString() {
        return this.policyScope;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePolicy)) {
            return false;
        }
        ResourcePolicy other = (ResourcePolicy)obj;
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.policyScopeAsString(), other.policyScopeAsString()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.revisionId(), other.revisionId());
    }

    public final String toString() {
        return ToString.builder((String)"ResourcePolicy").add("PolicyName", (Object)this.policyName()).add("PolicyDocument", (Object)this.policyDocument()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("PolicyScope", (Object)this.policyScopeAsString()).add("ResourceArn", (Object)this.resourceArn()).add("RevisionId", (Object)this.revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "policyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "policyScope": {
                return Optional.ofNullable(clazz.cast(this.policyScopeAsString()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyName", POLICY_NAME_FIELD);
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("policyScope", POLICY_SCOPE_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("revisionId", REVISION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcePolicy, T> g) {
        return obj -> g.apply((ResourcePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyName;
        private String policyDocument;
        private Long lastUpdatedTime;
        private String policyScope;
        private String resourceArn;
        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePolicy model) {
            this.policyName(model.policyName);
            this.policyDocument(model.policyDocument);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.policyScope(model.policyScope);
            this.resourceArn(model.resourceArn);
            this.revisionId(model.revisionId);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final Long getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getPolicyScope() {
            return this.policyScope;
        }

        public final void setPolicyScope(String policyScope) {
            this.policyScope = policyScope;
        }

        @Override
        public final Builder policyScope(String policyScope) {
            this.policyScope = policyScope;
            return this;
        }

        @Override
        public final Builder policyScope(PolicyScope policyScope) {
            this.policyScope(policyScope == null ? null : policyScope.toString());
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public ResourcePolicy build() {
            return new ResourcePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourcePolicy> {
        public Builder policyName(String var1);

        public Builder policyDocument(String var1);

        public Builder lastUpdatedTime(Long var1);

        public Builder policyScope(String var1);

        public Builder policyScope(PolicyScope var1);

        public Builder resourceArn(String var1);

        public Builder revisionId(String var1);
    }
}

