/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;

public class UserNameIdentityToken
extends UserIdentityToken
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=322");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=323");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=324");
    private final String userName;
    private final ByteString password;
    private final String encryptionAlgorithm;

    public UserNameIdentityToken(String policyId, String userName, ByteString password, String encryptionAlgorithm) {
        super(policyId);
        this.userName = userName;
        this.password = password;
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public String getUserName() {
        return this.userName;
    }

    public ByteString getPassword() {
        return this.password;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    protected UserNameIdentityToken(UserNameIdentityTokenBuilder<?, ?> b) {
        super((UserIdentityToken.UserIdentityTokenBuilder<?, ?>)b);
        this.userName = ((UserNameIdentityTokenBuilder)b).userName;
        this.password = ((UserNameIdentityTokenBuilder)b).password;
        this.encryptionAlgorithm = ((UserNameIdentityTokenBuilder)b).encryptionAlgorithm;
    }

    public static UserNameIdentityTokenBuilder<?, ?> builder() {
        return new UserNameIdentityTokenBuilderImpl();
    }

    public UserNameIdentityTokenBuilder<?, ?> toBuilder() {
        return new UserNameIdentityTokenBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserNameIdentityToken)) {
            return false;
        }
        UserNameIdentityToken other = (UserNameIdentityToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        ByteString this$password = this.getPassword();
        ByteString other$password = other.getPassword();
        if (this$password == null ? other$password != null : !((Object)this$password).equals(other$password)) {
            return false;
        }
        String this$encryptionAlgorithm = this.getEncryptionAlgorithm();
        String other$encryptionAlgorithm = other.getEncryptionAlgorithm();
        return !(this$encryptionAlgorithm == null ? other$encryptionAlgorithm != null : !this$encryptionAlgorithm.equals(other$encryptionAlgorithm));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserNameIdentityToken;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        ByteString $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : ((Object)$password).hashCode());
        String $encryptionAlgorithm = this.getEncryptionAlgorithm();
        result = result * 59 + ($encryptionAlgorithm == null ? 43 : $encryptionAlgorithm.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "UserNameIdentityToken(userName=" + this.getUserName() + ", password=" + this.getPassword() + ", encryptionAlgorithm=" + this.getEncryptionAlgorithm() + ")";
    }

    private static final class UserNameIdentityTokenBuilderImpl
    extends UserNameIdentityTokenBuilder<UserNameIdentityToken, UserNameIdentityTokenBuilderImpl> {
        private UserNameIdentityTokenBuilderImpl() {
        }

        @Override
        protected UserNameIdentityTokenBuilderImpl self() {
            return this;
        }

        @Override
        public UserNameIdentityToken build() {
            return new UserNameIdentityToken(this);
        }
    }

    public static abstract class UserNameIdentityTokenBuilder<C extends UserNameIdentityToken, B extends UserNameIdentityTokenBuilder<C, B>>
    extends UserIdentityToken.UserIdentityTokenBuilder<C, B> {
        private String userName;
        private ByteString password;
        private String encryptionAlgorithm;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            UserNameIdentityTokenBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(UserNameIdentityToken instance, UserNameIdentityTokenBuilder<?, ?> b) {
            b.userName(instance.userName);
            b.password(instance.password);
            b.encryptionAlgorithm(instance.encryptionAlgorithm);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B userName(String userName) {
            this.userName = userName;
            return (B)this.self();
        }

        public B password(ByteString password) {
            this.password = password;
            return (B)this.self();
        }

        public B encryptionAlgorithm(String encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "UserNameIdentityToken.UserNameIdentityTokenBuilder(super=" + super.toString() + ", userName=" + this.userName + ", password=" + this.password + ", encryptionAlgorithm=" + this.encryptionAlgorithm + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<UserNameIdentityToken> {
        @Override
        public Class<UserNameIdentityToken> getType() {
            return UserNameIdentityToken.class;
        }

        @Override
        public UserNameIdentityToken decode(SerializationContext context, UaDecoder decoder) {
            String policyId = decoder.readString("PolicyId");
            String userName = decoder.readString("UserName");
            ByteString password = decoder.readByteString("Password");
            String encryptionAlgorithm = decoder.readString("EncryptionAlgorithm");
            return new UserNameIdentityToken(policyId, userName, password, encryptionAlgorithm);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, UserNameIdentityToken value) {
            encoder.writeString("PolicyId", value.getPolicyId());
            encoder.writeString("UserName", value.getUserName());
            encoder.writeByteString("Password", value.getPassword());
            encoder.writeString("EncryptionAlgorithm", value.getEncryptionAlgorithm());
        }
    }
}

