/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.airgap;

import java.io.IOException;
import java.util.HashMap;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.pipe.sink.protocol.IoTDBAirGapSink;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferDataNodeHandshakeV1Req;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferDataNodeHandshakeV2Req;
import org.apache.iotdb.pipe.api.annotation.TableModel;
import org.apache.iotdb.pipe.api.annotation.TreeModel;

@TreeModel
@TableModel
public abstract class IoTDBDataNodeAirGapSink
extends IoTDBAirGapSink {
    protected boolean mayNeedHandshakeWhenFail() {
        return false;
    }

    protected byte[] generateHandShakeV1Payload() throws IOException {
        return PipeTransferDataNodeHandshakeV1Req.toTPipeTransferBytes(CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
    }

    protected byte[] generateHandShakeV2Payload() throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("clusterID", IoTDBDescriptor.getInstance().getConfig().getClusterId());
        params.put("timestampPrecision", CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
        params.put("convertOnTypeMismatch", Boolean.toString(this.shouldReceiverConvertOnTypeMismatch));
        params.put("loadTsFileStrategy", this.loadTsFileStrategy);
        params.put("username", this.username);
        params.put("password", this.password);
        params.put("validateTsFile", Boolean.toString(this.loadTsFileValidation));
        params.put("markAsPipeRequest", Boolean.toString(this.shouldMarkAsPipeRequest));
        params.put("skipIf", Boolean.toString(this.skipIfNoPrivileges));
        return PipeTransferDataNodeHandshakeV2Req.toTPipeTransferBytes(params);
    }
}

