/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.pipe;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.sync.SyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.index.ComparableConsensusRequest;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStatus;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.commons.utils.KillPoint.DataNodeKillPoints;
import org.apache.iotdb.commons.utils.KillPoint.KillPoint;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.config.PipeConsensusConfig;
import org.apache.iotdb.consensus.exception.ConsensusGroupModifyPeerException;
import org.apache.iotdb.consensus.pipe.PipeConsensusPeerManager;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeManager;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeName;
import org.apache.iotdb.consensus.pipe.consensuspipe.ReplicateProgressManager;
import org.apache.iotdb.consensus.pipe.metric.PipeConsensusServerMetrics;
import org.apache.iotdb.consensus.pipe.thrift.TCheckConsensusPipeCompletedReq;
import org.apache.iotdb.consensus.pipe.thrift.TCheckConsensusPipeCompletedResp;
import org.apache.iotdb.consensus.pipe.thrift.TNotifyPeerToCreateConsensusPipeReq;
import org.apache.iotdb.consensus.pipe.thrift.TNotifyPeerToCreateConsensusPipeResp;
import org.apache.iotdb.consensus.pipe.thrift.TNotifyPeerToDropConsensusPipeReq;
import org.apache.iotdb.consensus.pipe.thrift.TNotifyPeerToDropConsensusPipeResp;
import org.apache.iotdb.consensus.pipe.thrift.TSetActiveReq;
import org.apache.iotdb.consensus.pipe.thrift.TSetActiveResp;
import org.apache.iotdb.consensus.pipe.thrift.TWaitReleaseAllRegionRelatedResourceReq;
import org.apache.iotdb.consensus.pipe.thrift.TWaitReleaseAllRegionRelatedResourceResp;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensusServerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusServerImpl.class);
    private static final long CHECK_TRANSMISSION_COMPLETION_INTERVAL_IN_MILLISECONDS = 2000L;
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();
    private static final long RETRY_WAIT_TIME_IN_MS = 500L;
    private static final long MAX_RETRY_TIMES = 20L;
    private final Peer thisNode;
    private final IStateMachine stateMachine;
    private final Lock stateMachineLock = new ReentrantLock();
    private final PipeConsensusPeerManager peerManager;
    private final AtomicBoolean active;
    private final AtomicBoolean isStarted;
    private final String consensusGroupId;
    private final ConsensusPipeManager consensusPipeManager;
    private final ReplicateProgressManager replicateProgressManager;
    private final IClientManager<TEndPoint, SyncPipeConsensusServiceClient> syncClientManager;
    private final PipeConsensusServerMetrics pipeConsensusServerMetrics;
    private final PipeConsensusConfig.ReplicateMode replicateMode;
    private ProgressIndex cachedProgressIndex = MinimumProgressIndex.INSTANCE;

    public PipeConsensusServerImpl(Peer thisNode, IStateMachine stateMachine, List<Peer> peers, PipeConsensusConfig config, ConsensusPipeManager consensusPipeManager, IClientManager<TEndPoint, SyncPipeConsensusServiceClient> syncClientManager) throws IOException {
        Set<Peer> deepCopyPeersWithoutSelf;
        List<Peer> successfulPipes;
        this.thisNode = thisNode;
        this.stateMachine = stateMachine;
        this.peerManager = new PipeConsensusPeerManager(peers);
        this.active = new AtomicBoolean(true);
        this.isStarted = new AtomicBoolean(false);
        this.consensusGroupId = thisNode.getGroupId().toString();
        this.consensusPipeManager = consensusPipeManager;
        this.replicateProgressManager = config.getPipe().getProgressIndexManager();
        this.syncClientManager = syncClientManager;
        this.pipeConsensusServerMetrics = new PipeConsensusServerMetrics(this);
        this.replicateMode = config.getReplicateMode();
        if (!peers.isEmpty() && (successfulPipes = this.createConsensusPipes(deepCopyPeersWithoutSelf = peers.stream().filter(peer -> !peer.equals(thisNode)).collect(Collectors.toSet()))).size() < deepCopyPeersWithoutSelf.size()) {
            this.updateConsensusPipesStatus(successfulPipes, PipeStatus.DROPPED);
            throw new IOException(String.format("%s cannot create all consensus pipes", thisNode));
        }
    }

    public synchronized void start(boolean startConsensusPipes) throws IOException {
        this.stateMachine.start();
        MetricService.getInstance().addMetricSet((IMetricSet)this.pipeConsensusServerMetrics);
        if (startConsensusPipes) {
            List<Peer> otherPeers = this.peerManager.getOtherPeers(this.thisNode);
            List<Peer> failedPipes = this.updateConsensusPipesStatus(new ArrayList<Peer>(otherPeers), PipeStatus.RUNNING);
            try {
                int i = 0;
                while ((long)i < 20L && !failedPipes.isEmpty()) {
                    failedPipes = this.updateConsensusPipesStatus(failedPipes, PipeStatus.RUNNING);
                    Thread.sleep(500L);
                    ++i;
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("PipeConsensusImpl-peer{}: pipeConsensusImpl thread get interrupted when start consensus pipe. May because IoTDB process is killed.", (Object)this.thisNode);
                throw new IOException(String.format("%s cannot start all consensus pipes", this.thisNode));
            }
            if (!failedPipes.isEmpty()) {
                ArrayList<Peer> successfulPipes = new ArrayList<Peer>(otherPeers);
                successfulPipes.removeAll(failedPipes);
                this.updateConsensusPipesStatus(successfulPipes, PipeStatus.STOPPED);
                throw new IOException(String.format("%s cannot start all consensus pipes", this.thisNode));
            }
        }
        this.isStarted.set(true);
    }

    public synchronized void stop() {
        List<Peer> otherPeers = this.peerManager.getOtherPeers(this.thisNode);
        List<Peer> failedPipes = this.updateConsensusPipesStatus(new ArrayList<Peer>(otherPeers), PipeStatus.STOPPED);
        if (!failedPipes.isEmpty()) {
            LOGGER.warn("{} cannot stop all consensus pipes", (Object)this.thisNode);
        }
        MetricService.getInstance().removeMetricSet((IMetricSet)this.pipeConsensusServerMetrics);
        this.stateMachine.stop();
        this.isStarted.set(false);
    }

    public synchronized void clear() {
        List<Peer> otherPeers = this.peerManager.getOtherPeers(this.thisNode);
        List<Peer> failedPipes = this.updateConsensusPipesStatus(new ArrayList<Peer>(otherPeers), PipeStatus.DROPPED);
        if (!failedPipes.isEmpty()) {
            LOGGER.warn("{} cannot drop all consensus pipes", (Object)this.thisNode);
        }
        MetricService.getInstance().removeMetricSet((IMetricSet)this.pipeConsensusServerMetrics);
        this.peerManager.clear();
        this.stateMachine.stop();
        this.isStarted.set(false);
        this.active.set(false);
    }

    private List<Peer> createConsensusPipes(Set<Peer> peers) {
        return peers.stream().filter(peer -> {
            try {
                if (!peers.equals(this.thisNode)) {
                    this.consensusPipeManager.createConsensusPipe(this.thisNode, (Peer)peer);
                }
                return true;
            }
            catch (Exception e) {
                LOGGER.warn("{}: cannot create consensus pipe between {} and {}", new Object[]{e.getMessage(), this.thisNode, peer, e});
                return false;
            }
        }).collect(Collectors.toList());
    }

    private List<Peer> updateConsensusPipesStatus(List<Peer> peers, PipeStatus status) {
        return peers.stream().filter(peer -> {
            try {
                if (!peer.equals(this.thisNode)) {
                    this.consensusPipeManager.updateConsensusPipe(new ConsensusPipeName(this.thisNode, (Peer)peer), status);
                }
                return false;
            }
            catch (Exception e) {
                LOGGER.warn("{}: cannot update consensus pipe between {} and {} to status {}", new Object[]{e.getMessage(), this.thisNode, peer, status});
                return true;
            }
        }).collect(Collectors.toList());
    }

    public synchronized void checkConsensusPipe(Map<ConsensusPipeName, PipeStatus> existedPipes) {
        PipeStatus expectedStatus = this.isStarted.get() ? PipeStatus.RUNNING : PipeStatus.STOPPED;
        Map expectedPipes = (Map)this.peerManager.getOtherPeers(this.thisNode).stream().collect(ImmutableMap.toImmutableMap(peer -> new ConsensusPipeName(this.thisNode, (Peer)peer), peer -> peer));
        existedPipes.forEach((existedName, existedStatus) -> {
            if (!expectedPipes.containsKey(existedName)) {
                try {
                    LOGGER.warn("{} drop consensus pipe [{}]", (Object)this.consensusGroupId, existedName);
                    this.consensusPipeManager.updateConsensusPipe((ConsensusPipeName)existedName, PipeStatus.DROPPED);
                }
                catch (Exception e) {
                    LOGGER.warn("{} cannot drop consensus pipe [{}]", new Object[]{this.consensusGroupId, existedName, e});
                }
            } else if (!expectedStatus.equals(existedStatus)) {
                try {
                    LOGGER.warn("{} update consensus pipe [{}] to status {}", new Object[]{this.consensusGroupId, existedName, expectedStatus});
                    if (expectedStatus.equals((Object)PipeStatus.RUNNING)) {
                        return;
                    }
                    this.consensusPipeManager.updateConsensusPipe((ConsensusPipeName)existedName, expectedStatus);
                }
                catch (Exception e) {
                    LOGGER.warn("{} cannot update consensus pipe [{}] to status {}", new Object[]{this.consensusGroupId, existedName, expectedStatus, e});
                }
            }
        });
        expectedPipes.forEach((expectedName, expectedPeer) -> {
            if (!existedPipes.containsKey(expectedName)) {
                try {
                    LOGGER.warn("{} create and update consensus pipe [{}] to status {}", new Object[]{this.consensusGroupId, expectedName, expectedStatus});
                    this.consensusPipeManager.createConsensusPipe(this.thisNode, (Peer)expectedPeer);
                    this.consensusPipeManager.updateConsensusPipe((ConsensusPipeName)expectedName, expectedStatus);
                }
                catch (Exception e) {
                    LOGGER.warn("{} cannot create and update consensus pipe [{}] to status {}", new Object[]{this.consensusGroupId, expectedName, expectedStatus, e});
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus write(IConsensusRequest request) {
        this.stateMachineLock.lock();
        try {
            long consensusWriteStartTime = System.nanoTime();
            long getStateMachineLockTime = System.nanoTime();
            this.pipeConsensusServerMetrics.recordGetStateMachineLockTime(getStateMachineLockTime - consensusWriteStartTime);
            long writeToStateMachineStartTime = System.nanoTime();
            if (request instanceof ComparableConsensusRequest) {
                ((ComparableConsensusRequest)request).setProgressIndex(this.replicateProgressManager.assignProgressIndex(this.thisNode.getGroupId()));
            }
            TSStatus result = this.stateMachine.write(request);
            long writeToStateMachineEndTime = System.nanoTime();
            PERFORMANCE_OVERVIEW_METRICS.recordEngineCost(writeToStateMachineEndTime - writeToStateMachineStartTime);
            this.pipeConsensusServerMetrics.recordUserWriteStateMachineTime(writeToStateMachineEndTime - writeToStateMachineStartTime);
            TSStatus tSStatus = result;
            return tSStatus;
        }
        finally {
            this.stateMachineLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus writeOnFollowerReplica(IConsensusRequest request) {
        this.stateMachineLock.lock();
        try {
            long consensusWriteStartTime = System.nanoTime();
            long getStateMachineLockTime = System.nanoTime();
            this.pipeConsensusServerMetrics.recordGetStateMachineLockTime(getStateMachineLockTime - consensusWriteStartTime);
            long writeToStateMachineStartTime = System.nanoTime();
            TSStatus result = this.stateMachine.write(request);
            long writeToStateMachineEndTime = System.nanoTime();
            PERFORMANCE_OVERVIEW_METRICS.recordEngineCost(writeToStateMachineEndTime - writeToStateMachineStartTime);
            this.pipeConsensusServerMetrics.recordReplicaWriteStateMachineTime(writeToStateMachineEndTime - writeToStateMachineStartTime);
            TSStatus tSStatus = result;
            return tSStatus;
        }
        finally {
            this.stateMachineLock.unlock();
        }
    }

    public DataSet read(IConsensusRequest request) {
        return this.stateMachine.read(request);
    }

    public void setRemotePeerActive(Peer peer, boolean isActive, boolean isForDeletionPurpose) throws ConsensusGroupModifyPeerException {
        try (SyncPipeConsensusServiceClient client = (SyncPipeConsensusServiceClient)this.syncClientManager.borrowClient((Object)peer.getEndpoint());){
            try {
                TSetActiveResp res = client.setActive(new TSetActiveReq(peer.getGroupId().convertToTConsensusGroupId(), isActive, isForDeletionPurpose));
                if (!RpcUtils.SUCCESS_STATUS.equals(res.getStatus())) {
                    throw new ConsensusGroupModifyPeerException(String.format("error when set peer %s to active %s. result status: %s", peer, isActive, res.getStatus()));
                }
            }
            catch (Exception e) {
                throw new ConsensusGroupModifyPeerException(String.format("error when set peer %s to active %s", peer, isActive), e);
            }
        }
        catch (ClientManagerException e) {
            if (isForDeletionPurpose) {
                LOGGER.warn("target peer may be down, error when set peer {} to active {}", new Object[]{peer, isActive, e});
            }
            throw new ConsensusGroupModifyPeerException(e);
        }
    }

    public void notifyPeersToCreateConsensusPipes(Peer targetPeer) throws ConsensusGroupModifyPeerException {
        List<Peer> otherPeers = this.peerManager.getOtherPeers(this.thisNode);
        for (Peer peer : otherPeers) {
            if (peer.equals(targetPeer)) continue;
            try {
                SyncPipeConsensusServiceClient client = (SyncPipeConsensusServiceClient)this.syncClientManager.borrowClient((Object)peer.getEndpoint());
                try {
                    TNotifyPeerToCreateConsensusPipeResp resp = client.notifyPeerToCreateConsensusPipe(new TNotifyPeerToCreateConsensusPipeReq(targetPeer.getGroupId().convertToTConsensusGroupId(), targetPeer.getEndpoint(), targetPeer.getNodeId()));
                    if (RpcUtils.SUCCESS_STATUS.equals(resp.getStatus())) continue;
                    throw new ConsensusGroupModifyPeerException(String.format("error when notify peer %s to create consensus pipe", peer));
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("{} cannot notify peer {} to create consensus pipe, may because that peer is unknown currently, please manually check!", new Object[]{this.thisNode, peer, e});
            }
        }
        try {
            this.createConsensusPipeToTargetPeer(targetPeer, false);
        }
        catch (Exception e) {
            LOGGER.warn("{} cannot create consensus pipe to {}, may because target peer is unknown currently, please manually check!", new Object[]{this.thisNode, targetPeer, e});
            throw new ConsensusGroupModifyPeerException(e);
        }
    }

    public synchronized void createConsensusPipeToTargetPeer(Peer targetPeer, boolean needManuallyStart) throws ConsensusGroupModifyPeerException {
        try {
            KillPoint.setKillPoint((Enum)DataNodeKillPoints.ORIGINAL_ADD_PEER_DONE);
            this.consensusPipeManager.createConsensusPipe(this.thisNode, targetPeer, needManuallyStart);
            this.peerManager.addPeer(targetPeer);
        }
        catch (Exception e) {
            LOGGER.warn("{} cannot create consensus pipe to {}", new Object[]{this.thisNode, targetPeer, e});
            throw new ConsensusGroupModifyPeerException(String.format("%s cannot create consensus pipe to %s", this.thisNode, targetPeer), e);
        }
    }

    public void notifyPeersToDropConsensusPipe(Peer targetPeer) throws ConsensusGroupModifyPeerException {
        List<Peer> otherPeers = this.peerManager.getOtherPeers(this.thisNode);
        for (Peer peer : otherPeers) {
            if (peer.equals(targetPeer)) continue;
            try {
                SyncPipeConsensusServiceClient client = (SyncPipeConsensusServiceClient)this.syncClientManager.borrowClient((Object)peer.getEndpoint());
                try {
                    TNotifyPeerToDropConsensusPipeResp resp = client.notifyPeerToDropConsensusPipe(new TNotifyPeerToDropConsensusPipeReq(targetPeer.getGroupId().convertToTConsensusGroupId(), targetPeer.getEndpoint(), targetPeer.getNodeId()));
                    if (RpcUtils.SUCCESS_STATUS.equals(resp.getStatus())) continue;
                    throw new ConsensusGroupModifyPeerException(String.format("error when notify peer %s to drop consensus pipe", peer));
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("{} cannot notify peer {} to drop consensus pipe, may because that peer is unknown currently, please manually check!", new Object[]{this.thisNode, peer, e});
            }
        }
        try {
            this.dropConsensusPipeToTargetPeer(targetPeer);
        }
        catch (Exception e) {
            LOGGER.warn("{} cannot drop consensus pipe to {}, may because target peer is unknown currently, please manually check!", new Object[]{this.thisNode, targetPeer, e});
            throw new ConsensusGroupModifyPeerException(e);
        }
    }

    public synchronized void dropConsensusPipeToTargetPeer(Peer targetPeer) throws ConsensusGroupModifyPeerException {
        try {
            this.consensusPipeManager.dropConsensusPipe(this.thisNode, targetPeer);
            this.peerManager.removePeer(targetPeer);
        }
        catch (Exception e) {
            LOGGER.warn("{} cannot drop consensus pipe to {}", new Object[]{this.thisNode, targetPeer, e});
            throw new ConsensusGroupModifyPeerException(String.format("%s cannot drop consensus pipe to %s", this.thisNode, targetPeer), e);
        }
    }

    public void startOtherConsensusPipesToTargetPeer(Peer targetPeer) throws ConsensusGroupModifyPeerException {
        List<Peer> otherPeers = this.peerManager.getOtherPeers(this.thisNode);
        for (Peer peer : otherPeers) {
            if (peer.equals(targetPeer)) continue;
            try {
                this.consensusPipeManager.updateConsensusPipe(new ConsensusPipeName(peer, targetPeer), PipeStatus.RUNNING);
            }
            catch (Exception e) {
                LOGGER.warn("{} cannot start consensus pipe to {}", new Object[]{peer, targetPeer, e});
            }
        }
    }

    public void waitPeersToTargetPeerTransmissionCompleted(Peer targetPeer) throws ConsensusGroupModifyPeerException {
        boolean isTransmissionCompleted = false;
        boolean isFirstCheckForCurrentPeer = true;
        boolean isFirstCheckForOtherPeers = true;
        try {
            while (!isTransmissionCompleted) {
                Thread.sleep(2000L);
                if (this.isConsensusPipesTransmissionCompleted(Collections.singletonList(new ConsensusPipeName(this.thisNode, targetPeer).toString()), isFirstCheckForCurrentPeer)) {
                    List<Peer> otherPeers = this.peerManager.getOtherPeers(this.thisNode);
                    isTransmissionCompleted = true;
                    for (Peer peer : otherPeers) {
                        if (peer.equals(targetPeer)) continue;
                        isTransmissionCompleted &= this.isRemotePeerConsensusPipesTransmissionCompleted(peer, Collections.singletonList(new ConsensusPipeName(peer, targetPeer).toString()), isFirstCheckForOtherPeers);
                    }
                    isFirstCheckForOtherPeers = false;
                }
                isFirstCheckForCurrentPeer = false;
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("{} is interrupted when waiting for transfer completed", (Object)this.thisNode, (Object)e);
            Thread.currentThread().interrupt();
            throw new ConsensusGroupModifyPeerException(String.format("%s is interrupted when waiting for transfer completed", this.thisNode), e);
        }
    }

    public void waitTargetPeerToPeersTransmissionCompleted(Peer targetPeer) throws ConsensusGroupModifyPeerException {
        boolean isTransmissionCompleted = false;
        boolean isFirstCheck = true;
        try {
            while (!isTransmissionCompleted) {
                Thread.sleep(2000L);
                List<String> consensusPipeNames = this.peerManager.getPeers().stream().filter(peer -> !peer.equals(targetPeer)).map(peer -> new ConsensusPipeName(targetPeer, (Peer)peer).toString()).collect(Collectors.toList());
                isTransmissionCompleted = this.isRemotePeerConsensusPipesTransmissionCompleted(targetPeer, consensusPipeNames, isFirstCheck);
                isFirstCheck = false;
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("{} is interrupted when waiting for transfer completed", (Object)this.thisNode, (Object)e);
            Thread.currentThread().interrupt();
            throw new ConsensusGroupModifyPeerException(String.format("%s is interrupted when waiting for transfer completed", this.thisNode), e);
        }
    }

    private boolean isRemotePeerConsensusPipesTransmissionCompleted(Peer targetPeer, List<String> consensusPipeNames, boolean refreshCachedProgressIndex) {
        boolean bl;
        block9: {
            SyncPipeConsensusServiceClient client = (SyncPipeConsensusServiceClient)this.syncClientManager.borrowClient((Object)targetPeer.getEndpoint());
            try {
                TCheckConsensusPipeCompletedResp resp = client.checkConsensusPipeCompleted(new TCheckConsensusPipeCompletedReq(this.thisNode.getGroupId().convertToTConsensusGroupId(), consensusPipeNames, refreshCachedProgressIndex));
                if (!RpcUtils.SUCCESS_STATUS.equals(resp.getStatus())) {
                    LOGGER.warn("{} cannot check consensus pipes transmission completed to peer {}", (Object)this.thisNode, (Object)targetPeer);
                    throw new ConsensusGroupModifyPeerException(String.format("error when check consensus pipes transmission completed to peer %s", targetPeer));
                }
                bl = resp.isCompleted;
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn("{} cannot check consensus pipes transmission completed", (Object)this.thisNode, (Object)e);
                    return true;
                }
            }
            client.close();
        }
        return bl;
    }

    public boolean isConsensusPipesTransmissionCompleted(List<String> consensusPipeNames) {
        return consensusPipeNames.stream().noneMatch(pipeName -> this.replicateProgressManager.getSyncLagForSpecificConsensusPipe(this.thisNode.getGroupId(), new ConsensusPipeName((String)pipeName)) > 0L);
    }

    public synchronized boolean isConsensusPipesTransmissionCompleted(List<String> consensusPipeNames, boolean refreshCachedProgressIndex) {
        if (refreshCachedProgressIndex) {
            this.cachedProgressIndex = this.cachedProgressIndex.updateToMinimumEqualOrIsAfterProgressIndex(this.replicateProgressManager.getMaxAssignedProgressIndex(this.thisNode.getGroupId()));
        }
        try {
            return consensusPipeNames.stream().noneMatch(name -> this.cachedProgressIndex.isAfter(this.replicateProgressManager.getProgressIndex(new ConsensusPipeName((String)name))));
        }
        catch (PipeException e) {
            LOGGER.info(e.getMessage());
            return false;
        }
    }

    public void waitReleaseAllRegionRelatedResource(Peer targetPeer) throws ConsensusGroupModifyPeerException {
        long checkIntervalInMs = 10000L;
        try (SyncPipeConsensusServiceClient client = (SyncPipeConsensusServiceClient)this.syncClientManager.borrowClient((Object)targetPeer.getEndpoint());){
            while (true) {
                TWaitReleaseAllRegionRelatedResourceResp res = client.waitReleaseAllRegionRelatedResource(new TWaitReleaseAllRegionRelatedResourceReq(targetPeer.getGroupId().convertToTConsensusGroupId()));
                if (res.releaseAllResource) {
                    LOGGER.info("[WAIT RELEASE] {} has released all region related resource", (Object)targetPeer);
                    return;
                }
                LOGGER.info("[WAIT RELEASE] {} is still releasing all region related resource", (Object)targetPeer);
                Thread.sleep(checkIntervalInMs);
            }
        }
        catch (ClientManagerException | TException e) {
            LOGGER.warn(String.format("error when waiting %s to release all region related resource. %s", targetPeer, e.getMessage()), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConsensusGroupModifyPeerException(String.format("thread interrupted when waiting %s to release all region related resource. %s", targetPeer, e.getMessage()), e);
        }
    }

    public boolean hasReleaseAllRegionRelatedResource(ConsensusGroupId groupId) {
        return this.stateMachine.hasReleaseAllRegionRelatedResource(groupId);
    }

    public boolean isReadOnly() {
        return this.stateMachine.isReadOnly();
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void setActive(boolean active) {
        LOGGER.info("set {} active status to {}", (Object)this.thisNode, (Object)active);
        this.active.set(active);
    }

    public boolean containsPeer(Peer peer) {
        return this.peerManager.contains(peer);
    }

    public List<Peer> getPeers() {
        return this.peerManager.getPeers();
    }

    public String getConsensusGroupId() {
        return this.consensusGroupId;
    }

    public long getReplicateMode() {
        return this.replicateMode == PipeConsensusConfig.ReplicateMode.BATCH ? 2L : 1L;
    }

    public Peer getThisNodePeer() {
        return this.thisNode;
    }
}

