/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.page;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.tsfile.compress.ICompressor;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.encrypt.IEncryptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.EncryptionType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageWriter {
    private static final Logger logger = LoggerFactory.getLogger(PageWriter.class);
    private ICompressor compressor;
    private EncryptParameter encryptParam;
    private Encoder timeEncoder;
    private PublicBAOS timeOut = new PublicBAOS();
    private Encoder valueEncoder;
    private PublicBAOS valueOut = new PublicBAOS();
    private Statistics<? extends Serializable> statistics;

    public PageWriter() {
        this((Encoder)null, null);
    }

    public PageWriter(IMeasurementSchema measurementSchema) {
        this(measurementSchema.getTimeEncoder(), measurementSchema.getValueEncoder());
        this.statistics = Statistics.getStatsByType(measurementSchema.getType());
        this.compressor = ICompressor.getCompressor(measurementSchema.getCompressor());
        this.encryptParam = EncryptUtils.getEncryptParameter();
    }

    private PageWriter(Encoder timeEncoder, Encoder valueEncoder) {
        this.timeEncoder = timeEncoder;
        this.valueEncoder = valueEncoder;
        this.encryptParam = EncryptUtils.getEncryptParameter();
    }

    public PageWriter(EncryptParameter encryptParam) {
        this(null, null, encryptParam);
    }

    public PageWriter(IMeasurementSchema measurementSchema, EncryptParameter encryptParam) {
        this(measurementSchema.getTimeEncoder(), measurementSchema.getValueEncoder(), encryptParam);
        this.statistics = Statistics.getStatsByType(measurementSchema.getType());
        this.compressor = ICompressor.getCompressor(measurementSchema.getCompressor());
    }

    private PageWriter(Encoder timeEncoder, Encoder valueEncoder, EncryptParameter encryptParam) {
        this.timeEncoder = timeEncoder;
        this.valueEncoder = valueEncoder;
        this.encryptParam = encryptParam;
    }

    public void write(long time, boolean value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
        this.statistics.update(time, value);
    }

    public void write(long time, short value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
        this.statistics.update(time, (int)value);
    }

    public void write(long time, int value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
        this.statistics.update(time, value);
    }

    public void write(long time, long value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
        this.statistics.update(time, value);
    }

    public void write(long time, float value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
        this.statistics.update(time, value);
    }

    public void write(long time, double value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
        this.statistics.update(time, value);
    }

    public void write(long time, Binary value) {
        this.timeEncoder.encode(time, (ByteArrayOutputStream)this.timeOut);
        this.valueEncoder.encode(value, (ByteArrayOutputStream)this.valueOut);
        this.statistics.update(time, value);
    }

    public void write(long[] timestamps, boolean[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
        this.statistics.update(timestamps, values, batchSize);
    }

    public void write(long[] timestamps, int[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
        this.statistics.update(timestamps, values, batchSize);
    }

    public void write(long[] timestamps, long[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
        this.statistics.update(timestamps, values, batchSize);
    }

    public void write(long[] timestamps, float[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
        this.statistics.update(timestamps, values, batchSize);
    }

    public void write(long[] timestamps, double[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
        this.statistics.update(timestamps, values, batchSize);
    }

    public void write(long[] timestamps, Binary[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.timeEncoder.encode(timestamps[i], (ByteArrayOutputStream)this.timeOut);
            this.valueEncoder.encode(values[i], (ByteArrayOutputStream)this.valueOut);
        }
        this.statistics.update(timestamps, values, batchSize);
    }

    private void prepareEndWriteOnePage() throws IOException {
        this.timeEncoder.flush(this.timeOut);
        this.valueEncoder.flush(this.valueOut);
    }

    public ByteBuffer getUncompressedBytes() throws IOException {
        this.prepareEndWriteOnePage();
        ByteBuffer buffer = ByteBuffer.allocate(this.timeOut.size() + this.valueOut.size() + 4);
        ReadWriteForEncodingUtils.writeUnsignedVarInt(this.timeOut.size(), buffer);
        buffer.put(this.timeOut.getBuf(), 0, this.timeOut.size());
        buffer.put(this.valueOut.getBuf(), 0, this.valueOut.size());
        buffer.flip();
        return buffer;
    }

    public int writePageHeaderAndDataIntoBuff(PublicBAOS pageBuffer, boolean first) throws IOException {
        int compressedSize;
        if (this.statistics.getCount() == 0) {
            return 0;
        }
        ByteBuffer pageData = this.getUncompressedBytes();
        int uncompressedSize = pageData.remaining();
        byte[] compressedBytes = null;
        if (this.compressor.getType().equals((Object)CompressionType.UNCOMPRESSED)) {
            compressedSize = uncompressedSize;
        } else if (this.compressor.getType().equals((Object)CompressionType.GZIP)) {
            compressedBytes = this.compressor.compress(pageData.array(), pageData.position(), uncompressedSize);
            compressedSize = compressedBytes.length;
        } else {
            compressedBytes = new byte[this.compressor.getMaxBytesForCompression(uncompressedSize)];
            compressedSize = this.compressor.compress(pageData.array(), pageData.position(), uncompressedSize, compressedBytes);
        }
        int sizeWithoutStatistic = 0;
        if (first) {
            sizeWithoutStatistic += ReadWriteForEncodingUtils.writeUnsignedVarInt(uncompressedSize, pageBuffer);
            sizeWithoutStatistic += ReadWriteForEncodingUtils.writeUnsignedVarInt(compressedSize, pageBuffer);
        } else {
            ReadWriteForEncodingUtils.writeUnsignedVarInt(uncompressedSize, pageBuffer);
            ReadWriteForEncodingUtils.writeUnsignedVarInt(compressedSize, pageBuffer);
            this.statistics.serialize(pageBuffer);
        }
        IEncryptor encryptor = IEncryptor.getEncryptor(this.encryptParam);
        logger.trace("start to flush a page data into buffer, buffer position {} ", (Object)pageBuffer.size());
        if (this.compressor.getType().equals((Object)CompressionType.UNCOMPRESSED)) {
            if (encryptor.getEncryptionType().equals((Object)EncryptionType.UNENCRYPTED)) {
                try (WritableByteChannel channel = Channels.newChannel(pageBuffer);){
                    channel.write(pageData);
                }
            } else {
                byte[] encryptedBytes = null;
                encryptedBytes = encryptor.encrypt(pageData.array(), pageData.position(), uncompressedSize);
                int encryptedSize = encryptedBytes.length;
                pageBuffer.write(encryptedBytes, 0, encryptedSize);
            }
        } else if (encryptor.getEncryptionType().equals((Object)EncryptionType.UNENCRYPTED)) {
            pageBuffer.write(compressedBytes, 0, compressedSize);
        } else {
            byte[] encryptedBytes = null;
            encryptedBytes = encryptor.encrypt(compressedBytes, 0, compressedSize);
            int encryptedSize = encryptedBytes.length;
            pageBuffer.write(encryptedBytes, 0, encryptedSize);
        }
        logger.trace("start to flush a page data into buffer, buffer position {} ", (Object)pageBuffer.size());
        return sizeWithoutStatistic;
    }

    public long estimateMaxMemSize() {
        return (long)(this.timeOut.size() + this.valueOut.size()) + this.timeEncoder.getMaxByteSize() + this.valueEncoder.getMaxByteSize();
    }

    public void reset(IMeasurementSchema measurementSchema) {
        this.timeOut.reset();
        this.valueOut.reset();
        this.statistics = Statistics.getStatsByType(measurementSchema.getType());
    }

    public void setTimeEncoder(Encoder encoder) {
        this.timeEncoder = encoder;
    }

    public void setValueEncoder(Encoder encoder) {
        this.valueEncoder = encoder;
    }

    public void initStatistics(TSDataType dataType) {
        this.statistics = Statistics.getStatsByType(dataType);
    }

    public long getPointNumber() {
        return this.statistics.getCount();
    }

    public Statistics<? extends Serializable> getStatistics() {
        return this.statistics;
    }
}

