/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.function;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AggregationMergeSortOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.function.PartitionRecognizer;
import org.apache.iotdb.db.queryengine.execution.operator.process.function.partition.PartitionCache;
import org.apache.iotdb.db.queryengine.execution.operator.process.function.partition.PartitionState;
import org.apache.iotdb.db.queryengine.execution.operator.process.function.partition.Slice;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.iotdb.udf.api.relational.table.processor.TableFunctionDataProcessor;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.LongColumn;
import org.apache.tsfile.read.common.block.column.LongColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TableFunctionOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AggregationMergeSortOperator.class);
    private static final int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    private final OperatorContext operatorContext;
    private final Operator inputOperator;
    private final TableFunctionProcessorProvider processorProvider;
    private final PartitionRecognizer partitionRecognizer;
    private final TsBlockBuilder properBlockBuilder;
    private final int properChannelCount;
    private final boolean needPassThrough;
    private final PartitionCache partitionCache;
    private final boolean requireRecordSnapshot;
    private final boolean isDeclaredAsPassThrough;
    private TableFunctionDataProcessor processor;
    private PartitionState partitionState;
    private ListenableFuture<?> isBlocked;
    private boolean finished = false;
    private final Queue<TsBlock> resultTsBlocks;

    public TableFunctionOperator(OperatorContext operatorContext, TableFunctionProcessorProvider processorProvider, Operator inputOperator, List<TSDataType> inputDataTypes, List<TSDataType> outputDataTypes, int properChannelCount, List<Integer> requiredChannels, List<Integer> passThroughChannels, boolean isDeclaredAsPassThrough, List<Integer> partitionChannels, boolean requireRecordSnapshot) {
        this.operatorContext = operatorContext;
        this.inputOperator = inputOperator;
        this.properChannelCount = properChannelCount;
        this.processorProvider = processorProvider;
        this.partitionRecognizer = new PartitionRecognizer(partitionChannels, requiredChannels, passThroughChannels, inputDataTypes);
        this.isDeclaredAsPassThrough = isDeclaredAsPassThrough;
        this.needPassThrough = properChannelCount != outputDataTypes.size();
        this.partitionState = null;
        this.properBlockBuilder = new TsBlockBuilder(outputDataTypes.subList(0, properChannelCount));
        this.partitionCache = new PartitionCache();
        this.resultTsBlocks = new LinkedList<TsBlock>();
        this.requireRecordSnapshot = requireRecordSnapshot;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.isBlocked == null) {
            this.isBlocked = this.tryGetNextTsBlock();
        }
        return this.isBlocked;
    }

    private ListenableFuture<?> tryGetNextTsBlock() {
        try {
            if (this.inputOperator.isFinished()) {
                this.partitionRecognizer.noMoreData();
                return NOT_BLOCKED;
            }
            if (!this.inputOperator.isBlocked().isDone()) {
                return this.inputOperator.isBlocked();
            }
            if (this.inputOperator.hasNextWithTimer()) {
                this.partitionRecognizer.addTsBlock(this.inputOperator.nextWithTimer());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return NOT_BLOCKED;
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.resultTsBlocks.isEmpty()) {
            return this.resultTsBlocks.poll();
        }
        if (this.partitionState == null) {
            this.partitionState = this.partitionRecognizer.nextState();
        }
        PartitionState.StateType stateType = this.partitionState.getStateType();
        Slice slice = this.partitionState.getSlice();
        if (stateType == PartitionState.StateType.INIT || stateType == PartitionState.StateType.NEED_MORE_DATA) {
            this.consumeCurrentPartitionState();
            this.consumeCurrentSourceTsBlock();
            return null;
        }
        List<ColumnBuilder> properColumnBuilders = this.getProperColumnBuilders();
        ColumnBuilder passThroughIndexBuilder = this.getPassThroughIndexBuilder();
        if (stateType == PartitionState.StateType.FINISHED) {
            if (this.processor != null) {
                this.processor.finish(properColumnBuilders, passThroughIndexBuilder);
            }
            this.finished = true;
            this.resultTsBlocks.addAll(this.buildTsBlock(properColumnBuilders, passThroughIndexBuilder));
            this.partitionCache.clear();
            this.consumeCurrentPartitionState();
            return this.resultTsBlocks.poll();
        }
        if (stateType == PartitionState.StateType.NEW_PARTITION) {
            if (this.processor != null) {
                this.processor.finish(properColumnBuilders, passThroughIndexBuilder);
                this.resultTsBlocks.addAll(this.buildTsBlock(properColumnBuilders, passThroughIndexBuilder));
                this.partitionCache.clear();
                this.processor.beforeDestroy();
                this.processor = null;
                return this.resultTsBlocks.poll();
            }
            this.processor = this.processorProvider.getDataProcessor();
            this.processor.beforeStart();
        }
        this.partitionCache.addSlice(slice);
        Iterator<Record> recordIterator = slice.getRequiredRecordIterator(this.requireRecordSnapshot);
        while (recordIterator.hasNext()) {
            this.processor.process(recordIterator.next(), properColumnBuilders, passThroughIndexBuilder);
        }
        this.consumeCurrentPartitionState();
        this.resultTsBlocks.addAll(this.buildTsBlock(properColumnBuilders, passThroughIndexBuilder));
        return this.resultTsBlocks.poll();
    }

    private List<ColumnBuilder> getProperColumnBuilders() {
        return Arrays.asList(this.properBlockBuilder.getValueColumnBuilders());
    }

    private ColumnBuilder getPassThroughIndexBuilder() {
        return this.isDeclaredAsPassThrough ? new LongColumnBuilder(null, 1) : null;
    }

    private List<TsBlock> buildTsBlock(List<ColumnBuilder> properColumnBuilders, ColumnBuilder passThroughIndexBuilder) {
        int positionCount = 0;
        if (this.properChannelCount > 0) {
            positionCount = properColumnBuilders.get(0).getPositionCount();
        } else if (this.isDeclaredAsPassThrough) {
            positionCount = passThroughIndexBuilder.getPositionCount();
        }
        if (positionCount == 0) {
            return Collections.emptyList();
        }
        this.properBlockBuilder.declarePositions(positionCount);
        TsBlock properBlock = this.properBlockBuilder.build((Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, positionCount));
        ArrayList<TsBlock> result = new ArrayList<TsBlock>();
        if (this.needPassThrough) {
            int builtCount = 0;
            Object passThroughIndex = this.isDeclaredAsPassThrough ? passThroughIndexBuilder.build() : new RunLengthEncodedColumn((Column)new LongColumn(1, Optional.empty(), new long[]{0L}), positionCount);
            for (Column[] passThroughColumns : this.partitionCache.getPassThroughResult((Column)passThroughIndex)) {
                int subBlockPositionCount = passThroughColumns[0].getPositionCount();
                TsBlock subProperBlock = properBlock.getRegion(builtCount, subBlockPositionCount);
                builtCount += subBlockPositionCount;
                result.add(subProperBlock.appendValueColumns(passThroughColumns));
            }
        } else {
            result.add(properBlock);
        }
        this.properBlockBuilder.reset();
        return result;
    }

    private void consumeCurrentPartitionState() {
        this.partitionState = null;
    }

    private void consumeCurrentSourceTsBlock() {
        this.isBlocked = null;
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.finished || !this.resultTsBlocks.isEmpty();
    }

    @Override
    public void close() throws Exception {
        this.partitionCache.close();
        this.inputOperator.close();
        if (this.processor != null) {
            this.processor.beforeDestroy();
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.finished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.inputOperator.calculateMaxPeekMemory() + Math.max((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, this.properBlockBuilder.getRetainedSizeInBytes());
    }

    @Override
    public long calculateMaxReturnSize() {
        return Math.max((long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, this.properBlockBuilder.getRetainedSizeInBytes());
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.inputOperator.calculateRetainedSizeAfterCallingNext();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.inputOperator) + this.properBlockBuilder.getRetainedSizeInBytes() + this.partitionCache.getEstimatedSize();
    }
}

