/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.data;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.tool.data.AbstractDataTool;
import org.apache.thrift.TException;

public abstract class AbstractExportData
extends AbstractDataTool {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);

    public abstract void init() throws IoTDBConnectionException, StatementExecutionException, TException;

    public abstract void exportBySql(String var1, int var2);

    protected static void legalCheck(String sql) {
        String aggregatePattern = "\\b(count|sum|avg|extreme|max_value|min_value|first_value|last_value|max_time|min_time|stddev|stddev_pop|stddev_samp|variance|var_pop|var_samp|max_by|min_by)\\b\\s*\\(";
        Pattern pattern = Pattern.compile(aggregatePattern, 2);
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            ioTPrinter.println("The sql you entered is invalid, please don't use aggregate query.");
            System.exit(1);
        }
    }

    protected static String timeTrans(Long time) {
        switch (timeFormat) {
            case "default": {
                return RpcUtils.parseLongToDateWithPrecision((DateTimeFormatter)DateTimeFormatter.ISO_OFFSET_DATE_TIME, (long)time, (ZoneId)zoneId, (String)timestampPrecision);
            }
            case "timestamp": 
            case "long": 
            case "number": {
                return String.valueOf(time);
            }
        }
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), zoneId).format(DateTimeFormatter.ofPattern(timeFormat));
    }
}

