/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.Metric;

public class StepTracker {
    private static final ThreadLocal<Map<String, Metric>> metrics = new ThreadLocal();

    public static void trace(String stepName, long startTime, long endTime) {
        if (metrics.get() == null) {
            metrics.set(new HashMap());
        }
        metrics.get().computeIfAbsent(stepName, Metric::new).trace(startTime, endTime);
        metrics.get().get(stepName).tryPrint();
    }

    public static void trace(String stepName, int printRate, long startTime, long endTime) {
        if (metrics.get() == null) {
            metrics.set(new HashMap());
        }
        metrics.get().computeIfAbsent(stepName, key -> new Metric(stepName, printRate)).trace(startTime, endTime);
        metrics.get().get(stepName).tryPrint();
    }

    public static void cleanup() {
        metrics.remove();
    }
}

