/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.iotdb.db.utils;

import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.NonAlignedFullPath;
import org.apache.iotdb.commons.path.PartialPath;

import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class SchemaTestUtils {

  public static MeasurementPath getMeasurementPath(String pathPatternString)
      throws MetadataException {
    PartialPath path = new PartialPath(pathPatternString);
    return new MeasurementPath(
        path,
        new MeasurementSchema(
            path.getMeasurement(),
            TSDataType.DOUBLE,
            TSEncoding.PLAIN,
            CompressionType.UNCOMPRESSED));
  }

  public static NonAlignedFullPath getNonAlignedFullPath(String pathPatternString)
      throws MetadataException {
    PartialPath path = new MeasurementPath(pathPatternString);
    return new NonAlignedFullPath(
        path.getIDeviceID(),
        new MeasurementSchema(
            path.getMeasurement(),
            TSDataType.DOUBLE,
            TSEncoding.PLAIN,
            CompressionType.UNCOMPRESSED));
  }
}
