/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;
import org.apache.nifi.web.api.entity.ParameterProvidersEntity;

public class ParamProvidersResult
extends AbstractWritableResult<ParameterProvidersEntity> {
    private final ParameterProvidersEntity parameterProviders;

    public ParamProvidersResult(ResultType resultType, ParameterProvidersEntity parameterProviders) {
        super(resultType);
        this.parameterProviders = parameterProviders;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        List parameterProviderEntities = this.parameterProviders.getParameterProviders().stream().sorted(Comparator.comparing(entity -> entity.getComponent().getName())).collect(Collectors.toList());
        Table table = new Table.Builder().column("#", 20, 60, false).column("Id", 20, 60, false).column("Name", 20, 60, false).column("Type", 20, 120, false).build();
        for (int i = 0; i < this.parameterProviders.getParameterProviders().size(); ++i) {
            ParameterProviderEntity parameterProvider = (ParameterProviderEntity)parameterProviderEntities.get(i);
            table.addRow(String.valueOf(i), parameterProvider.getId(), parameterProvider.getComponent().getName(), parameterProvider.getComponent().getType());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public ParameterProvidersEntity getResult() {
        return this.parameterProviders;
    }
}

