/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDependency;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public abstract class AbstractConfigurableComponent
implements ConfigurableComponent {
    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        return Collections.emptySet();
    }

    @Override
    public final PropertyDescriptor getPropertyDescriptor(String descriptorName) {
        PropertyDescriptor specDescriptor = new PropertyDescriptor.Builder().name(descriptorName).build();
        return this.getPropertyDescriptor(specDescriptor);
    }

    private PropertyDescriptor getPropertyDescriptor(PropertyDescriptor specDescriptor) {
        PropertyDescriptor descriptor = this.getSupportedPropertyDescriptor(specDescriptor);
        if (descriptor != null) {
            return descriptor;
        }
        descriptor = this.getSupportedDynamicPropertyDescriptor(specDescriptor.getName());
        if (descriptor != null && !descriptor.isDynamic()) {
            descriptor = new PropertyDescriptor.Builder().fromPropertyDescriptor(descriptor).dynamic(true).build();
        }
        if (descriptor == null) {
            descriptor = new PropertyDescriptor.Builder().fromPropertyDescriptor(specDescriptor).addValidator(Validator.INVALID).dynamic(true).build();
        }
        return descriptor;
    }

    private PropertyDescriptor getSupportedPropertyDescriptor(PropertyDescriptor specDescriptor) {
        List<PropertyDescriptor> supportedDescriptors = this.getSupportedPropertyDescriptors();
        if (supportedDescriptors != null) {
            for (PropertyDescriptor desc : supportedDescriptors) {
                if (!specDescriptor.equals(desc)) continue;
                return desc;
            }
        }
        return null;
    }

    @Override
    public final Collection<ValidationResult> validate(ValidationContext context) {
        Collection<ValidationResult> customResults;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        Set<PropertyDescriptor> contextDescriptors = context.getProperties().keySet();
        for (PropertyDescriptor descriptor : contextDescriptors) {
            ValidationResult result;
            boolean dependencySatisfied = context.isDependencySatisfied(descriptor, this::getPropertyDescriptor);
            if (!dependencySatisfied) continue;
            this.validateDependencies(descriptor, context, results);
            String value = context.getProperty(descriptor).getValue();
            if (value == null) {
                value = descriptor.getDefaultValue();
            }
            if (value == null && descriptor.isRequired()) {
                String displayName = descriptor.getDisplayName();
                ValidationResult.Builder builder = new ValidationResult.Builder().valid(false).input(null).subject(displayName != null ? displayName : descriptor.getName());
                builder = displayName != null ? builder.explanation(displayName + " is required") : builder.explanation(descriptor.getName() + " is required");
                results.add(builder.build());
                continue;
            }
            if (value == null || (result = descriptor.validate(value, context)).isValid()) continue;
            results.add(result);
        }
        if (results.isEmpty() && null != (customResults = this.customValidate(context))) {
            for (ValidationResult result : customResults) {
                if (result.isValid()) continue;
                results.add(result);
            }
        }
        return results;
    }

    private void validateDependencies(PropertyDescriptor descriptor, ValidationContext context, Collection<ValidationResult> results) {
        Set<PropertyDependency> dependencies = descriptor.getDependencies();
        for (PropertyDependency dependency : dependencies) {
            PropertyValue value;
            String dependentPropertyName = dependency.getPropertyName();
            PropertyDescriptor specDescriptor = new PropertyDescriptor.Builder().name(dependentPropertyName).build();
            PropertyDescriptor supportedDescriptor = this.getSupportedPropertyDescriptor(specDescriptor);
            if (supportedDescriptor != null) continue;
            PropertyDescriptor dynamicPropertyDescriptor = this.getSupportedDynamicPropertyDescriptor(dependentPropertyName);
            if (dynamicPropertyDescriptor == null) {
                results.add(new ValidationResult.Builder().subject(descriptor.getDisplayName()).valid(false).explanation("Property depends on property " + dependentPropertyName + ", which is not a known property").build());
            }
            if ((value = context.getProperty(dynamicPropertyDescriptor)) != null && value.isSet()) continue;
            results.add(new ValidationResult.Builder().subject(descriptor.getDisplayName()).valid(false).explanation("Property depends on property " + dependentPropertyName + ", which is not a known property").build());
        }
    }

    @Override
    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return null;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return Collections.emptyList();
    }

    @Override
    public final List<PropertyDescriptor> getPropertyDescriptors() {
        List<PropertyDescriptor> supported = this.getSupportedPropertyDescriptors();
        return supported == null ? Collections.emptyList() : Collections.unmodifiableList(supported);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurableComponent)) {
            return false;
        }
        ConfigurableComponent other = (ConfigurableComponent)obj;
        return this.getIdentifier().equals(other.getIdentifier());
    }

    public int hashCode() {
        return 235 + this.getIdentifier().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getIdentifier() + "]";
    }
}

