/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.protocol.OutlierMetrics;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class SlowPeerReports {
    @Nonnull
    private final Map<String, OutlierMetrics> slowPeers;
    public static final SlowPeerReports EMPTY_REPORT = new SlowPeerReports(ImmutableMap.of());

    private SlowPeerReports(Map<String, OutlierMetrics> slowPeers) {
        this.slowPeers = slowPeers;
    }

    public static SlowPeerReports create(@Nullable Map<String, OutlierMetrics> slowPeers) {
        if (slowPeers == null || slowPeers.isEmpty()) {
            return EMPTY_REPORT;
        }
        return new SlowPeerReports(slowPeers);
    }

    public Map<String, OutlierMetrics> getSlowPeers() {
        return this.slowPeers;
    }

    public boolean haveSlowPeers() {
        return this.slowPeers.size() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SlowPeerReports)) {
            return false;
        }
        SlowPeerReports that = (SlowPeerReports)o;
        return this.slowPeers.equals(that.slowPeers);
    }

    public int hashCode() {
        return this.slowPeers.hashCode();
    }
}

