/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.map.DbAttribute;

public class Qualifier {
    protected final DbRowOp row;
    protected Map<DbAttribute, Object> additionalQualifier;
    protected List<String> nullNames;
    protected boolean optimisticLock;

    protected Qualifier(DbRowOp row) {
        this.row = row;
    }

    public Map<String, Object> getSnapshot() {
        Map<String, Object> idSnapshot = this.row.getChangeId().getIdSnapshot();
        if (this.additionalQualifier == null || this.additionalQualifier.isEmpty()) {
            return new HashMap<String, Object>(idSnapshot);
        }
        HashMap<String, Object> qualifier = new HashMap<String, Object>(this.additionalQualifier.size() + idSnapshot.size());
        AtomicBoolean hasPK = new AtomicBoolean(!idSnapshot.isEmpty());
        idSnapshot.forEach((attr, value) -> {
            if (value != null) {
                qualifier.put((String)attr, value);
            } else {
                hasPK.set(false);
            }
        });
        if (!hasPK.get() || this.optimisticLock) {
            this.additionalQualifier.forEach((attr, value) -> qualifier.put(attr.getName(), value));
        }
        return qualifier;
    }

    public List<DbAttribute> getQualifierAttributes() {
        List<DbAttribute> primaryKeys = this.row.getEntity().getPrimaryKeys();
        if (this.additionalQualifier == null || this.additionalQualifier.isEmpty()) {
            return primaryKeys;
        }
        ArrayList<DbAttribute> attributes = new ArrayList<DbAttribute>();
        Map<String, Object> idSnapshot = this.row.getChangeId().getIdSnapshot();
        AtomicBoolean hasPK = new AtomicBoolean(!idSnapshot.isEmpty());
        primaryKeys.forEach(pk -> {
            if (idSnapshot.get(pk.getName()) != null) {
                attributes.add((DbAttribute)pk);
            } else {
                hasPK.set(false);
            }
        });
        if (!hasPK.get() || this.optimisticLock) {
            attributes.addAll(this.additionalQualifier.keySet());
        }
        return attributes;
    }

    public Collection<String> getNullQualifierNames() {
        if (this.nullNames == null || this.nullNames.isEmpty()) {
            return Collections.emptyList();
        }
        return this.nullNames;
    }

    public void addAdditionalQualifier(DbAttribute dbAttribute, Object value) {
        this.addAdditionalQualifier(dbAttribute, value, false);
    }

    public void addAdditionalQualifier(DbAttribute dbAttribute, Object value, boolean optimisticLock) {
        if (this.additionalQualifier == null) {
            this.additionalQualifier = new HashMap<DbAttribute, Object>();
        }
        this.additionalQualifier.put(dbAttribute, value);
        if (value == null) {
            if (this.nullNames == null) {
                this.nullNames = new ArrayList<String>();
            }
            this.nullNames.add(dbAttribute.getName());
        }
        if (optimisticLock) {
            this.optimisticLock = true;
        }
    }

    public boolean isUsingOptimisticLocking() {
        return this.optimisticLock;
    }

    public boolean isSameBatch(Qualifier other) {
        if (this.additionalQualifier == null) {
            return other.additionalQualifier == null;
        }
        if (this.optimisticLock != other.optimisticLock) {
            return false;
        }
        if (other.additionalQualifier == null) {
            return false;
        }
        if (!this.additionalQualifier.keySet().equals(other.additionalQualifier.keySet())) {
            return false;
        }
        return Objects.equals(this.nullNames, other.nullNames);
    }
}

