/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.inflector.rule;

import org.jvnet.inflector.Rule;

public class SuffixInflectionRule
implements Rule {
    private final String regex;
    private final String singularSuffix;
    private final String pluralSuffix;

    public SuffixInflectionRule(String singularSuffix, String pluralSuffix) {
        this(singularSuffix, singularSuffix, pluralSuffix);
    }

    public SuffixInflectionRule(String suffix, String singularSuffix, String pluralSuffix) {
        this.regex = "(?i).*" + suffix.substring(1) + "$";
        this.singularSuffix = singularSuffix;
        this.pluralSuffix = pluralSuffix;
    }

    public boolean applies(String word) {
        return word.matches(this.regex);
    }

    public String apply(String word) {
        int i = word.lastIndexOf(this.singularSuffix.substring(1));
        return word.substring(0, i) + this.pluralSuffix.substring(1);
    }
}

