/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.bytes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.apache.cayenne.crypto.CayenneCryptoException;
import org.apache.cayenne.crypto.transformer.bytes.BytesDecryptor;

class GzipDecryptor
implements BytesDecryptor {
    private BytesDecryptor delegate;

    public GzipDecryptor(BytesDecryptor delegate) {
        this.delegate = delegate;
    }

    @Override
    public byte[] decrypt(byte[] input, int inputOffset, Key key) {
        byte[] decrypted = this.delegate.decrypt(input, inputOffset, key);
        try {
            return GzipDecryptor.gunzip(decrypted);
        }
        catch (IOException e) {
            throw new CayenneCryptoException("Error uncompressing input", e, new Object[0]);
        }
    }

    static byte[] gunzip(byte[] input) throws IOException {
        int read;
        ByteArrayInputStream zipBytes = new ByteArrayInputStream(input);
        GZIPInputStream in = new GZIPInputStream(zipBytes);
        byte[] out = new byte[input.length * 2];
        int totalRead = 0;
        int resizeBy = input.length;
        while ((read = in.read(out, totalRead, out.length - totalRead - 1)) > 0) {
            if ((totalRead += read) + 1 != out.length) continue;
            out = Arrays.copyOf(out, out.length + resizeBy);
        }
        if (totalRead < out.length) {
            out = Arrays.copyOf(out, totalRead);
        }
        return out;
    }
}

