/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.jexl3.Foo;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.parser.Parser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class JexlTest
extends JexlTestCase {
    static final String METHOD_STRING = "Method string";
    static final String GET_METHOD_STRING = "GetMethod string";

    public JexlTest() {
        super("JexlTest", new JexlBuilder().strict(false).imports(Arrays.asList("java.lang", "java.math")).permissions(null).cache(128).create());
    }

    private void assertExpression(JexlContext jc, String expression, Object expected) {
        JexlExpression e = this.JEXL.createExpression(expression);
        Object actual = e.evaluate(jc);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)expression);
    }

    @Test
    void testAntPropertiesWithMethods() {
        MapContext jc = new MapContext();
        String value = "Stinky Cheese";
        jc.set("maven.bob.food", (Object)"Stinky Cheese");
        this.assertExpression((JexlContext)jc, "maven.bob.food.length()", "Stinky Cheese".length());
        this.assertExpression((JexlContext)jc, "empty(maven.bob.food)", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "size(maven.bob.food)", "Stinky Cheese".length());
        this.assertExpression((JexlContext)jc, "maven.bob.food + ' is good'", "Stinky Cheese is good");
    }

    @Test
    void testArray() {
        int[] array = new int[]{100, 101, 102};
        JexlEngine jexl = this.JEXL;
        MapContext jc = new MapContext();
        jc.set("array", (Object)array);
        JexlExpression expr = jexl.createExpression("array.1");
        Object result = expr.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)101, (Object)result);
        expr = jexl.createExpression("array[1] = 1010");
        result = expr.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)1010, (Object)result, () -> ((JexlExpression)expr).toString());
        expr = jexl.createExpression("array.0");
        result = expr.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)100, (Object)result, () -> ((JexlExpression)expr).toString());
    }

    @Test
    void testAssignment() {
        MapContext jc = new MapContext();
        jc.set("aString", (Object)"Hello");
        Foo foo = new Foo();
        jc.set("foo", (Object)foo);
        Parser parser = new Parser(";");
        parser.parse(null, new JexlFeatures().register(false), "aString = 'World';", null);
        this.assertExpression((JexlContext)jc, "hello = 'world'", "world");
        Assertions.assertEquals((Object)"world", (Object)jc.get("hello"), (String)"hello variable not changed");
        this.assertExpression((JexlContext)jc, "result = 1 + 1", 2);
        Assertions.assertEquals((Object)2, (Object)jc.get("result"), (String)"result variable not changed");
        this.assertExpression((JexlContext)jc, "foo.property1 = '99'", "99");
        Assertions.assertEquals((Object)"99", (Object)foo.getProperty1(), (String)"property not set");
    }

    @Test
    void testBadParse() {
        Assertions.assertThrows(JexlException.class, () -> this.assertExpression((JexlContext)new MapContext(), "empty()", null));
    }

    @Test
    void testBlankStrings() {
        MapContext jc = new MapContext();
        jc.set("bar", (Object)"");
        this.assertExpression((JexlContext)jc, "bar == ''", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "empty bar", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "bar.length() == 0", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "size(bar) == 0", Boolean.TRUE);
    }

    @Test
    void testBoolean() {
        MapContext jc = new MapContext();
        jc.set("foo", (Object)new Foo());
        jc.set("a", (Object)Boolean.TRUE);
        jc.set("b", (Object)Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo.convertBoolean(a==b)", "Boolean : false");
        this.assertExpression((JexlContext)jc, "foo.convertBoolean(a==true)", "Boolean : true");
        this.assertExpression((JexlContext)jc, "foo.convertBoolean(a==false)", "Boolean : false");
        this.assertExpression((JexlContext)jc, "foo.convertBoolean(true==false)", "Boolean : false");
        this.assertExpression((JexlContext)jc, "true eq false", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "true ne false", Boolean.TRUE);
    }

    @Test
    void testBooleanShortCircuitAnd() {
        Foo tester = new Foo();
        MapContext jc = new MapContext();
        jc.set("first", (Object)Boolean.FALSE);
        jc.set("foo", (Object)tester);
        JexlExpression expr = this.JEXL.createExpression("first and foo.trueAndModify");
        expr.evaluate((JexlContext)jc);
        Assertions.assertFalse((boolean)tester.getModified(), (String)"Short circuit failure: rhs evaluated when lhs FALSE");
        tester = new Foo();
        jc.set("first", (Object)Boolean.TRUE);
        jc.set("foo", (Object)tester);
        expr.evaluate((JexlContext)jc);
        Assertions.assertTrue((boolean)tester.getModified(), (String)"Short circuit failure: rhs not evaluated when lhs TRUE");
    }

    @Test
    void testBooleanShortCircuitOr() {
        Foo tester = new Foo();
        MapContext jc = new MapContext();
        jc.set("first", (Object)Boolean.FALSE);
        jc.set("foo", (Object)tester);
        JexlExpression expr = this.JEXL.createExpression("first or foo.trueAndModify");
        expr.evaluate((JexlContext)jc);
        Assertions.assertTrue((boolean)tester.getModified(), (String)"Short circuit failure: rhs not evaluated when lhs FALSE");
        tester = new Foo();
        jc.set("first", (Object)Boolean.TRUE);
        jc.set("foo", (Object)tester);
        expr.evaluate((JexlContext)jc);
        Assertions.assertFalse((boolean)tester.getModified(), (String)"Short circuit failure: rhs evaluated when lhs TRUE");
    }

    @Test
    void testCalculations() {
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        options.setStrict(false);
        options.setStrictArithmetic(false);
        jc.set("stringy", "thingy");
        this.assertExpression(jc, "stringy + 2", "thingy2");
        jc.set("imanull", null);
        this.assertExpression(jc, "imanull + 2", 2);
        this.assertExpression(jc, "imanull + imanull", 0);
        jc.set("n", 0);
        this.assertExpression(jc, "n != null && n != 0", Boolean.FALSE);
    }

    @Test
    void testCharAtBug() {
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        options.setSilent(true);
        jc.set("foo", "abcdef");
        this.assertExpression(jc, "foo.substring(2,4)", "cd");
        this.assertExpression(jc, "foo.charAt(2)", Character.valueOf('c'));
        this.assertExpression(jc, "foo.charAt(-2)", null);
    }

    @Test
    void testCoercionWithComparisonOperators() {
        MapContext jc = new MapContext();
        this.assertExpression((JexlContext)jc, "'2' > 1", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "'2' >= 1", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "'2' >= 2", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "'2' < 1", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "'2' <= 1", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "'2' <= 2", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "2 > '1'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "2 >= '1'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "2 >= '2'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "2 < '1'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "2 <= '1'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "2 <= '2'", Boolean.TRUE);
    }

    @Test
    void testComment() {
        this.assertExpression((JexlContext)new MapContext(), "## double or nothing\n 1 + 1", Integer.valueOf("2"));
    }

    @Test
    void testComparisons() {
        MapContext jc = new MapContext();
        jc.set("foo", (Object)"the quick and lazy fox");
        this.assertExpression((JexlContext)jc, "foo.indexOf('quick') > 0", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo.indexOf('bar') >= 0", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo.indexOf('bar') < 0", Boolean.TRUE);
    }

    @Test
    void testConditions() {
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        jc.set("foo", 2);
        jc.set("aFloat", Float.valueOf(1.0f));
        jc.set("aDouble", 2.0);
        jc.set("aChar", Character.valueOf('A'));
        jc.set("aBool", Boolean.TRUE);
        StringBuilder buffer = new StringBuilder("abc");
        ArrayList list = new ArrayList();
        LinkedList list2 = new LinkedList();
        jc.set("aBuffer", buffer);
        jc.set("aList", list);
        jc.set("bList", list2);
        this.assertExpression(jc, "foo == 2", Boolean.TRUE);
        this.assertExpression(jc, "2 == 3", Boolean.FALSE);
        this.assertExpression(jc, "3 == foo", Boolean.FALSE);
        this.assertExpression(jc, "3 != foo", Boolean.TRUE);
        this.assertExpression(jc, "foo != 2", Boolean.FALSE);
        this.assertExpression(jc, "aFloat eq aDouble", Boolean.FALSE);
        this.assertExpression(jc, "aFloat ne aDouble", Boolean.TRUE);
        this.assertExpression(jc, "aFloat == aDouble", Boolean.FALSE);
        this.assertExpression(jc, "aFloat != aDouble", Boolean.TRUE);
        this.assertExpression(jc, "foo == aChar", Boolean.FALSE);
        this.assertExpression(jc, "foo != aChar", Boolean.TRUE);
        this.assertExpression(jc, "aBool == 'true'", Boolean.TRUE);
        this.assertExpression(jc, "aBool == 'false'", Boolean.FALSE);
        this.assertExpression(jc, "aBool != 'false'", Boolean.TRUE);
        options.setStrict(false);
        this.assertExpression(jc, "aBool == notThere", Boolean.FALSE);
        this.assertExpression(jc, "aBool != notThere", Boolean.TRUE);
        options.setStrict(true);
        this.assertExpression(jc, "aBuffer == 'abc'", Boolean.TRUE);
        this.assertExpression(jc, "aBuffer != 'abc'", Boolean.FALSE);
        this.assertExpression(jc, "aList == bList", Boolean.TRUE);
        this.assertExpression(jc, "aList != bList", Boolean.FALSE);
    }

    @Test
    void testDuck() {
        JexlEngine jexl = this.JEXL;
        MapContext jc = new MapContext();
        jc.set("duck", (Object)new Duck());
        JexlExpression expr = jexl.createExpression("duck.zero");
        Object result = expr.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)0, (Object)result, () -> ((JexlExpression)expr).toString());
        expr = jexl.createExpression("duck.one");
        result = expr.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)1, (Object)result, () -> ((JexlExpression)expr).toString());
        expr = jexl.createExpression("duck.user = 20");
        result = expr.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)20, (Object)result, () -> ((JexlExpression)expr).toString());
        expr = jexl.createExpression("duck.user");
        result = expr.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)20, (Object)result, () -> ((JexlExpression)expr).toString());
        expr = jexl.createExpression("duck.user = 'zero'");
        result = expr.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)"zero", (Object)result, () -> ((JexlExpression)expr).toString());
        expr = jexl.createExpression("duck.user");
        result = expr.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)0, (Object)result, () -> ((JexlExpression)expr).toString());
    }

    @Test
    void testEmpty() {
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        options.setStrict(false);
        jc.set("string", "");
        jc.set("array", new Object[0]);
        jc.set("map", new HashMap());
        jc.set("list", new ArrayList());
        jc.set("set", new HashMap().keySet());
        jc.set("longstring", "thingthing");
        this.assertExpression(jc, "empty nullthing", Boolean.TRUE);
        this.assertExpression(jc, "empty string", Boolean.TRUE);
        this.assertExpression(jc, "empty array", Boolean.TRUE);
        this.assertExpression(jc, "empty map", Boolean.TRUE);
        this.assertExpression(jc, "empty set", Boolean.TRUE);
        this.assertExpression(jc, "empty list", Boolean.TRUE);
        this.assertExpression(jc, "empty longstring", Boolean.FALSE);
        this.assertExpression(jc, "not empty longstring", Boolean.TRUE);
    }

    @Test
    void testEmptyDottedVariableName() {
        MapContext jc = new MapContext();
        jc.set("this.is.a.test", (Object)"");
        this.assertExpression((JexlContext)jc, "empty(this.is.a.test)", Boolean.TRUE);
    }

    @Test
    void testEmptySubListOfMap() {
        MapContext jc = new MapContext();
        HashMap m = new HashMap();
        m.put("aList", new ArrayList());
        jc.set("aMap", m);
        this.assertExpression((JexlContext)jc, "empty( aMap.aList )", Boolean.TRUE);
    }

    @Test
    void testExpression() {
        MapContext jc = new MapContext();
        jc.set("foo", (Object)new Foo());
        jc.set("a", (Object)Boolean.TRUE);
        jc.set("b", (Object)Boolean.FALSE);
        jc.set("num", (Object)5);
        jc.set("now", (Object)Calendar.getInstance().getTime());
        GregorianCalendar gc = new GregorianCalendar(5000, 11, 20);
        jc.set("now2", (Object)gc.getTime());
        jc.set("bdec", (Object)new BigDecimal("7"));
        jc.set("bint", (Object)new BigInteger("7"));
        this.assertExpression((JexlContext)jc, "a == b", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "a==true", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "a==false", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "true==false", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "2 < 3", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num < 5", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num < num", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num < null", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num < 2.5", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "now2 < now", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "'6' <= '5'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num <= 5", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num <= num", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num <= null", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num <= 2.5", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "now2 <= now", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "'6' >= '5'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num >= 5", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num >= num", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num >= null", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num >= 2.5", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "now2 >= now", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "'6' > '5'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num > 4", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num > num", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num > null", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num > 2.5", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "now2 > now", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "\"foo\" + \"bar\" == \"foobar\"", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "bdec > num", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "bdec >= num", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num <= bdec", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num < bdec", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "bint > num", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "bint == bdec", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "bint >= num", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num <= bint", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num < bint", Boolean.TRUE);
    }

    @Test
    void testIntProperty() {
        Foo foo = new Foo();
        Assertions.assertEquals((int)4, (int)foo.square(2));
        Assertions.assertEquals((int)4, (int)foo.square(-2));
        MapContext jc = new MapContext();
        jc.set("foo", (Object)foo);
        this.assertExpression((JexlContext)jc, "foo.count", 5);
        this.assertExpression((JexlContext)jc, "foo.square(2)", 4);
        this.assertExpression((JexlContext)jc, "foo.square(-2)", 4);
    }

    @Test
    void testLogicExpressions() {
        MapContext jc = new MapContext();
        jc.set("foo", (Object)"abc");
        jc.set("bar", (Object)"def");
        this.assertExpression((JexlContext)jc, "foo == 'abc' || bar == 'abc'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo == 'abc' or bar == 'abc'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo == 'abc' && bar == 'abc'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo == 'abc' and bar == 'abc'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo == 'def' || bar == 'abc'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo == 'def' or bar == 'abc'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo == 'abc' && bar == 'def'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo == 'abc' and bar == 'def'", Boolean.TRUE);
    }

    @Test
    void testMapDot() {
        HashMap<String, String> foo = new HashMap<String, String>();
        foo.put("bar", "123");
        MapContext jc = new MapContext();
        jc.set("foo", foo);
        this.assertExpression((JexlContext)jc, "foo.bar", "123");
    }

    @Test
    void testNegativeIntComparison() {
        MapContext jc = new MapContext();
        Foo foo = new Foo();
        jc.set("foo", (Object)foo);
        this.assertExpression((JexlContext)jc, "foo.count != -1", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo.count == 5", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo.count == -1", Boolean.FALSE);
    }

    @Test
    void testNew() {
        MapContext jc = new MapContext();
        jc.set("double", Double.class);
        jc.set("foo", (Object)"org.apache.commons.jexl3.Foo");
        JexlExpression expr = this.JEXL.createExpression("new(double, 1)");
        Object value = expr.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)1.0, (Object)value, () -> ((JexlExpression)expr).toString());
        expr = this.JEXL.createExpression("new('java.lang.Float', 100)");
        value = expr.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)Float.valueOf(100.0f), (Object)value, () -> ((JexlExpression)expr).toString());
        expr = this.JEXL.createExpression("new(foo).quux");
        value = expr.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)"String : quux", (Object)value, () -> ((JexlExpression)expr).toString());
    }

    @Test
    void testNewImports() {
        JexlEngine jexl = new JexlBuilder().imports(new String[]{"java.lang", "java.util"}).create();
        JexlExpression expr = jexl.createExpression("new LinkedList([1,2,3,...])");
        Object result = expr.evaluate(null);
        Assertions.assertInstanceOf(LinkedList.class, (Object)result);
    }

    @Test
    void testNotConditions() {
        MapContext jc = new MapContext();
        Foo foo = new Foo();
        jc.set("x", (Object)Boolean.TRUE);
        jc.set("foo", (Object)foo);
        jc.set("bar", (Object)"true");
        this.assertExpression((JexlContext)jc, "!x", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "x", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "!bar", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "!foo.isSimple()", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo.isSimple()", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "!foo.simple", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo.simple", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo.getCheeseList().size() == 3", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo.cheeseList.size() == 3", Boolean.TRUE);
        jc.set("string", (Object)"");
        this.assertExpression((JexlContext)jc, "not empty string", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "not(empty string)", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "not empty(string)", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "! empty string", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "!(empty string)", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "! empty(string)", Boolean.FALSE);
    }

    @Test
    void testNotConditionsWithDots() {
        MapContext jc = new MapContext();
        jc.set("x.a", (Object)Boolean.TRUE);
        jc.set("x.b", (Object)Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "x.a", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "!x.a", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "!x.b", Boolean.TRUE);
    }

    @Test
    void testNull() {
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        options.setStrict(false);
        jc.set("bar", 2);
        this.assertExpression(jc, "empty foo", Boolean.TRUE);
        this.assertExpression(jc, "bar == null", Boolean.FALSE);
        this.assertExpression(jc, "foo == null", Boolean.TRUE);
        this.assertExpression(jc, "bar != null", Boolean.TRUE);
        this.assertExpression(jc, "foo != null", Boolean.FALSE);
        this.assertExpression(jc, "empty(bar)", Boolean.FALSE);
        this.assertExpression(jc, "empty(foo)", Boolean.TRUE);
    }

    @Test
    void testProperty() {
        JexlExpression e = this.JEXL.createExpression("foo.bar");
        MapContext jc = new MapContext();
        jc.set("foo", (Object)new Foo());
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertInstanceOf(String.class, (Object)o, (String)"o not instanceof String");
        Assertions.assertEquals((Object)GET_METHOD_STRING, (Object)o, (String)"o incorrect");
    }

    @Test
    void testSize() {
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        options.setStrict(false);
        jc.set("s", "five!");
        jc.set("array", new Object[5]);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("1", 1);
        map.put("2", 2);
        map.put("3", 3);
        map.put("4", 4);
        map.put("5", 5);
        jc.set("map", map);
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("2");
        list.add("3");
        list.add("4");
        list.add("5");
        jc.set("list", list);
        HashSet<String> set = new HashSet<String>(list);
        set.add("1");
        jc.set("set", set);
        BitSet bitset = new BitSet(5);
        jc.set("bitset", bitset);
        this.assertExpression(jc, "size(s)", 5);
        this.assertExpression(jc, "size(array)", 5);
        this.assertExpression(jc, "size(list)", 5);
        this.assertExpression(jc, "size(map)", 5);
        this.assertExpression(jc, "size(set)", 5);
        this.assertExpression(jc, "size(bitset)", 64);
        this.assertExpression(jc, "list.size()", 5);
        this.assertExpression(jc, "map.size()", 5);
        this.assertExpression(jc, "set.size()", 5);
        this.assertExpression(jc, "bitset.size()", 64);
        this.assertExpression(jc, "list.get(size(list) - 1)", "5");
        this.assertExpression(jc, "list[size(list) - 1]", "5");
        this.assertExpression(jc, "list.get(list.size() - 1)", "5");
    }

    @Test
    void testSizeAsProperty() {
        MapContext jc = new MapContext();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("size", "cheese");
        map.put("si & ze", "cheese");
        jc.set("map", map);
        jc.set("foo", (Object)new Foo());
        this.assertExpression((JexlContext)jc, "map['size']", "cheese");
        this.assertExpression((JexlContext)jc, "map['si & ze']", "cheese");
        this.assertExpression((JexlContext)jc, "map.'si & ze'", "cheese");
        this.assertExpression((JexlContext)jc, "map.size()", 2);
        this.assertExpression((JexlContext)jc, "size(map)", 2);
        this.assertExpression((JexlContext)jc, "foo.getSize()", 22);
        this.assertExpression((JexlContext)jc, "foo.'size'", 22);
    }

    @Test
    void testStringConcatenation() {
        MapContext jc = new MapContext();
        jc.set("first", (Object)"Hello");
        jc.set("second", (Object)"World");
        this.assertExpression((JexlContext)jc, "first + ' ' + second", "Hello World");
    }

    @Test
    void testStringLit() {
        MapContext jc = new MapContext();
        jc.set("foo", (Object)new Foo());
        this.assertExpression((JexlContext)jc, "foo.repeat(\"woogie\")", "Repeat : woogie");
    }

    @Test
    void testStringLiterals() {
        MapContext jc = new MapContext();
        jc.set("foo", (Object)"bar");
        this.assertExpression((JexlContext)jc, "foo == \"bar\"", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo == 'bar'", Boolean.TRUE);
    }

    @Test
    void testStringQuoting() {
        MapContext jc = new MapContext();
        this.assertExpression((JexlContext)jc, "'\"Hello\"'", "\"Hello\"");
        this.assertExpression((JexlContext)jc, "\"I'm testing\"", "I'm testing");
    }

    @Test
    void testToString() {
        String code = "abcd";
        JexlExpression expr = this.JEXL.createExpression("abcd");
        Assertions.assertEquals((Object)"abcd", (Object)expr.toString(), (String)"Bad expression value");
    }

    @Test
    void testUnicodeSupport() {
        MapContext jc = new MapContext();
        this.assertExpression((JexlContext)jc, "'x' == '\\u0032?ytkownik'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "'c:\\some\\windows\\path'", "c:\\some\\windows\\path");
        this.assertExpression((JexlContext)jc, "'foo\\u0020bar'", "foo bar");
        this.assertExpression((JexlContext)jc, "'foo\\u0020\\u0020bar'", "foo  bar");
        this.assertExpression((JexlContext)jc, "'\\u0020foobar\\u0020'", " foobar ");
    }

    @Test
    void testVariableNames() {
        MapContext jc = new MapContext();
        jc.set("foo_bar", (Object)"123");
        this.assertExpression((JexlContext)jc, "foo_bar", "123");
    }

    public static final class Duck {
        int user = 10;

        public Integer get(String val) {
            switch (val) {
                case "zero": {
                    return 0;
                }
                case "one": {
                    return 1;
                }
                case "user": {
                    return this.user;
                }
            }
            return -1;
        }

        public void set(String val, Object value) {
            if ("user".equals(val)) {
                this.user = "zero".equals(value) ? 0 : ("one".equals(value) ? 1 : (value instanceof Integer ? (Integer)value : -1));
            }
        }
    }
}

