/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import org.junit.jupiter.api.condition.BooleanExecutionCondition;
import org.junit.jupiter.api.condition.DisabledForJreRange;
import org.junit.jupiter.api.condition.EnabledOnJreCondition;
import org.junit.jupiter.api.condition.JRE;
import org.junit.platform.commons.util.Preconditions;

class DisabledForJreRangeCondition
extends BooleanExecutionCondition<DisabledForJreRange> {
    DisabledForJreRangeCondition() {
        super(DisabledForJreRange.class, EnabledOnJreCondition.ENABLED_ON_CURRENT_JRE, EnabledOnJreCondition.DISABLED_ON_CURRENT_JRE, DisabledForJreRange::disabledReason);
    }

    @Override
    boolean isEnabled(DisabledForJreRange annotation) {
        JRE min = annotation.min();
        JRE max = annotation.max();
        Preconditions.condition(min != JRE.JAVA_8 || max != JRE.OTHER, "You must declare a non-default value for min or max in @DisabledForJreRange");
        Preconditions.condition(max.compareTo(min) >= 0, "@DisabledForJreRange.min must be less than or equal to @DisabledForJreRange.max");
        return !JRE.isCurrentVersionWithinRange(min, max);
    }
}

