/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public class ApacheDS2ConfigurationContentDescriber
implements ITextContentDescriber {
    private static final int MAX_NUMBER_ENTRIES_SEARCH = 10;
    private Dn configEntryDn;
    private Dn directoryServiceDn;

    public ApacheDS2ConfigurationContentDescriber() {
        try {
            this.configEntryDn = new Dn(new String[]{"ou=config"});
            this.directoryServiceDn = new Dn(new String[]{"ads-directoryServiceId=default,ou=config"});
        }
        catch (LdapInvalidDnException ldapInvalidDnException) {}
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        try (LdifReader reader = null;){
            reader = new LdifReader(contents);
            int n = this.isValid(reader);
            return n;
        }
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        try (LdifReader reader = null;){
            reader = new LdifReader(contents);
            int n = this.isValid(reader);
            return n;
        }
    }

    public QualifiedName[] getSupportedOptions() {
        return new QualifiedName[0];
    }

    private int isValid(LdifReader reader) {
        int checkedEntries = 0;
        boolean configEntryFound = false;
        boolean directoryServiceEntryFound = false;
        while (reader.hasNext() && checkedEntries < 10) {
            if (configEntryFound && directoryServiceEntryFound) break;
            LdifEntry entry = reader.next();
            ++checkedEntries;
            if (!configEntryFound && this.configEntryDn.getName().equalsIgnoreCase(entry.getDn().getNormName())) {
                configEntryFound = true;
                continue;
            }
            if (directoryServiceEntryFound || !this.directoryServiceDn.getName().equalsIgnoreCase(entry.getDn().getNormName())) continue;
            directoryServiceEntryFound = true;
        }
        if (configEntryFound && directoryServiceEntryFound) {
            return 2;
        }
        return 0;
    }
}

