/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.serializer;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.agents.plan.JavaFunction;
import org.apache.flink.agents.plan.PythonFunction;
import org.apache.flink.agents.plan.actions.Action;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class ActionJsonSerializer
extends StdSerializer<Action> {
    public static final String CONFIG_TYPE = "__config_type__";
    private static final String PYTHON_FUNC_TYPE = "PythonFunction";
    private static final String JAVA_FUNC_TYPE = "JavaFunction";

    public ActionJsonSerializer() {
        super(Action.class);
    }

    @Override
    public void serialize(Action action, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("name", action.getName());
        if (action.getExec() instanceof JavaFunction) {
            JavaFunction javaFunction = (JavaFunction)action.getExec();
            this.serializeJavaFunction(jsonGenerator, javaFunction);
        } else if (action.getExec() instanceof PythonFunction) {
            PythonFunction pythonFunction = (PythonFunction)action.getExec();
            this.serializePythonFunction(jsonGenerator, pythonFunction);
        } else {
            throw new IllegalArgumentException("Unsupported function type: " + action.getExec().getClass().getName());
        }
        jsonGenerator.writeFieldName("listen_event_types");
        jsonGenerator.writeStartArray();
        for (String eventType : action.getListenEventTypes()) {
            jsonGenerator.writeString(eventType);
        }
        jsonGenerator.writeEndArray();
        Map<String, Object> config = action.getConfig();
        if (config == null) {
            jsonGenerator.writeObjectField("config", null);
        } else {
            jsonGenerator.writeFieldName("config");
            jsonGenerator.writeStartObject();
            String configType = (String)config.get(CONFIG_TYPE);
            if (configType == null) {
                configType = "java";
            } else {
                config.remove(CONFIG_TYPE);
            }
            jsonGenerator.writeStringField(CONFIG_TYPE, configType);
            if (configType.equals("java")) {
                action.getConfig().forEach((name, value) -> {
                    try {
                        jsonGenerator.writeFieldName((String)name);
                        jsonGenerator.writeStartObject();
                        jsonGenerator.writeStringField("@class", value.getClass().getName());
                        jsonGenerator.writeObjectField("value", value);
                        jsonGenerator.writeEndObject();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error writing action: " + name, e);
                    }
                });
            } else if (configType.equals("python")) {
                action.getConfig().forEach((name, value) -> {
                    try {
                        jsonGenerator.writeObjectField((String)name, value);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error writing action: " + name, e);
                    }
                });
            } else {
                throw new IllegalArgumentException(String.format("Unknown config type %s", configType));
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndObject();
    }

    private void serializePythonFunction(JsonGenerator gen, PythonFunction func) throws IOException {
        gen.writeFieldName("exec");
        gen.writeStartObject();
        gen.writeStringField("func_type", PYTHON_FUNC_TYPE);
        gen.writeStringField("module", func.getModule());
        gen.writeStringField("qualname", func.getQualName());
        gen.writeEndObject();
    }

    private void serializeJavaFunction(JsonGenerator gen, JavaFunction func) throws IOException {
        gen.writeFieldName("exec");
        gen.writeStartObject();
        gen.writeStringField("func_type", JAVA_FUNC_TYPE);
        gen.writeStringField("qualname", func.getQualName());
        gen.writeStringField("method_name", func.getMethodName());
        gen.writeArrayFieldStart("parameter_types");
        for (Class<?> paramType : func.getParameterTypes()) {
            gen.writeString(paramType.getName());
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }
}

