/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc;

import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.thrift.TException;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.TsBlockSerde;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.DateUtils;

public class IoTDBRpcDataSet {
    public static final String TIMESTAMP_STR = "Time";
    public static final int START_INDEX = 2;
    public String sql;
    public boolean isClosed = false;
    public IClientRPCService.Iface client;
    public List<String> columnNameList;
    public List<String> columnTypeList;
    public Map<String, Integer> columnOrdinalMap;
    public List<TSDataType> columnTypeDeduplicatedList;
    public int fetchSize;
    public final long timeout;
    public boolean hasCachedRecord = false;
    public boolean lastReadWasNull;
    public int columnSize;
    public long sessionId;
    public long queryId;
    public long statementId;
    public long time;
    public boolean ignoreTimeStamp;
    public boolean moreData;
    public static final TsBlockSerde serde = new TsBlockSerde();
    public List<ByteBuffer> queryResult;
    public TsBlock curTsBlock;
    public int queryResultSize;
    public int queryResultIndex;
    public int tsBlockSize;
    public int tsBlockIndex;
    private final ZoneId zoneId;
    private final String timeFormat;

    public IoTDBRpcDataSet(String sql, List<String> columnNameList, List<String> columnTypeList, Map<String, Integer> columnNameIndex, boolean ignoreTimeStamp, boolean moreData, long queryId, long statementId, IClientRPCService.Iface client, long sessionId, List<ByteBuffer> queryResult, int fetchSize, long timeout, ZoneId zoneId, String timeFormat) {
        this.sessionId = sessionId;
        this.statementId = statementId;
        this.ignoreTimeStamp = ignoreTimeStamp;
        this.sql = sql;
        this.queryId = queryId;
        this.client = client;
        this.fetchSize = fetchSize;
        this.timeout = timeout;
        this.moreData = moreData;
        this.columnSize = columnNameList.size();
        this.columnNameList = new ArrayList<String>();
        this.columnTypeList = new ArrayList<String>();
        if (!ignoreTimeStamp) {
            this.columnNameList.add(TIMESTAMP_STR);
            this.columnTypeList.add(String.valueOf(TSDataType.INT64));
        }
        this.columnOrdinalMap = new HashMap<String, Integer>();
        if (!ignoreTimeStamp) {
            this.columnOrdinalMap.put(TIMESTAMP_STR, 1);
        }
        if (columnNameIndex != null) {
            int i;
            int deduplicatedColumnSize = (int)columnNameIndex.values().stream().distinct().count();
            this.columnTypeDeduplicatedList = new ArrayList<TSDataType>(deduplicatedColumnSize);
            for (i = 0; i < deduplicatedColumnSize; ++i) {
                this.columnTypeDeduplicatedList.add(null);
            }
            for (i = 0; i < columnNameList.size(); ++i) {
                String name = columnNameList.get(i);
                this.columnNameList.add(name);
                this.columnTypeList.add(columnTypeList.get(i));
                if (this.columnOrdinalMap.containsKey(name)) continue;
                int index = columnNameIndex.get(name);
                if (!this.columnOrdinalMap.containsValue(index + 2)) {
                    this.columnTypeDeduplicatedList.set(index, TSDataType.valueOf((String)columnTypeList.get(i)));
                }
                this.columnOrdinalMap.put(name, index + 2);
            }
        } else {
            this.columnTypeDeduplicatedList = new ArrayList<TSDataType>();
            AtomicInteger index = new AtomicInteger(2);
            for (int i = 0; i < columnNameList.size(); ++i) {
                String name = columnNameList.get(i);
                this.columnNameList.add(name);
                String columnType = columnTypeList.get(i);
                this.columnTypeList.add(columnType);
                this.columnOrdinalMap.computeIfAbsent(name, v -> this.addColumnTypeListReturnIndex(index, TSDataType.valueOf((String)columnType)));
            }
        }
        this.queryResult = queryResult;
        this.queryResultSize = 0;
        if (queryResult != null) {
            this.queryResultSize = queryResult.size();
        }
        this.queryResultIndex = 0;
        this.tsBlockSize = 0;
        this.tsBlockIndex = -1;
        this.zoneId = zoneId;
        this.timeFormat = timeFormat;
    }

    public Integer addColumnTypeListReturnIndex(AtomicInteger index, TSDataType dataType) {
        this.columnTypeDeduplicatedList.add(dataType);
        return index.getAndIncrement();
    }

    public IoTDBRpcDataSet(String sql, List<String> columnNameList, List<String> columnTypeList, Map<String, Integer> columnNameIndex, boolean ignoreTimeStamp, boolean moreData, long queryId, long statementId, IClientRPCService.Iface client, long sessionId, List<ByteBuffer> queryResult, int fetchSize, long timeout, List<String> sgList, BitSet aliasColumnMap, ZoneId zoneId, String timeFormat) {
        this.sessionId = sessionId;
        this.statementId = statementId;
        this.ignoreTimeStamp = ignoreTimeStamp;
        this.sql = sql;
        this.queryId = queryId;
        this.client = client;
        this.fetchSize = fetchSize;
        this.timeout = timeout;
        this.moreData = moreData;
        this.columnSize = columnNameList.size();
        this.columnNameList = new ArrayList<String>();
        this.columnTypeList = new ArrayList<String>();
        if (!ignoreTimeStamp) {
            this.columnNameList.add(TIMESTAMP_STR);
            this.columnTypeList.add(String.valueOf(TSDataType.INT64));
        }
        this.columnOrdinalMap = new HashMap<String, Integer>();
        if (!ignoreTimeStamp) {
            this.columnOrdinalMap.put(TIMESTAMP_STR, 1);
        }
        if (columnNameIndex != null) {
            int i;
            int deduplicatedColumnSize = (int)columnNameIndex.values().stream().distinct().count();
            this.columnTypeDeduplicatedList = new ArrayList<TSDataType>(deduplicatedColumnSize);
            for (i = 0; i < deduplicatedColumnSize; ++i) {
                this.columnTypeDeduplicatedList.add(null);
            }
            for (i = 0; i < columnNameList.size(); ++i) {
                String name = sgList != null && !sgList.isEmpty() && (aliasColumnMap == null || !aliasColumnMap.get(i)) ? sgList.get(i) + "." + columnNameList.get(i) : columnNameList.get(i);
                this.columnNameList.add(name);
                this.columnTypeList.add(columnTypeList.get(i));
                if (this.columnOrdinalMap.containsKey(name) && !TIMESTAMP_STR.equals(name)) continue;
                int index = columnNameIndex.get(name);
                if (!this.columnOrdinalMap.containsValue(index + 2)) {
                    this.columnTypeDeduplicatedList.set(index, TSDataType.valueOf((String)columnTypeList.get(i)));
                }
                this.columnOrdinalMap.put(name, index + 2);
            }
        } else {
            this.columnTypeDeduplicatedList = new ArrayList<TSDataType>();
            int index = 2;
            for (int i = 0; i < columnNameList.size(); ++i) {
                String name = columnNameList.get(i);
                this.columnNameList.add(name);
                this.columnTypeList.add(columnTypeList.get(i));
                if (this.columnOrdinalMap.containsKey(name)) continue;
                this.columnOrdinalMap.put(name, index++);
                this.columnTypeDeduplicatedList.add(TSDataType.valueOf((String)columnTypeList.get(i)));
            }
        }
        this.queryResult = queryResult;
        this.queryResultSize = 0;
        if (queryResult != null) {
            this.queryResultSize = queryResult.size();
        }
        this.queryResultIndex = 0;
        this.tsBlockSize = 0;
        this.tsBlockIndex = -1;
        this.zoneId = zoneId;
        this.timeFormat = timeFormat;
    }

    public void close() throws StatementExecutionException, TException {
        if (this.isClosed) {
            return;
        }
        if (this.client != null) {
            try {
                TSCloseOperationReq closeReq = new TSCloseOperationReq(this.sessionId);
                closeReq.setStatementId(this.statementId);
                closeReq.setQueryId(this.queryId);
                TSStatus closeResp = this.client.closeOperation(closeReq);
                RpcUtils.verifySuccess(closeResp);
            }
            catch (StatementExecutionException e) {
                throw new StatementExecutionException("Error occurs for close operation in server side because ", e);
            }
            catch (TException e) {
                throw new TException("Error occurs when connecting to server for close operation ", (Throwable)e);
            }
        }
        this.client = null;
        this.isClosed = true;
    }

    public boolean next() throws StatementExecutionException, IoTDBConnectionException {
        if (this.hasCachedBlock()) {
            this.lastReadWasNull = false;
            this.constructOneRow();
            return true;
        }
        if (this.hasCachedByteBuffer()) {
            this.constructOneTsBlock();
            this.constructOneRow();
            return true;
        }
        if (this.moreData && this.fetchResults() && this.hasCachedByteBuffer()) {
            this.constructOneTsBlock();
            this.constructOneRow();
            return true;
        }
        try {
            this.close();
            return false;
        }
        catch (TException e) {
            throw new IoTDBConnectionException("Cannot close dataset, because of network connection: {} ", e);
        }
    }

    public boolean fetchResults() throws StatementExecutionException, IoTDBConnectionException {
        if (this.isClosed) {
            throw new IoTDBConnectionException("This DataSet is already closed");
        }
        TSFetchResultsReq req = new TSFetchResultsReq(this.sessionId, this.sql, this.fetchSize, this.queryId, true);
        req.setTimeout(this.timeout);
        try {
            TSFetchResultsResp resp = this.client.fetchResultsV2(req);
            RpcUtils.verifySuccess(resp.getStatus());
            this.moreData = resp.moreData;
            if (!resp.hasResultSet) {
                this.close();
            } else {
                this.queryResult = resp.getQueryResult();
                this.queryResultIndex = 0;
                this.queryResultSize = 0;
                if (this.queryResult != null) {
                    this.queryResultSize = this.queryResult.size();
                }
                this.tsBlockSize = 0;
                this.tsBlockIndex = -1;
            }
            return resp.hasResultSet;
        }
        catch (TException e) {
            throw new IoTDBConnectionException("Cannot fetch result from server, because of network connection: {} ", e);
        }
    }

    public boolean hasCachedBlock() {
        return this.curTsBlock != null && this.tsBlockIndex < this.tsBlockSize - 1;
    }

    public boolean hasCachedByteBuffer() {
        return this.queryResult != null && this.queryResultIndex < this.queryResultSize;
    }

    public void constructOneRow() {
        ++this.tsBlockIndex;
        this.hasCachedRecord = true;
        this.time = this.curTsBlock.getTimeColumn().getLong(this.tsBlockIndex);
    }

    public void constructOneTsBlock() {
        this.lastReadWasNull = false;
        ByteBuffer byteBuffer = this.queryResult.get(this.queryResultIndex);
        ++this.queryResultIndex;
        this.curTsBlock = serde.deserialize(byteBuffer);
        this.tsBlockIndex = -1;
        this.tsBlockSize = this.curTsBlock.getPositionCount();
    }

    public boolean isNull(int columnIndex) throws StatementExecutionException {
        int index = this.columnOrdinalMap.get(this.findColumnNameByIndex(columnIndex)) - 2;
        if (index < 0) {
            return false;
        }
        return this.isNull(index, this.tsBlockIndex);
    }

    public boolean isNull(String columnName) {
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (index < 0) {
            return false;
        }
        return this.isNull(index, this.tsBlockIndex);
    }

    private boolean isNull(int index, int rowNum) {
        return this.curTsBlock.getColumn(index).isNull(rowNum);
    }

    public boolean getBoolean(int columnIndex) throws StatementExecutionException {
        return this.getBoolean(this.findColumnNameByIndex(columnIndex));
    }

    public boolean getBoolean(String columnName) throws StatementExecutionException {
        this.checkRecord();
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (!this.isNull(index, this.tsBlockIndex)) {
            this.lastReadWasNull = false;
            return this.curTsBlock.getColumn(index).getBoolean(this.tsBlockIndex);
        }
        this.lastReadWasNull = true;
        return false;
    }

    public double getDouble(int columnIndex) throws StatementExecutionException {
        return this.getDouble(this.findColumnNameByIndex(columnIndex));
    }

    public double getDouble(String columnName) throws StatementExecutionException {
        this.checkRecord();
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (!this.isNull(index, this.tsBlockIndex)) {
            this.lastReadWasNull = false;
            return this.curTsBlock.getColumn(index).getDouble(this.tsBlockIndex);
        }
        this.lastReadWasNull = true;
        return 0.0;
    }

    public float getFloat(int columnIndex) throws StatementExecutionException {
        return this.getFloat(this.findColumnNameByIndex(columnIndex));
    }

    public float getFloat(String columnName) throws StatementExecutionException {
        this.checkRecord();
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (!this.isNull(index, this.tsBlockIndex)) {
            this.lastReadWasNull = false;
            return this.curTsBlock.getColumn(index).getFloat(this.tsBlockIndex);
        }
        this.lastReadWasNull = true;
        return 0.0f;
    }

    public int getInt(int columnIndex) throws StatementExecutionException {
        return this.getInt(this.findColumnNameByIndex(columnIndex));
    }

    public int getInt(String columnName) throws StatementExecutionException {
        this.checkRecord();
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (!this.isNull(index, this.tsBlockIndex)) {
            this.lastReadWasNull = false;
            TSDataType type = this.curTsBlock.getColumn(index).getDataType();
            if (type == TSDataType.INT64) {
                return (int)this.curTsBlock.getColumn(index).getLong(this.tsBlockIndex);
            }
            return this.curTsBlock.getColumn(index).getInt(this.tsBlockIndex);
        }
        this.lastReadWasNull = true;
        return 0;
    }

    public long getLong(int columnIndex) throws StatementExecutionException {
        return this.getLong(this.findColumnNameByIndex(columnIndex));
    }

    public long getLong(String columnName) throws StatementExecutionException {
        this.checkRecord();
        if (columnName.equals(TIMESTAMP_STR)) {
            this.lastReadWasNull = false;
            return this.curTsBlock.getTimeByIndex(this.tsBlockIndex);
        }
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (!this.isNull(index, this.tsBlockIndex)) {
            this.lastReadWasNull = false;
            TSDataType type = this.curTsBlock.getColumn(index).getDataType();
            if (type == TSDataType.INT32) {
                return this.curTsBlock.getColumn(index).getInt(this.tsBlockIndex);
            }
            return this.curTsBlock.getColumn(index).getLong(this.tsBlockIndex);
        }
        this.lastReadWasNull = true;
        return 0L;
    }

    public Binary getBinary(int columIndex) throws StatementExecutionException {
        return this.getBinary(this.findColumnNameByIndex(columIndex));
    }

    public Binary getBinary(String columnName) throws StatementExecutionException {
        this.checkRecord();
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (!this.isNull(index, this.tsBlockIndex)) {
            this.lastReadWasNull = false;
            return this.curTsBlock.getColumn(index).getBinary(this.tsBlockIndex);
        }
        this.lastReadWasNull = true;
        return null;
    }

    public Object getObject(int columnIndex) throws StatementExecutionException {
        return this.getObject(this.findColumnNameByIndex(columnIndex));
    }

    public Object getObject(String columnName) throws StatementExecutionException {
        return this.getObjectByName(columnName);
    }

    public String getString(int columnIndex) throws StatementExecutionException {
        return this.getString(this.findColumnNameByIndex(columnIndex));
    }

    public String getString(String columnName) throws StatementExecutionException {
        return this.getValueByName(columnName);
    }

    public Timestamp getTimestamp(int columnIndex) throws StatementExecutionException {
        return this.getTimestamp(this.findColumnNameByIndex(columnIndex));
    }

    public Timestamp getTimestamp(String columnName) throws StatementExecutionException {
        long longValue = this.getLong(columnName);
        return this.lastReadWasNull ? null : new Timestamp(longValue);
    }

    public LocalDate getDate(int columnIndex) throws StatementExecutionException {
        return this.getDate(this.findColumnNameByIndex(columnIndex));
    }

    public LocalDate getDate(String columnName) throws StatementExecutionException {
        int intValue = this.getInt(columnName);
        return this.lastReadWasNull ? null : DateUtils.parseIntToLocalDate((int)intValue);
    }

    public TSDataType getDataType(int columnIndex) throws StatementExecutionException {
        return this.getDataType(this.findColumnNameByIndex(columnIndex));
    }

    public TSDataType getDataType(String columnName) throws StatementExecutionException {
        if (columnName.equals(TIMESTAMP_STR)) {
            return TSDataType.INT64;
        }
        int index = this.columnOrdinalMap.get(columnName) - 2;
        return index < 0 || index >= this.columnTypeDeduplicatedList.size() ? null : this.columnTypeDeduplicatedList.get(index);
    }

    public int findColumn(String columnName) {
        return this.columnOrdinalMap.get(columnName);
    }

    public String getValueByName(String columnName) throws StatementExecutionException {
        this.checkRecord();
        if (columnName.equals(TIMESTAMP_STR)) {
            this.lastReadWasNull = false;
            return String.valueOf(this.curTsBlock.getTimeByIndex(this.tsBlockIndex));
        }
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (index < 0 || index >= this.columnTypeDeduplicatedList.size() || this.isNull(index, this.tsBlockIndex)) {
            this.lastReadWasNull = true;
            return null;
        }
        this.lastReadWasNull = false;
        return this.getString(index, this.columnTypeDeduplicatedList.get(index));
    }

    public String getString(int index, TSDataType tsDataType) {
        switch (tsDataType) {
            case BOOLEAN: {
                return String.valueOf(this.curTsBlock.getColumn(index).getBoolean(this.tsBlockIndex));
            }
            case INT32: {
                return String.valueOf(this.curTsBlock.getColumn(index).getInt(this.tsBlockIndex));
            }
            case INT64: 
            case TIMESTAMP: {
                return String.valueOf(this.curTsBlock.getColumn(index).getLong(this.tsBlockIndex));
            }
            case FLOAT: {
                return String.valueOf(this.curTsBlock.getColumn(index).getFloat(this.tsBlockIndex));
            }
            case DOUBLE: {
                return String.valueOf(this.curTsBlock.getColumn(index).getDouble(this.tsBlockIndex));
            }
            case TEXT: 
            case STRING: {
                return this.curTsBlock.getColumn(index).getBinary(this.tsBlockIndex).getStringValue(TSFileConfig.STRING_CHARSET);
            }
            case BLOB: {
                return BytesUtils.parseBlobByteArrayToString((byte[])this.curTsBlock.getColumn(index).getBinary(this.tsBlockIndex).getValues());
            }
            case DATE: {
                return DateUtils.formatDate((int)this.curTsBlock.getColumn(index).getInt(this.tsBlockIndex));
            }
        }
        return null;
    }

    public Object getObjectByName(String columnName) throws StatementExecutionException {
        this.checkRecord();
        if (columnName.equals(TIMESTAMP_STR)) {
            this.lastReadWasNull = false;
            return new Timestamp(this.curTsBlock.getTimeByIndex(this.tsBlockIndex));
        }
        int index = this.columnOrdinalMap.get(columnName) - 2;
        if (index < 0 || index >= this.columnTypeDeduplicatedList.size() || this.isNull(index, this.tsBlockIndex)) {
            this.lastReadWasNull = true;
            return null;
        }
        this.lastReadWasNull = false;
        return this.curTsBlock.getColumn(index).getObject(this.tsBlockIndex);
    }

    public String findColumnNameByIndex(int columnIndex) throws StatementExecutionException {
        if (columnIndex <= 0) {
            throw new StatementExecutionException("column index should start from 1");
        }
        if (columnIndex > this.columnNameList.size()) {
            throw new StatementExecutionException(String.format("column index %d out of range %d", columnIndex, this.columnNameList.size()));
        }
        return this.columnNameList.get(columnIndex - 1);
    }

    public void checkRecord() throws StatementExecutionException {
        if (this.queryResultIndex > this.queryResultSize || this.tsBlockIndex >= this.tsBlockSize || this.queryResult == null || this.curTsBlock == null) {
            throw new StatementExecutionException("No record remains");
        }
    }
}

