/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.iotdb.library.dprofile.util.Bucket;

class OnePassBucketizer {
    OnePassBucketizer() {
    }

    static List<Bucket<Pair<Long, Double>>> bucketize(List<Pair<Long, Double>> input, int inputSize, int desiredBuckets) {
        int middleSize = inputSize - 2;
        int bucketSize = middleSize / desiredBuckets;
        int remainingElements = middleSize % desiredBuckets;
        if (bucketSize == 0) {
            throw new IllegalArgumentException("Can't produce " + desiredBuckets + " buckets from an input series of " + (middleSize + 2) + " elements");
        }
        ArrayList<Bucket<Pair<Long, Double>>> buckets = new ArrayList<Bucket<Pair<Long, Double>>>();
        buckets.add(Bucket.of(input.get(0)));
        List<Pair<Long, Double>> rest = input.subList(1, input.size() - 1);
        while (buckets.size() < desiredBuckets + 1) {
            int size = buckets.size() <= remainingElements ? bucketSize + 1 : bucketSize;
            buckets.add(Bucket.of(rest.subList(0, size)));
            rest = rest.subList(size, rest.size());
        }
        buckets.add(Bucket.of(input.get(input.size() - 1)));
        return buckets;
    }
}

