/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.ui;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Iterator;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.fuseki.ctl.ActionContainerItem;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public class ActionStatsTxt
extends ActionContainerItem {
    @Override
    public void validate(HttpAction action) {
    }

    @Override
    protected JsonValue execGetContainer(HttpAction action) {
        this.execContainer(action);
        return null;
    }

    @Override
    protected JsonValue execGetItem(HttpAction action) {
        this.execItem(action);
        return null;
    }

    @Override
    protected JsonValue execPostContainer(HttpAction action) {
        this.execContainer(action);
        return null;
    }

    @Override
    protected JsonValue execPostItem(HttpAction action) {
        this.execItem(action);
        return null;
    }

    private void execContainer(HttpAction action) {
        if (action.verbose) {
            action.log.info(String.format("[%d] GET stats text", action.id));
        }
        try {
            this.statsTxt(action.getResponse(), action.getDataAccessPointRegistry());
        }
        catch (IOException ex) {
            action.log.warn(String.format("[%d] GET stats text: IO error: %s", action.id, ex.getMessage()));
        }
    }

    private void execItem(HttpAction action) {
        DataAccessPoint desc;
        String name = ActionStatsTxt.getItemDatasetName(action);
        if (name == null) {
            ServletOps.errorBadRequest("No dataset name");
        }
        if ((desc = action.getDataAccessPointRegistry().get(name)) == null) {
            ServletOps.errorBadRequest("No such dataset: " + name);
        }
        try {
            HttpServletResponse resp = action.getResponse();
            ServletOutputStream out = resp.getOutputStream();
            resp.setContentType("text/plain");
            resp.setCharacterEncoding("utf-8");
            this.statsTxt(out, desc);
        }
        catch (IOException ex) {
            action.log.warn(String.format("[%d] GET stats text: IO error: %s", action.id, ex.getMessage()));
        }
    }

    private void statsTxt(HttpServletResponse resp, DataAccessPointRegistry registry) throws IOException {
        ServletOutputStream out = resp.getOutputStream();
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("utf-8");
        Iterator iter = registry.keys().iterator();
        while (iter.hasNext()) {
            String ds = (String)iter.next();
            DataAccessPoint desc = registry.get(ds);
            this.statsTxt(out, desc);
            if (!iter.hasNext()) continue;
            out.println();
        }
        out.flush();
    }

    private void statsTxt(ServletOutputStream out, DataAccessPoint desc) throws IOException {
        DataService dSrv = desc.getDataService();
        out.println("Dataset: " + desc.getName());
        out.println("    Requests      = " + dSrv.getCounters().value(CounterName.Requests));
        out.println("    Good          = " + dSrv.getCounters().value(CounterName.RequestsGood));
        out.println("    Bad           = " + dSrv.getCounters().value(CounterName.RequestsBad));
        if (desc.getDataService().hasOperation(Operation.Query)) {
            out.println("  SPARQL Query:");
            out.println("    Request       = " + this.counter(dSrv, Operation.Query, CounterName.Requests));
            out.println("    Good          = " + this.counter(dSrv, Operation.Query, CounterName.RequestsGood));
            out.println("    Bad requests  = " + this.counter(dSrv, Operation.Query, CounterName.RequestsBad));
            out.println("    Timeouts      = " + this.counter(dSrv, Operation.Query, CounterName.QueryTimeouts));
            out.println("    Bad exec      = " + this.counter(dSrv, Operation.Query, CounterName.QueryExecErrors));
        }
        if (desc.getDataService().hasOperation(Operation.Update)) {
            out.println("  SPARQL Update:");
            out.println("    Request       = " + this.counter(dSrv, Operation.Update, CounterName.Requests));
            out.println("    Good          = " + this.counter(dSrv, Operation.Update, CounterName.RequestsGood));
            out.println("    Bad requests  = " + this.counter(dSrv, Operation.Update, CounterName.RequestsBad));
            out.println("    Bad exec      = " + this.counter(dSrv, Operation.Update, CounterName.UpdateExecErrors));
        }
        if (desc.getDataService().hasOperation(Operation.Upload)) {
            out.println("  Upload:");
            out.println("    Requests      = " + this.counter(dSrv, Operation.Upload, CounterName.Requests));
            out.println("    Good          = " + this.counter(dSrv, Operation.Upload, CounterName.RequestsGood));
            out.println("    Bad           = " + this.counter(dSrv, Operation.Upload, CounterName.RequestsBad));
        }
        if (desc.getDataService().hasOperation(Operation.GSP_R) || desc.getDataService().hasOperation(Operation.GSP_RW)) {
            out.println("  SPARQL Graph Store Protocol:");
            out.println("    GETs          = " + this.gspValue(dSrv, CounterName.HTTPget) + " (good=" + this.gspValue(dSrv, CounterName.HTTPgetGood) + "/bad=" + this.gspValue(dSrv, CounterName.HTTPgetBad) + ")");
            if (desc.getDataService().hasOperation(Operation.GSP_RW)) {
                out.println("    PUTs          = " + this.gspValue(dSrv, CounterName.HTTPput) + " (good=" + this.gspValue(dSrv, CounterName.HTTPputGood) + "/bad=" + this.gspValue(dSrv, CounterName.HTTPputBad) + ")");
                out.println("    POSTs         = " + this.gspValue(dSrv, CounterName.HTTPpost) + " (good=" + this.gspValue(dSrv, CounterName.HTTPpostGood) + "/bad=" + this.gspValue(dSrv, CounterName.HTTPpostBad) + ")");
                out.println("    PATCHs        = " + this.gspValue(dSrv, CounterName.HTTPpatch) + " (good=" + this.gspValue(dSrv, CounterName.HTTPpatchGood) + "/bad=" + this.gspValue(dSrv, CounterName.HTTPpatchBad) + ")");
                out.println("    DELETEs       = " + this.gspValue(dSrv, CounterName.HTTPdelete) + " (good=" + this.gspValue(dSrv, CounterName.HTTPdeleteGood) + "/bad=" + this.gspValue(dSrv, CounterName.HTTPdeleteBad) + ")");
            }
            out.println("    HEADs         = " + this.gspValue(dSrv, CounterName.HTTPhead) + " (good=" + this.gspValue(dSrv, CounterName.HTTPheadGood) + "/bad=" + this.gspValue(dSrv, CounterName.HTTPheadBad) + ")");
        }
    }

    private long counter(DataService dSrv, Operation operation, CounterName cName) {
        return 0L;
    }

    private long gspValue(DataService dSrv, CounterName cn) {
        return this.counter(dSrv, Operation.GSP_RW, cn) + this.counter(dSrv, Operation.GSP_R, cn);
    }
}

