/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.queries;

import java.io.File;
import java.net.URI;
import java.util.logging.Logger;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.netbeans.spi.queries.SharabilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class SharabilityQuery {
    private static final Lookup.Result<SharabilityQueryImplementation> implementations = Lookup.getDefault().lookupResult(SharabilityQueryImplementation.class);
    private static final Lookup.Result<SharabilityQueryImplementation2> implementations2 = Lookup.getDefault().lookupResult(SharabilityQueryImplementation2.class);
    private static final Logger LOG = Logger.getLogger(SharabilityQuery.class.getName());
    @Deprecated
    public static final int UNKNOWN = 0;
    @Deprecated
    public static final int SHARABLE = 1;
    @Deprecated
    public static final int NOT_SHARABLE = 2;
    @Deprecated
    public static final int MIXED = 3;

    private SharabilityQuery() {
    }

    @Deprecated
    public static int getSharability(File file) {
        File normFile;
        Parameters.notNull("file", file);
        boolean asserts = false;
        if (!$assertionsDisabled) {
            asserts = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (asserts && !BaseUtilities.isMac() && !file.equals(normFile = FileUtil.normalizeFile(file))) {
            throw new IllegalArgumentException("Must pass a normalized file: " + file + " vs. " + normFile);
        }
        URI uri = null;
        for (SharabilityQueryImplementation2 sharabilityQueryImplementation2 : implementations2.allInstances()) {
            Sharability x;
            if (uri == null) {
                uri = BaseUtilities.toURI(file);
            }
            if ((x = sharabilityQueryImplementation2.getSharability(uri)) == Sharability.UNKNOWN) continue;
            return x.ordinal();
        }
        for (SharabilityQueryImplementation sharabilityQueryImplementation : implementations.allInstances()) {
            int x = sharabilityQueryImplementation.getSharability(file);
            if (x == 0) continue;
            return x;
        }
        return 0;
    }

    public static Sharability getSharability(URI uri) {
        Object normUri;
        Parameters.notNull("uri", uri);
        boolean asserts = false;
        if (!$assertionsDisabled) {
            asserts = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (asserts && !uri.equals(normUri = BaseUtilities.normalizeURI(uri))) {
            throw new IllegalArgumentException("Must pass a normalized URI: " + uri + " vs. " + normUri);
        }
        for (SharabilityQueryImplementation2 sqi : implementations2.allInstances()) {
            Sharability x = sqi.getSharability(uri);
            if (x == Sharability.UNKNOWN) continue;
            return x;
        }
        if ("file".equals(uri.getScheme())) {
            File file = FileUtil.normalizeFile(BaseUtilities.toFile(uri));
            for (SharabilityQueryImplementation sqi : implementations.allInstances()) {
                int x = sqi.getSharability(file);
                if (x == 0) continue;
                return Sharability.values()[x];
            }
        }
        return Sharability.UNKNOWN;
    }

    public static Sharability getSharability(FileObject fo) {
        return SharabilityQuery.getSharability(fo.toURI());
    }

    public static enum Sharability {
        UNKNOWN,
        SHARABLE,
        NOT_SHARABLE,
        MIXED;

    }
}

