/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.utils;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class PropertyUtil {
    private static final String DOT = ".";
    private static final String UNDERSCORE = "_";
    private static final String HYPHEN = "-";

    private PropertyUtil() {
    }

    public static Optional<String> resolvePropertyValue(String name, Map<?, ?> properties) {
        return Optional.of(name).flatMap(n -> PropertyUtil.getPropertyValue(n, properties)).or(() -> Optional.of(name.toUpperCase()).filter(uppercasedName -> !name.equals(uppercasedName)).flatMap(n -> PropertyUtil.getPropertyValue(n, properties)));
    }

    private static Optional<String> getPropertyValue(String name, Map<?, ?> properties) {
        return PropertyUtil.keyPermutations(name).filter(properties::containsKey).findFirst().map(properties::get).map(String::valueOf);
    }

    private static Stream<String> keyPermutations(String name) {
        return Stream.of(name, name.replace(DOT, UNDERSCORE), name.replace(HYPHEN, UNDERSCORE), name.replace(DOT, UNDERSCORE).replace(HYPHEN, UNDERSCORE)).distinct();
    }
}

