/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import java.util.List;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.PropertyDependencyDTO;
import org.apache.nifi.web.api.entity.AllowableValueEntity;

@XmlType(name="propertyDescriptor")
public class PropertyDescriptorDTO {
    private String name;
    private String displayName;
    private String description;
    private String defaultValue;
    private List<AllowableValueEntity> allowableValues;
    private Boolean required;
    private Boolean sensitive;
    private Boolean dynamic;
    private Boolean supportsEl;
    private String expressionLanguageScope;
    private String identifiesControllerService;
    private BundleDTO identifiesControllerServiceBundle;
    private List<PropertyDependencyDTO> dependencies;

    @Schema(description="Allowable values for the property. If empty then the allowed values are not constrained.")
    public List<AllowableValueEntity> getAllowableValues() {
        return this.allowableValues;
    }

    public void setAllowableValues(List<AllowableValueEntity> allowableValues) {
        this.allowableValues = allowableValues;
    }

    @Schema(description="The default value for the property.")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Schema(description="The description for the property. Used to relay additional details to a user or provide a mechanism of documenting intent.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Schema(description="The name for the property.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="The human readable name for the property.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Schema(description="Whether the property is required.")
    public Boolean isRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    @Schema(description="Whether the property is sensitive and protected whenever stored or represented.")
    public Boolean isSensitive() {
        return this.sensitive;
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }

    @Schema(description="Whether the property is dynamic (user-defined).")
    public Boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(Boolean dynamic) {
        this.dynamic = dynamic;
    }

    @Schema(description="Whether the property supports expression language.")
    public Boolean getSupportsEl() {
        return this.supportsEl;
    }

    public void setSupportsEl(Boolean supportsEl) {
        this.supportsEl = supportsEl;
    }

    @Schema(description="Scope of the Expression Language evaluation for the property.")
    public String getExpressionLanguageScope() {
        return this.expressionLanguageScope;
    }

    public void setExpressionLanguageScope(String scope) {
        this.expressionLanguageScope = scope;
    }

    @Schema(description="If the property identifies a controller service this returns the fully qualified type.")
    public String getIdentifiesControllerService() {
        return this.identifiesControllerService;
    }

    public void setIdentifiesControllerService(String identifiesControllerService) {
        this.identifiesControllerService = identifiesControllerService;
    }

    @Schema(description="If the property identifies a controller service this returns the bundle of the type, null otherwise.")
    public BundleDTO getIdentifiesControllerServiceBundle() {
        return this.identifiesControllerServiceBundle;
    }

    public void setIdentifiesControllerServiceBundle(BundleDTO identifiesControllerServiceBundle) {
        this.identifiesControllerServiceBundle = identifiesControllerServiceBundle;
    }

    @Schema(description="A list of dependencies that must be met in order for this Property to be relevant. If any of these dependencies is not met, the property described by this Property Descriptor is not relevant.")
    public List<PropertyDependencyDTO> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<PropertyDependencyDTO> dependencies) {
        this.dependencies = dependencies;
    }
}

