/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.filter;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.SerializableString;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.filter.TokenFilter;
import tools.jackson.core.filter.TokenFilterContext;
import tools.jackson.core.util.JsonGeneratorDelegate;

public class FilteringGeneratorDelegate
extends JsonGeneratorDelegate {
    protected TokenFilter rootFilter;
    protected boolean _allowMultipleMatches;
    protected TokenFilter.Inclusion _inclusion;
    protected TokenFilterContext _filterContext;
    protected TokenFilter _itemFilter;
    protected int _matchCount;

    public FilteringGeneratorDelegate(JsonGenerator d, TokenFilter f, TokenFilter.Inclusion inclusion, boolean allowMultipleMatches) {
        super(d, false);
        this.rootFilter = f;
        this._itemFilter = f;
        this._filterContext = TokenFilterContext.createRootContext(f);
        this._inclusion = inclusion;
        this._allowMultipleMatches = allowMultipleMatches;
    }

    public TokenFilter getFilter() {
        return this.rootFilter;
    }

    public TokenStreamContext getFilterContext() {
        return this._filterContext;
    }

    public int getMatchCount() {
        return this._matchCount;
    }

    @Override
    public TokenStreamContext streamWriteContext() {
        return this._filterContext;
    }

    @Override
    public JsonGenerator writeStartArray() throws JacksonException {
        if (this._itemFilter == null) {
            this._filterContext = this._filterContext.createChildArrayContext(null, null, false);
            return this;
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, null, true);
            this.delegate.writeStartArray();
            return this;
        }
        this._itemFilter = this._filterContext.checkValue(this._itemFilter);
        if (this._itemFilter == null) {
            this._filterContext = this._filterContext.createChildArrayContext(null, null, false);
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            this._itemFilter = this._itemFilter.filterStartArray();
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            this._checkParentPath();
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, null, true);
            this.delegate.writeStartArray();
        } else if (this._itemFilter != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
            this._checkParentPath(false);
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, null, true);
            this.delegate.writeStartArray();
        } else {
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, null, false);
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(Object currValue) throws JacksonException {
        if (this._itemFilter == null) {
            this._filterContext = this._filterContext.createChildArrayContext(null, currValue, false);
            return this;
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, currValue, true);
            this.delegate.writeStartArray(currValue);
            return this;
        }
        this._itemFilter = this._filterContext.checkValue(this._itemFilter);
        if (this._itemFilter == null) {
            this._filterContext = this._filterContext.createChildArrayContext(null, currValue, false);
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            this._itemFilter = this._itemFilter.filterStartArray();
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            this._checkParentPath();
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, currValue, true);
            this.delegate.writeStartArray(currValue);
        } else if (this._itemFilter != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
            this._checkParentPath(false);
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, currValue, true);
            this.delegate.writeStartArray(currValue);
        } else {
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, currValue, false);
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(Object currValue, int size) throws JacksonException {
        if (this._itemFilter == null) {
            this._filterContext = this._filterContext.createChildArrayContext(null, currValue, false);
            return this;
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, currValue, true);
            this.delegate.writeStartArray(currValue, size);
            return this;
        }
        this._itemFilter = this._filterContext.checkValue(this._itemFilter);
        if (this._itemFilter == null) {
            this._filterContext = this._filterContext.createChildArrayContext(null, currValue, false);
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            this._itemFilter = this._itemFilter.filterStartArray();
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            this._checkParentPath();
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, currValue, true);
            this.delegate.writeStartArray(currValue, size);
        } else if (this._itemFilter != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
            this._checkParentPath(false);
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, currValue, true);
            this.delegate.writeStartArray(currValue, size);
        } else {
            this._filterContext = this._filterContext.createChildArrayContext(this._itemFilter, currValue, false);
        }
        return this;
    }

    @Override
    public JsonGenerator writeEndArray() throws JacksonException {
        this._filterContext = this._filterContext.closeArray(this.delegate);
        if (this._filterContext != null) {
            this._itemFilter = this._filterContext.getFilter();
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartObject() throws JacksonException {
        if (this._itemFilter == null) {
            this._filterContext = this._filterContext.createChildObjectContext(this._itemFilter, null, false);
            return this;
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            this._filterContext = this._filterContext.createChildObjectContext(this._itemFilter, null, true);
            this.delegate.writeStartObject();
            return this;
        }
        TokenFilter f = this._filterContext.checkValue(this._itemFilter);
        if (f == null) {
            this._filterContext = this._filterContext.createChildObjectContext(this._itemFilter, null, false);
            return this;
        }
        if (f != TokenFilter.INCLUDE_ALL) {
            f = f.filterStartObject();
        }
        if (f == TokenFilter.INCLUDE_ALL) {
            this._checkParentPath();
            this._filterContext = this._filterContext.createChildObjectContext(f, null, true);
            this.delegate.writeStartObject();
        } else if (f != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
            this._checkParentPath(false);
            this._filterContext = this._filterContext.createChildObjectContext(f, null, true);
            this.delegate.writeStartObject();
        } else {
            this._filterContext = this._filterContext.createChildObjectContext(f, null, false);
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(Object currValue) throws JacksonException {
        if (this._itemFilter == null) {
            this._filterContext = this._filterContext.createChildObjectContext(this._itemFilter, currValue, false);
            return this;
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            this._filterContext = this._filterContext.createChildObjectContext(this._itemFilter, currValue, true);
            this.delegate.writeStartObject(currValue);
            return this;
        }
        TokenFilter f = this._filterContext.checkValue(this._itemFilter);
        if (f == null) {
            this._filterContext = this._filterContext.createChildObjectContext(this._itemFilter, currValue, false);
            return this;
        }
        if (f != TokenFilter.INCLUDE_ALL) {
            f = f.filterStartObject();
        }
        if (f == TokenFilter.INCLUDE_ALL) {
            this._checkParentPath();
            this._filterContext = this._filterContext.createChildObjectContext(f, currValue, true);
            this.delegate.writeStartObject(currValue);
        } else if (f != null && this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
            this._checkParentPath(false);
            this._filterContext = this._filterContext.createChildObjectContext(f, currValue, true);
            this.delegate.writeStartObject(currValue);
        } else {
            this._filterContext = this._filterContext.createChildObjectContext(f, currValue, false);
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(Object currValue, int size) throws JacksonException {
        if (this._itemFilter == null) {
            this._filterContext = this._filterContext.createChildObjectContext(this._itemFilter, currValue, false);
            return this;
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            this._filterContext = this._filterContext.createChildObjectContext(this._itemFilter, currValue, true);
            this.delegate.writeStartObject(currValue, size);
            return this;
        }
        TokenFilter f = this._filterContext.checkValue(this._itemFilter);
        if (f == null) {
            this._filterContext = this._filterContext.createChildObjectContext(this._itemFilter, currValue, false);
            return this;
        }
        if (f != TokenFilter.INCLUDE_ALL) {
            f = f.filterStartObject();
        }
        if (f == TokenFilter.INCLUDE_ALL) {
            this._checkParentPath();
            this._filterContext = this._filterContext.createChildObjectContext(f, currValue, true);
            this.delegate.writeStartObject(currValue, size);
        } else {
            this._filterContext = this._filterContext.createChildObjectContext(f, currValue, false);
        }
        return this;
    }

    @Override
    public JsonGenerator writeEndObject() throws JacksonException {
        this._filterContext = this._filterContext.closeObject(this.delegate);
        if (this._filterContext != null) {
            this._itemFilter = this._filterContext.getFilter();
        }
        return this;
    }

    @Override
    public JsonGenerator writeName(String name) throws JacksonException {
        TokenFilter state = this._filterContext.setPropertyName(name);
        if (state == null) {
            this._itemFilter = null;
            return this;
        }
        if (state == TokenFilter.INCLUDE_ALL) {
            this._itemFilter = state;
            this.delegate.writeName(name);
            return this;
        }
        this._itemFilter = state = state.includeProperty(name);
        if (state == TokenFilter.INCLUDE_ALL) {
            this._checkPropertyParentPath();
        }
        return this;
    }

    @Override
    public JsonGenerator writeName(SerializableString name) throws JacksonException {
        TokenFilter state = this._filterContext.setPropertyName(name.getValue());
        if (state == null) {
            this._itemFilter = null;
            return this;
        }
        if (state == TokenFilter.INCLUDE_ALL) {
            this._itemFilter = state;
            this.delegate.writeName(name);
            return this;
        }
        this._itemFilter = state = state.includeProperty(name.getValue());
        if (state == TokenFilter.INCLUDE_ALL) {
            this._checkPropertyParentPath();
        }
        return this;
    }

    @Override
    public JsonGenerator writePropertyId(long id) throws JacksonException {
        return this.writeName(Long.toString(id));
    }

    @Override
    public JsonGenerator writeString(String value) throws JacksonException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeString(value)) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeString(value);
        return this;
    }

    @Override
    public JsonGenerator writeString(char[] text, int offset, int len) throws JacksonException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            String value = new String(text, offset, len);
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeString(value)) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeString(text, offset, len);
        return this;
    }

    @Override
    public JsonGenerator writeString(SerializableString value) throws JacksonException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeString(value.getValue())) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeString(value);
        return this;
    }

    @Override
    public JsonGenerator writeString(Reader reader, int len) throws JacksonException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeString(reader, len)) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeString(reader, len);
        return this;
    }

    @Override
    public JsonGenerator writeRawUTF8String(byte[] text, int offset, int length) throws JacksonException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRawUTF8String(text, offset, length);
        }
        return this;
    }

    @Override
    public JsonGenerator writeUTF8String(byte[] text, int offset, int length) throws JacksonException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeUTF8String(text, offset, length);
        }
        return this;
    }

    @Override
    public JsonGenerator writeRaw(String text) throws JacksonException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRaw(text);
        }
        return this;
    }

    @Override
    public JsonGenerator writeRaw(String text, int offset, int len) throws JacksonException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRaw(text, offset, len);
        }
        return this;
    }

    @Override
    public JsonGenerator writeRaw(SerializableString text) throws JacksonException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRaw(text);
        }
        return this;
    }

    @Override
    public JsonGenerator writeRaw(char[] text, int offset, int len) throws JacksonException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRaw(text, offset, len);
        }
        return this;
    }

    @Override
    public JsonGenerator writeRaw(char c) throws JacksonException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRaw(c);
        }
        return this;
    }

    @Override
    public JsonGenerator writeRawValue(String text) throws JacksonException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRawValue(text);
        }
        return this;
    }

    @Override
    public JsonGenerator writeRawValue(String text, int offset, int len) throws JacksonException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRawValue(text, offset, len);
        }
        return this;
    }

    @Override
    public JsonGenerator writeRawValue(char[] text, int offset, int len) throws JacksonException {
        if (this._checkRawValueWrite()) {
            this.delegate.writeRawValue(text, offset, len);
        }
        return this;
    }

    @Override
    public JsonGenerator writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws JacksonException {
        if (this._checkBinaryWrite()) {
            this.delegate.writeBinary(b64variant, data, offset, len);
        }
        return this;
    }

    @Override
    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) throws JacksonException {
        if (this._checkBinaryWrite()) {
            return this.delegate.writeBinary(b64variant, data, dataLength);
        }
        return -1;
    }

    @Override
    public JsonGenerator writeNumber(short v) throws JacksonException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeNumber(v)) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(v);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(int v) throws JacksonException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeNumber(v)) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(v);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(long v) throws JacksonException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeNumber(v)) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(v);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(BigInteger v) throws JacksonException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeNumber(v)) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(v);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(double v) throws JacksonException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeNumber(v)) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(v);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(float v) throws JacksonException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeNumber(v)) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(v);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(BigDecimal v) throws JacksonException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeNumber(v)) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(v);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(String encodedValue) throws JacksonException, UnsupportedOperationException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeRawValue()) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(encodedValue);
        return this;
    }

    @Override
    public JsonGenerator writeNumber(char[] encodedValueBuffer, int offset, int length) throws JacksonException, UnsupportedOperationException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeRawValue()) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeNumber(encodedValueBuffer, offset, length);
        return this;
    }

    @Override
    public JsonGenerator writeBoolean(boolean v) throws JacksonException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeBoolean(v)) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeBoolean(v);
        return this;
    }

    @Override
    public JsonGenerator writeNull() throws JacksonException {
        if (this._itemFilter == null) {
            return this;
        }
        if (this._itemFilter != TokenFilter.INCLUDE_ALL) {
            TokenFilter state = this._filterContext.checkValue(this._itemFilter);
            if (state == null) {
                return this;
            }
            if (state != TokenFilter.INCLUDE_ALL && !state.includeNull()) {
                return this;
            }
            this._checkParentPath();
        }
        this.delegate.writeNull();
        return this;
    }

    @Override
    public JsonGenerator writeOmittedProperty(String propertyName) throws JacksonException {
        if (this._itemFilter != null) {
            this.delegate.writeOmittedProperty(propertyName);
        }
        return this;
    }

    @Override
    public JsonGenerator writeObjectId(Object id) throws JacksonException {
        if (this._itemFilter != null) {
            this.delegate.writeObjectId(id);
        }
        return this;
    }

    @Override
    public JsonGenerator writeObjectRef(Object id) throws JacksonException {
        if (this._itemFilter != null) {
            this.delegate.writeObjectRef(id);
        }
        return this;
    }

    @Override
    public JsonGenerator writeTypeId(Object id) throws JacksonException {
        if (this._itemFilter != null) {
            this.delegate.writeTypeId(id);
        }
        return this;
    }

    protected void _checkParentPath() throws JacksonException {
        this._checkParentPath(true);
    }

    protected void _checkParentPath(boolean isMatch) throws JacksonException {
        if (isMatch) {
            ++this._matchCount;
        }
        if (this._inclusion == TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH) {
            this._filterContext.writePath(this.delegate);
        } else if (this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
            this._filterContext.ensurePropertyNameWritten(this.delegate);
        }
        if (isMatch && !this._allowMultipleMatches) {
            this._filterContext.skipParentChecks();
        }
    }

    protected void _checkPropertyParentPath() throws JacksonException {
        ++this._matchCount;
        if (this._inclusion == TokenFilter.Inclusion.INCLUDE_ALL_AND_PATH) {
            this._filterContext.writePath(this.delegate);
        } else if (this._inclusion == TokenFilter.Inclusion.INCLUDE_NON_NULL) {
            this._filterContext.ensurePropertyNameWritten(this.delegate);
        }
        if (!this._allowMultipleMatches) {
            this._filterContext.skipParentChecks();
        }
    }

    protected boolean _checkBinaryWrite() throws JacksonException {
        if (this._itemFilter == null) {
            return false;
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            return true;
        }
        if (this._itemFilter.includeBinary()) {
            this._checkParentPath();
            return true;
        }
        return false;
    }

    protected boolean _checkRawValueWrite() throws JacksonException {
        if (this._itemFilter == null) {
            return false;
        }
        if (this._itemFilter == TokenFilter.INCLUDE_ALL) {
            return true;
        }
        if (this._itemFilter.includeRawValue()) {
            this._checkParentPath();
            return true;
        }
        return false;
    }
}

