/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.ProtocolVersion;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;
import org.apache.qpid.server.protocol.v0_8.transport.MethodProcessor;

public class ConnectionCloseBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 10;
    private final int _ownMethodId;
    private final int _replyCode;
    private final AMQShortString _replyText;
    private final int _classId;
    private final int _methodId;

    public ConnectionCloseBody(ProtocolVersion protocolVersion, int replyCode, AMQShortString replyText, int classId, int methodId) {
        this._ownMethodId = ProtocolVersion.v0_8.equals(protocolVersion) ? 60 : 50;
        this._replyCode = replyCode;
        this._replyText = replyText;
        this._classId = classId;
        this._methodId = methodId;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return this._ownMethodId;
    }

    public final int getReplyCode() {
        return this._replyCode;
    }

    public final AMQShortString getReplyText() {
        return this._replyText;
    }

    public final int getClassId() {
        return this._classId;
    }

    public final int getMethodId() {
        return this._methodId;
    }

    @Override
    protected int getBodySize() {
        int size = 6;
        return size += this.getSizeOf(this._replyText);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._replyCode);
        this.writeAMQShortString(buffer, this._replyText);
        this.writeUnsignedShort(buffer, this._classId);
        this.writeUnsignedShort(buffer, this._methodId);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchConnectionClose(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionCloseBodyImpl: ");
        buf.append("replyCode=");
        buf.append(this.getReplyCode());
        buf.append(", ");
        buf.append("replyText=");
        buf.append(this.getReplyText());
        buf.append(", ");
        buf.append("classId=");
        buf.append(this.getClassId());
        buf.append(", ");
        buf.append("methodId=");
        buf.append(this.getMethodId());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, MethodProcessor dispatcher) {
        int replyCode = buffer.getUnsignedShort();
        AMQShortString replyText = AMQShortString.readAMQShortString(buffer);
        int classId = buffer.getUnsignedShort();
        int methodId = buffer.getUnsignedShort();
        dispatcher.receiveConnectionClose(replyCode, replyText, classId, methodId);
    }
}

