/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.ConfiguredObject;

public class TimeZoneServlet
extends AbstractServlet {
    private static final long serialVersionUID = 1L;
    private static final String[] TIMEZONE_REGIONS = new String[]{"Africa", "America", "Antarctica", "Arctic", "Asia", "Atlantic", "Australia", "Europe", "Indian", "Pacific"};

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws ServletException, IOException {
        this.sendJsonResponse(this.getTimeZones(), request, response);
    }

    public List<TimeZoneDetails> getTimeZones() {
        ArrayList<TimeZoneDetails> timeZoneDetails = new ArrayList<TimeZoneDetails>();
        String[] ids = TimeZone.getAvailableIDs();
        long currentTime = System.currentTimeMillis();
        Date currentDate = new Date(currentTime);
        block0: for (String id : ids) {
            int cityPos = id.indexOf("/");
            if (cityPos <= 0 || cityPos >= id.length() - 1) continue;
            String region = id.substring(0, cityPos);
            for (int i = 0; i < TIMEZONE_REGIONS.length; ++i) {
                if (!region.equals(TIMEZONE_REGIONS[i])) continue;
                TimeZone tz = TimeZone.getTimeZone(id);
                int offset = tz.getOffset(currentTime) / 60000;
                String city = id.substring(cityPos + 1).replace('_', ' ');
                timeZoneDetails.add(new TimeZoneDetails(id, tz.getDisplayName(tz.inDaylightTime(currentDate), 0), offset, city, region));
                continue block0;
            }
        }
        return timeZoneDetails;
    }

    public static class TimeZoneDetails {
        private final String id;
        private final String name;
        private final int offset;
        private final String city;
        private final String region;

        public TimeZoneDetails(String id, String name, int offset, String city, String region) {
            this.id = id;
            this.name = name;
            this.offset = offset;
            this.city = city;
            this.region = region;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getCity() {
            return this.city;
        }

        public String getRegion() {
            return this.region;
        }
    }
}

