/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost.berkeleydb;

import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.store.FileBasedSettings;
import org.apache.qpid.server.store.SizeMonitoringSettings;
import org.apache.qpid.server.store.berkeleydb.BDBEnvironmentContainer;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

public interface BDBVirtualHost<X extends BDBVirtualHost<X>>
extends QueueManagingVirtualHost<X>,
FileBasedSettings,
SizeMonitoringSettings,
BDBEnvironmentContainer<X> {
    public static final String STORE_PATH = "storePath";
    public static final long BDB_MIN_CACHE_SIZE = 0xA00000L;
    public static final String QPID_BROKER_BDB_TOTAL_CACHE_SIZE = "qpid.broker.bdbTotalCacheSize";
    public static final String QPID_BROKER_BDB_COMMITER_NOTIFY_THRESHOLD = "qpid.broker.bdbCommiterNotifyThreshold";
    public static final String QPID_BROKER_BDB_COMMITER_WAIT_TIMEOUT = "qpid.broker.bdbCommiterWaitTimeout";
    @ManagedContextDefault(name="qpid.broker.bdbTotalCacheSize")
    public static final long DEFAULT_JE_CACHE_SIZE = Math.max(0xA00000L, Runtime.getRuntime().maxMemory() / 20L);
    @ManagedContextDefault(name="qpid.broker.bdbCommiterNotifyThreshold", description="Threshold for amount of messages triggering BDB log flush to the disk")
    public static final int DEFAULT_QPID_BROKER_BDB_COMMITER_NOTIFY_THRESHOLD = 8;
    @ManagedContextDefault(name="qpid.broker.bdbCommiterWaitTimeout", description="Timeout for BDB log flush to the disk")
    public static final long DEFAULT_QPID_BROKER_BDB_COMMITER_WAIT_TIMEOUT = 500L;

    @ManagedAttribute(mandatory=true, defaultValue="${qpid.work_dir}${file.separator}${this:name}${file.separator}messages")
    public String getStorePath();

    @ManagedAttribute(mandatory=true, defaultValue="0")
    public Long getStoreUnderfullSize();

    @ManagedAttribute(mandatory=true, defaultValue="0")
    public Long getStoreOverfullSize();
}

