/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.converter.v0_10_v1_0;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.DestinationAddress;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.converter.MessageConversionException;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_10.transport.DeliveryProperties;
import org.apache.qpid.server.protocol.v0_10.transport.Header;
import org.apache.qpid.server.protocol.v0_10.transport.MessageDeliveryMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageDeliveryPriority;
import org.apache.qpid.server.protocol.v0_10.transport.MessageProperties;
import org.apache.qpid.server.protocol.v0_10.transport.ReplyTo;
import org.apache.qpid.server.protocol.v1_0.MessageConverter_from_1_0;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.store.StoredMessage;

@PluggableService
public class MessageConverter_1_0_to_v0_10
implements MessageConverter<Message_1_0, MessageTransferMessage> {
    private static final int MAX_STR8_LENGTH = 255;
    private static final int MAX_VBIN16_LENGTH = 65535;

    public Class<Message_1_0> getInputClass() {
        return Message_1_0.class;
    }

    public Class<MessageTransferMessage> getOutputClass() {
        return MessageTransferMessage.class;
    }

    public MessageTransferMessage convert(Message_1_0 serverMsg, NamedAddressSpace addressSpace) {
        return new MessageTransferMessage(this.convertToStoredMessage(serverMsg, addressSpace), null);
    }

    public void dispose(MessageTransferMessage message) {
    }

    public String getType() {
        return "v1-0 to v0-10";
    }

    private StoredMessage<MessageMetaData_0_10> convertToStoredMessage(final Message_1_0 serverMsg, NamedAddressSpace addressSpace) {
        MessageConverter_from_1_0.ConvertedContentAndMimeType convertedContentAndMimeType = MessageConverter_from_1_0.getAmqp0xConvertedContentAndMimeType((Message_1_0)serverMsg);
        final byte[] convertedContent = convertedContentAndMimeType.getContent();
        final MessageMetaData_0_10 messageMetaData_0_10 = this.convertMetaData(serverMsg, addressSpace, convertedContentAndMimeType.getMimeType(), convertedContent.length);
        final int metadataSize = messageMetaData_0_10.getStorableSize();
        return new StoredMessage<MessageMetaData_0_10>(){

            public MessageMetaData_0_10 getMetaData() {
                return messageMetaData_0_10;
            }

            public long getMessageNumber() {
                return serverMsg.getMessageNumber();
            }

            public QpidByteBuffer getContent(int offset, int length) {
                return QpidByteBuffer.wrap((byte[])convertedContent, (int)offset, (int)length);
            }

            public int getContentSize() {
                return convertedContent.length;
            }

            public int getMetadataSize() {
                return metadataSize;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean isInContentInMemory() {
                return true;
            }

            public long getInMemorySize() {
                return this.getContentSize() + this.getMetadataSize();
            }

            public boolean flowToDisk() {
                return false;
            }

            public void reallocate() {
            }
        };
    }

    private MessageMetaData_0_10 convertMetaData(Message_1_0 serverMsg, NamedAddressSpace addressSpace, String bodyMimeType, int size) {
        String origReplyTo;
        String encoding;
        byte[] correlationId;
        DeliveryProperties deliveryProps = new DeliveryProperties();
        MessageProperties messageProps = new MessageProperties();
        MessageMetaData_1_0.MessageHeader_1_0 origHeader = serverMsg.getMessageHeader();
        this.setExchangeAndRoutingKeyOnDeliveryProperties(deliveryProps, origHeader, addressSpace);
        deliveryProps.setDeliveryMode(serverMsg.isPersistent() ? MessageDeliveryMode.PERSISTENT : MessageDeliveryMode.NON_PERSISTENT);
        deliveryProps.setExpiration(serverMsg.getExpiration());
        deliveryProps.setPriority(MessageDeliveryPriority.get((short)origHeader.getPriority()));
        Date creationTime = MessageConverter_from_1_0.getCreationTime((Message_1_0)serverMsg);
        long arrivalTime = serverMsg.getArrivalTime();
        if (creationTime != null) {
            deliveryProps.setTimestamp(creationTime.getTime());
        } else {
            deliveryProps.setTimestamp(arrivalTime);
        }
        Long ttl = MessageConverter_from_1_0.getTtl((Message_1_0)serverMsg);
        Date absoluteExpiryTime = MessageConverter_from_1_0.getAbsoluteExpiryTime((Message_1_0)serverMsg);
        if (ttl != null) {
            deliveryProps.setTtl(ttl.longValue());
            deliveryProps.setExpiration(arrivalTime + ttl);
        } else if (absoluteExpiryTime != null) {
            long time = absoluteExpiryTime.getTime();
            deliveryProps.setTtl(Math.max(0L, time - arrivalTime));
            deliveryProps.setExpiration(time);
        }
        UUID messageId = this.getMessageIdAsUUID(serverMsg);
        if (messageId != null) {
            messageProps.setMessageId(messageId);
        }
        if ((correlationId = this.getCorrelationIdAsBytes(serverMsg)) != null) {
            messageProps.setCorrelationId(correlationId);
        }
        if ((encoding = origHeader.getEncoding()) != null) {
            messageProps.setContentEncoding(this.ensureStr8("content-encoding", encoding));
        }
        messageProps.setContentLength((long)size);
        messageProps.setContentType(bodyMimeType);
        byte[] userId = this.getUserIdAsBytes(serverMsg);
        if (userId != null && userId.length <= 65535) {
            messageProps.setUserId(this.ensureVBin16("user-id", userId));
        }
        if ((origReplyTo = origHeader.getReplyTo()) != null && !origReplyTo.equals("")) {
            messageProps.setReplyTo(this.getReplyTo(addressSpace, origReplyTo));
        }
        Map<String, Object> appHeaders = this.getApplicationHeaders(serverMsg);
        messageProps.setApplicationHeaders(appHeaders);
        Header header = new Header(deliveryProps, messageProps, null);
        return new MessageMetaData_0_10(header, size, arrivalTime);
    }

    private Map<String, Object> getApplicationHeaders(Message_1_0 serverMsg) {
        UnsignedInteger groupSequence;
        String groupId;
        MessageMetaData_1_0.MessageHeader_1_0 origHeader = serverMsg.getMessageHeader();
        Map applicationProperties = serverMsg.getMessageHeader().getHeadersAsMap();
        for (String key : applicationProperties.keySet()) {
            this.ensureStr8("application-properties[\"" + key + "\"]", key);
        }
        LinkedHashMap<String, Object> appHeaders = new LinkedHashMap<String, Object>((Map)MessageConverter_from_1_0.convertValue((Object)applicationProperties));
        if (origHeader.getSubject() != null) {
            if (!appHeaders.containsKey("qpid.subject")) {
                appHeaders.put("qpid.subject", origHeader.getSubject());
            }
            if (!appHeaders.containsKey("x-jms-type")) {
                appHeaders.put("x-jms-type", origHeader.getSubject());
            }
        }
        if ((groupId = MessageConverter_from_1_0.getGroupId((Message_1_0)serverMsg)) != null && !appHeaders.containsKey("JMSXGroupID")) {
            appHeaders.put("JMSXGroupID", groupId);
        }
        if ((groupSequence = MessageConverter_from_1_0.getGroupSequence((Message_1_0)serverMsg)) != null && !appHeaders.containsKey("JMSXGroupSeq")) {
            appHeaders.put("JMSXGroupSeq", groupSequence.intValue());
        }
        return appHeaders;
    }

    private ReplyTo getReplyTo(NamedAddressSpace addressSpace, String origReplyTo) {
        DestinationAddress destinationAddress = new DestinationAddress(addressSpace, origReplyTo);
        MessageDestination messageDestination = destinationAddress.getMessageDestination();
        return new ReplyTo(this.ensureStr8("reply-to[\"exchange\"]", messageDestination instanceof Exchange ? messageDestination.getName() : ""), this.ensureStr8("reply-to[\"routing-key\"]", messageDestination instanceof Queue ? messageDestination.getName() : destinationAddress.getRoutingKey()));
    }

    private void setExchangeAndRoutingKeyOnDeliveryProperties(DeliveryProperties deliveryProps, MessageMetaData_1_0.MessageHeader_1_0 origHeader, NamedAddressSpace addressSpace) {
        String routingKey;
        String exchangeName;
        String subject;
        String to = origHeader.getTo();
        String string = subject = origHeader.getSubject() == null ? "" : origHeader.getSubject();
        if (to != null && !"".equals(to)) {
            DestinationAddress destinationAddress = new DestinationAddress(addressSpace, to);
            MessageDestination messageDestination = destinationAddress.getMessageDestination();
            if (messageDestination instanceof Queue) {
                exchangeName = "";
                routingKey = messageDestination.getName();
            } else if (messageDestination instanceof Exchange) {
                exchangeName = messageDestination.getName();
                routingKey = "".equals(destinationAddress.getRoutingKey()) ? subject : destinationAddress.getRoutingKey();
            } else {
                exchangeName = "";
                routingKey = to;
            }
        } else {
            exchangeName = "";
            routingKey = subject;
        }
        deliveryProps.setRoutingKey(this.ensureStr8("to' or 'subject", routingKey));
        deliveryProps.setExchange(this.ensureStr8("to", exchangeName));
    }

    private byte[] getUserIdAsBytes(Message_1_0 serverMsg) {
        Binary userId = MessageConverter_from_1_0.getUserId((Message_1_0)serverMsg);
        if (userId != null) {
            return userId.getArray();
        }
        return null;
    }

    private UUID getMessageIdAsUUID(Message_1_0 serverMsg) {
        Object messageId = MessageConverter_from_1_0.getMessageId((Message_1_0)serverMsg);
        if (messageId == null) {
            return null;
        }
        if (messageId instanceof UUID) {
            return (UUID)messageId;
        }
        if (messageId instanceof String) {
            String messageIdString = (String)messageId;
            try {
                if (messageIdString.startsWith("ID:")) {
                    messageIdString = messageIdString.substring(3);
                }
                return UUID.fromString(messageIdString);
            }
            catch (IllegalArgumentException e) {
                return UUID.nameUUIDFromBytes(messageIdString.getBytes(StandardCharsets.UTF_8));
            }
        }
        if (messageId instanceof Binary) {
            return UUID.nameUUIDFromBytes(((Binary)messageId).getArray());
        }
        if (messageId instanceof byte[]) {
            return UUID.nameUUIDFromBytes((byte[])messageId);
        }
        if (messageId instanceof UnsignedLong) {
            return UUID.nameUUIDFromBytes(this.longToBytes(((UnsignedLong)messageId).longValue()));
        }
        return UUID.nameUUIDFromBytes(String.valueOf(messageId).getBytes(StandardCharsets.UTF_8));
    }

    private byte[] getCorrelationIdAsBytes(Message_1_0 serverMsg) {
        byte[] correlationId;
        Object correlationIdObject = MessageConverter_from_1_0.getCorrelationId((Message_1_0)serverMsg);
        if (correlationIdObject == null) {
            correlationId = null;
        } else if (correlationIdObject instanceof Binary) {
            correlationId = ((Binary)correlationIdObject).getArray();
        } else if (correlationIdObject instanceof byte[]) {
            correlationId = (byte[])correlationIdObject;
        } else if (correlationIdObject instanceof UUID) {
            UUID uuid = (UUID)correlationIdObject;
            correlationId = this.longToBytes(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        } else {
            correlationId = correlationIdObject instanceof UnsignedLong ? this.longToBytes(((UnsignedLong)correlationIdObject).longValue()) : String.valueOf(correlationIdObject).getBytes(StandardCharsets.UTF_8);
        }
        return this.ensureVBin16("correlation-id", correlationId);
    }

    private String ensureStr8(String propertyName, String string) {
        if (string != null && string.length() > 255) {
            throw new MessageConversionException(String.format("Could not convert message from 1.0 to 0-10 because conversion of '%s' failed. The string length exceeds allowed maximum.", propertyName));
        }
        return string;
    }

    private byte[] ensureVBin16(String propertyName, byte[] result) {
        if (result != null && result.length > 65535) {
            throw new MessageConversionException(String.format("Could not convert message from 1.0 to 0-10 because conversion of '%s' failed. The array length exceeds allowed maximum.", propertyName));
        }
        return result;
    }

    private byte[] longToBytes(long ... x) {
        ByteBuffer buffer = ByteBuffer.allocate(8 * x.length);
        for (long l : x) {
            buffer.putLong(l);
        }
        return buffer.array();
    }
}

