/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.util.URIUtil;

public class CompactPathRule
extends Rule {
    private List<Listener> listeners = new ArrayList<Listener>();
    private boolean decoding = false;
    private boolean canonicalizing = false;

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    public boolean isCanonicalizing() {
        return this.canonicalizing;
    }

    public void setCanonicalizing(boolean canonicalizing) {
        this.canonicalizing = canonicalizing;
    }

    public boolean isDecoding() {
        return this.decoding;
    }

    public void setDecoding(boolean decoding) {
        this.decoding = decoding;
    }

    @Override
    public Rule.Handler matchAndApply(Rule.Handler input) throws IOException {
        String path;
        String cleanedPath = path = input.getHttpURI().getCanonicalPath();
        if (this.isDecoding()) {
            cleanedPath = URIUtil.decodePath((String)cleanedPath);
        }
        if (this.isCanonicalizing() && (cleanedPath = URIUtil.canonicalPath((String)cleanedPath)) == null) {
            this.notifyPathCompaction(input, cleanedPath, "Navigate above root URL");
            HttpURI.Immutable uri = HttpURI.build((HttpURI)input.getHttpURI()).path("/").asImmutable();
            return new Rule.HttpURIHandler(input, (HttpURI)uri);
        }
        cleanedPath = URIUtil.compactPath((String)cleanedPath);
        if (input.getHttpURI().getPath().equals(cleanedPath)) {
            return null;
        }
        this.notifyPathCompaction(input, cleanedPath, "Path was changed");
        try {
            HttpURI.Immutable uri = HttpURI.build((HttpURI)input.getHttpURI()).path(cleanedPath).asImmutable();
            return new Rule.HttpURIHandler(input, (HttpURI)uri);
        }
        catch (IllegalArgumentException e) {
            throw new BadMessageException("Bad Path");
        }
    }

    private void notifyPathCompaction(Rule.Handler input, String cleanedPath, String message) {
        CompactedEvent event = new CompactedEvent(input, cleanedPath, message, this);
        for (Listener listener : this.listeners) {
            listener.onCompactedEvent(event);
        }
    }

    public record CompactedEvent(Rule.Handler input, String changedPath, String message, CompactPathRule rule) {
    }

    public static interface Listener {
        public void onCompactedEvent(CompactedEvent var1);
    }
}

