/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.transport.rest.servlet.RestServlet;
import org.apache.servicecomb.transport.rest.servlet.ServletConfig;
import org.apache.servicecomb.transport.rest.servlet.ServletUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServletInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServletInjector.class);
    public static final String SERVLET_NAME = "ServicecombRestServlet";

    public static ServletRegistration.Dynamic defaultInject(ServletContext servletContext) {
        RestServletInjector injector = new RestServletInjector();
        String urlPattern = ServletConfig.getServletUrlPattern();
        return injector.inject(servletContext, urlPattern);
    }

    public ServletRegistration.Dynamic inject(ServletContext servletContext, String urlPattern) {
        Object[] urlPatterns = this.splitUrlPattern(urlPattern);
        if (urlPatterns.length == 0) {
            LOGGER.warn("urlPattern is empty, ignore register {}.", (Object)SERVLET_NAME);
            return null;
        }
        String listenAddress = ServletConfig.getLocalServerAddress();
        if (!ServletUtils.canPublishEndpoint(listenAddress)) {
            LOGGER.warn("ignore register {}.", (Object)SERVLET_NAME);
            return null;
        }
        ServletRegistration.Dynamic dynamic = servletContext.addServlet(SERVLET_NAME, RestServlet.class);
        dynamic.setAsyncSupported(true);
        dynamic.addMapping((String[])urlPatterns);
        dynamic.setLoadOnStartup(0);
        LOGGER.info("RESTful servlet url pattern: {}.", (Object)Arrays.toString(urlPatterns));
        return dynamic;
    }

    private String[] splitUrlPattern(String urlPattern) {
        if (StringUtils.isEmpty((CharSequence)urlPattern)) {
            return new String[0];
        }
        return ServletUtils.filterUrlPatterns(urlPattern);
    }
}

