/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.media;

import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.media.XMLImpl;
import io.smallrye.openapi.runtime.io.ExternalDocumentationIO;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.media.DiscriminatorIO;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;
import org.jboss.jandex.AnnotationInstance;

public class SchemaIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<Schema, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_NAME = "name";
    private static final String PROP_PREFIX = "prefix";
    private static final String PROP_NAMESPACE = "namespace";
    private static final String PROP_WRAPPED = "wrapped";
    private static final String PROP_ATTRIBUTE = "attribute";
    private final DiscriminatorIO<V, A, O, AB, OB> discriminatorIO;
    private final ExternalDocumentationIO<V, A, O, AB, OB> externalDocIO;
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public SchemaIO(IOContext<V, A, O, AB, OB> context, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, Names.SCHEMA, Names.create(Schema.class));
        this.discriminatorIO = new DiscriminatorIO<V, A, O, AB, OB>(context);
        this.externalDocIO = new ExternalDocumentationIO<V, A, O, AB, OB>(context, extensionIO);
        this.extensionIO = extensionIO;
    }

    public DiscriminatorIO<V, A, O, AB, OB> discriminator() {
        return this.discriminatorIO;
    }

    @Override
    public Schema read(AnnotationInstance annotation) {
        return this.read(null, annotation);
    }

    @Override
    protected Schema read(String name, AnnotationInstance annotation) {
        return SchemaFactory.readSchema(this.scannerContext(), (Schema)new SchemaImpl(name), annotation, Collections.emptyMap());
    }

    @Override
    public Schema readObject(O node) {
        IoLogging.logger.singleJsonObject("Schema");
        SchemaImpl schema = new SchemaImpl(this.jsonIO().getString(node, PROP_NAME));
        schema.setRef(this.readReference(node));
        schema.setFormat(this.jsonIO().getString(node, "format"));
        schema.setTitle(this.jsonIO().getString(node, "title"));
        schema.setDescription(this.jsonIO().getString(node, "description"));
        schema.setDefaultValue(this.jsonIO().fromJson(this.jsonIO().getValue(node, "default")));
        schema.setMultipleOf(this.jsonIO().getBigDecimal(node, "multipleOf"));
        schema.setMaximum(this.jsonIO().getBigDecimal(node, "maximum"));
        schema.setExclusiveMaximum(this.jsonIO().getBoolean(node, "exclusiveMaximum"));
        schema.setMinimum(this.jsonIO().getBigDecimal(node, "minimum"));
        schema.setExclusiveMinimum(this.jsonIO().getBoolean(node, "exclusiveMinimum"));
        schema.setMaxLength(this.jsonIO().getInt(node, "maxLength"));
        schema.setMinLength(this.jsonIO().getInt(node, "minLength"));
        schema.setPattern(this.jsonIO().getString(node, "pattern"));
        schema.setMaxItems(this.jsonIO().getInt(node, "maxItems"));
        schema.setMinItems(this.jsonIO().getInt(node, "minItems"));
        schema.setUniqueItems(this.jsonIO().getBoolean(node, "uniqueItems"));
        schema.setMaxProperties(this.jsonIO().getInt(node, "maxProperties"));
        schema.setMinProperties(this.jsonIO().getInt(node, "minProperties"));
        schema.setRequired(this.jsonIO().getArray(node, "required", this.jsonIO()::asString).orElse(null));
        schema.setEnumeration(this.jsonIO().getArray(node, "enum", this.jsonIO()::fromJson).orElse(null));
        schema.setType(this.enumValue(this.jsonIO().getValue(node, "type"), Schema.SchemaType.class));
        schema.setItems(this.jsonIO().getObject(node, "items").map(this::readObject).orElse(null));
        schema.setNot(this.jsonIO().getObject(node, "not").map(this::readObject).orElse(null));
        schema.setAllOf(this.jsonIO().getArray(node, "allOf", this::readValue).orElse(null));
        schema.setProperties(this.readMap(this.jsonIO().getValue(node, "properties")));
        Object addlProperties = this.jsonIO().getValue(node, "additionalProperties");
        if (this.jsonIO().isObject(addlProperties)) {
            schema.setAdditionalPropertiesSchema(this.readObject((O)this.jsonIO().asObject(addlProperties)));
        } else {
            schema.setAdditionalPropertiesBoolean(this.jsonIO().getBoolean(node, "additionalProperties"));
        }
        schema.setReadOnly(this.jsonIO().getBoolean(node, "readOnly"));
        schema.setXml(this.readXML(this.jsonIO().getValue(node, "xml")));
        schema.setExternalDocs((ExternalDocumentation)this.externalDocIO.readValue(this.jsonIO().getValue(node, "externalDocs")));
        schema.setExample(this.jsonIO().fromJson(this.jsonIO().getValue(node, "example")));
        schema.setOneOf(this.jsonIO().getArray(node, "oneOf", this::readValue).orElse(null));
        schema.setAnyOf(this.jsonIO().getArray(node, "anyOf", this::readValue).orElse(null));
        schema.setDiscriminator((Discriminator)this.discriminatorIO.readValue(this.jsonIO().getValue(node, "discriminator")));
        schema.setNullable(this.jsonIO().getBoolean(node, "nullable"));
        schema.setWriteOnly(this.jsonIO().getBoolean(node, "writeOnly"));
        schema.setDeprecated(this.jsonIO().getBoolean(node, "deprecated"));
        schema.setExtensions(this.extensionIO.readMap(node));
        return schema;
    }

    public XML readXML(V node) {
        return Optional.ofNullable(node).filter(this.jsonIO()::isObject).map(this.jsonIO()::asObject).map(object -> {
            XMLImpl xml = new XMLImpl();
            xml.setName(this.jsonIO().getString(node, PROP_NAME));
            xml.setNamespace(this.jsonIO().getString(node, PROP_NAMESPACE));
            xml.setPrefix(this.jsonIO().getString(node, PROP_PREFIX));
            xml.setAttribute(this.jsonIO().getBoolean(node, PROP_ATTRIBUTE));
            xml.setWrapped(this.jsonIO().getBoolean(node, PROP_WRAPPED));
            xml.setExtensions(this.extensionIO.readMap(node));
            return xml;
        }).orElse(null);
    }

    @Override
    public Optional<O> write(Schema model) {
        return this.optionalJsonObject(model).map(node -> {
            if (this.isReference((Reference<?>)model)) {
                this.setReference(node, (Reference<?>)model);
            } else {
                this.setIfPresent(node, "format", this.jsonIO().toJson(model.getFormat()));
                this.setIfPresent(node, "title", this.jsonIO().toJson(model.getTitle()));
                this.setIfPresent(node, "description", this.jsonIO().toJson(model.getDescription()));
                this.setIfPresent(node, "default", this.jsonIO().toJson(model.getDefaultValue()));
                this.setIfPresent(node, "multipleOf", this.jsonIO().toJson(model.getMultipleOf()));
                this.setIfPresent(node, "maximum", this.jsonIO().toJson(model.getMaximum()));
                this.setIfPresent(node, "exclusiveMaximum", this.jsonIO().toJson(model.getExclusiveMaximum()));
                this.setIfPresent(node, "minimum", this.jsonIO().toJson(model.getMinimum()));
                this.setIfPresent(node, "exclusiveMinimum", this.jsonIO().toJson(model.getExclusiveMinimum()));
                this.setIfPresent(node, "maxLength", this.jsonIO().toJson(model.getMaxLength()));
                this.setIfPresent(node, "minLength", this.jsonIO().toJson(model.getMinLength()));
                this.setIfPresent(node, "pattern", this.jsonIO().toJson(model.getPattern()));
                this.setIfPresent(node, "maxItems", this.jsonIO().toJson(model.getMaxItems()));
                this.setIfPresent(node, "minItems", this.jsonIO().toJson(model.getMinItems()));
                this.setIfPresent(node, "uniqueItems", this.jsonIO().toJson(model.getUniqueItems()));
                this.setIfPresent(node, "maxProperties", this.jsonIO().toJson(model.getMaxProperties()));
                this.setIfPresent(node, "minProperties", this.jsonIO().toJson(model.getMinProperties()));
                this.setIfPresent(node, "required", this.jsonIO().toJson(model.getRequired()));
                this.setIfPresent(node, "enum", this.jsonIO().toJson(model.getEnumeration()));
                this.setIfPresent(node, "type", this.jsonIO().toJson(model.getType()));
                this.setIfPresent(node, "items", this.write(model.getItems()));
                this.setIfPresent(node, "allOf", this.write(model.getAllOf()));
                this.setIfPresent(node, "properties", this.write(model.getProperties()));
                if (model.getAdditionalPropertiesBoolean() != null) {
                    this.setIfPresent(node, "additionalProperties", this.jsonIO().toJson(model.getAdditionalPropertiesBoolean()));
                } else {
                    this.setIfPresent(node, "additionalProperties", this.write(model.getAdditionalPropertiesSchema()));
                }
                this.setIfPresent(node, "readOnly", this.jsonIO().toJson(model.getReadOnly()));
                this.setIfPresent(node, "xml", this.write(model.getXml()));
                this.setIfPresent(node, "externalDocs", this.externalDocIO.write(model.getExternalDocs()));
                this.setIfPresent(node, "example", this.jsonIO().toJson(model.getExample()));
                this.setIfPresent(node, "oneOf", this.write(model.getOneOf()));
                this.setIfPresent(node, "anyOf", this.write(model.getAnyOf()));
                this.setIfPresent(node, "not", this.write(model.getNot()));
                this.setIfPresent(node, "discriminator", this.discriminatorIO.write(model.getDiscriminator()));
                this.setIfPresent(node, "nullable", this.jsonIO().toJson(model.getNullable()));
                this.setIfPresent(node, "writeOnly", this.jsonIO().toJson(model.getWriteOnly()));
                this.setIfPresent(node, "deprecated", this.jsonIO().toJson(model.getDeprecated()));
                this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            }
            return node;
        }).map(this.jsonIO()::buildObject);
    }

    @Override
    private Optional<A> write(List<Schema> models) {
        return this.optionalJsonArray(models).map(array -> {
            models.forEach(model -> this.write((Schema)model).ifPresent(v -> this.jsonIO().add(array, v)));
            return array;
        }).map(this.jsonIO()::buildArray);
    }

    @Override
    public Optional<O> write(XML model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_NAME, this.jsonIO().toJson(model.getName()));
            this.setIfPresent(node, PROP_NAMESPACE, this.jsonIO().toJson(model.getNamespace()));
            this.setIfPresent(node, PROP_PREFIX, this.jsonIO().toJson(model.getPrefix()));
            this.setIfPresent(node, PROP_ATTRIBUTE, this.jsonIO().toJson(model.getAttribute()));
            this.setIfPresent(node, PROP_WRAPPED, this.jsonIO().toJson(model.getWrapped()));
            this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

