/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.openjpa.audit.Auditable;
import org.apache.openjpa.audit.AuditableOperation;
import org.apache.openjpa.audit.Auditor;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.event.LifecycleEvent;
import org.apache.openjpa.event.LifecycleListener;
import org.apache.openjpa.event.TransactionEvent;
import org.apache.openjpa.event.TransactionListener;
import org.apache.openjpa.kernel.Audited;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.InMemorySavepointManager;
import org.apache.openjpa.kernel.OpenJPASavepoint;
import org.apache.openjpa.kernel.SavepointFieldManager;
import org.apache.openjpa.kernel.StateManagerImpl;

public class AuditManager
extends InMemorySavepointManager
implements TransactionListener,
PCRegistry.RegisterClassListener {
    private final Auditor _auditor;
    private final Set<Class<?>> _allTypes;
    private final Set<Class<?>> _newTypes;
    private final Set<Class<?>> _updateTypes;
    private final Set<Class<?>> _deleteTypes;
    private final Map<Broker, AuditCallback> _saved;
    private final ReentrantLock _lock = new ReentrantLock();

    public AuditManager(Auditor auditor) {
        if (auditor == null) {
            throw new NullPointerException("null auditor");
        }
        this.setPreFlush(false);
        this._auditor = auditor;
        this._allTypes = new HashSet();
        this._newTypes = new HashSet();
        this._updateTypes = new HashSet();
        this._deleteTypes = new HashSet();
        this._saved = new ConcurrentHashMap<Broker, AuditCallback>();
        PCRegistry.addRegisterClassListener(this);
    }

    @Override
    public void register(Class<?> cls) {
        Auditable auditable = cls.getAnnotation(Auditable.class);
        if (auditable == null) {
            return;
        }
        List<AuditableOperation> events = Arrays.asList(auditable.values());
        if (events.contains((Object)AuditableOperation.ALL) || events.contains((Object)AuditableOperation.CREATE)) {
            this._newTypes.add(cls);
            this._allTypes.add(cls);
        }
        if (events.contains((Object)AuditableOperation.ALL) || events.contains((Object)AuditableOperation.UPDATE)) {
            this._updateTypes.add(cls);
            this._allTypes.add(cls);
        }
        if (events.contains((Object)AuditableOperation.ALL) || events.contains((Object)AuditableOperation.DELETE)) {
            this._deleteTypes.add(cls);
            this._allTypes.add(cls);
        }
    }

    public Auditor getAuditor() {
        return this._auditor;
    }

    public Set<Class<?>> getAuditedTypes() {
        return Collections.unmodifiableSet(this._allTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterBegin(TransactionEvent event) {
        this._lock.lock();
        try {
            Broker broker = (Broker)event.getSource();
            AuditCallback cb = new AuditCallback(broker);
            broker.addLifecycleListener(cb, this._allTypes.toArray(new Class[this._allTypes.size()]));
            this._saved.put(broker, cb);
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void beforeCommit(TransactionEvent event) {
        this._lock.lock();
        try {
            AuditCallback cb = this._saved.get(event.getSource());
            if (cb != null) {
                cb.audit();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    private void forget(Broker broker) {
        AuditCallback cb = this._saved.remove(broker);
        if (cb != null) {
            broker.removeLifecycleListener(cb);
            cb.clear();
        }
    }

    @Override
    public void afterCommit(TransactionEvent event) {
        this.forget((Broker)event.getSource());
    }

    @Override
    public void afterRollback(TransactionEvent event) {
        this.forget((Broker)event.getSource());
    }

    @Override
    public void afterCommitComplete(TransactionEvent event) {
        this.forget((Broker)event.getSource());
    }

    @Override
    public void afterRollbackComplete(TransactionEvent event) {
        this.forget((Broker)event.getSource());
    }

    @Override
    public void beforeFlush(TransactionEvent event) {
    }

    @Override
    public void afterFlush(TransactionEvent event) {
    }

    @Override
    public void afterStateTransitions(TransactionEvent event) {
    }

    protected PersistenceCapable getPersistenceCapable(LifecycleEvent evt) {
        Object source = evt.getSource();
        return source instanceof PersistenceCapable ? (PersistenceCapable)source : null;
    }

    protected Broker getBroker(PersistenceCapable pc) {
        if (pc == null) {
            return null;
        }
        Object ctx = pc.pcGetGenericContext();
        return ctx instanceof Broker ? (Broker)ctx : null;
    }

    private StateManagerImpl getImpl(Object instance) {
        if (instance instanceof PersistenceCapable) {
            StateManager sm = ((PersistenceCapable)instance).pcGetStateManager();
            if (sm instanceof StateManagerImpl) {
                return (StateManagerImpl)sm;
            }
            return null;
        }
        return null;
    }

    protected boolean isAuditable(AuditableOperation op, StateManagerImpl sm) {
        if (sm == null) {
            return false;
        }
        Class<?> cls = sm.getMetaData().getDescribedType();
        return op == AuditableOperation.ALL && this._allTypes.contains(cls) || op == AuditableOperation.CREATE && this._newTypes.contains(cls) || op == AuditableOperation.UPDATE && this._updateTypes.contains(cls) || op == AuditableOperation.DELETE && this._deleteTypes.contains(cls);
    }

    private class AuditCallback
    implements LifecycleListener {
        private final Broker _broker;
        private final Map<StateManagerImpl, PersistenceCapable> _audits = new ConcurrentHashMap<StateManagerImpl, PersistenceCapable>();

        AuditCallback(Broker broker) {
            this._broker = broker;
        }

        void audit() {
            if (this._audits.isEmpty()) {
                return;
            }
            HashSet<Audited> news = new HashSet<Audited>();
            HashSet<Audited> updates = new HashSet<Audited>();
            HashSet<Audited> deletes = new HashSet<Audited>();
            for (Map.Entry<StateManagerImpl, PersistenceCapable> e : this._audits.entrySet()) {
                StateManagerImpl sm = e.getKey();
                Audited audited = new Audited(sm, e.getValue());
                if (sm.getPCState().isNew()) {
                    news.add(audited);
                    continue;
                }
                if (sm.getPCState().isDeleted()) {
                    deletes.add(audited);
                    continue;
                }
                if (!sm.getPCState().isDirty()) continue;
                updates.add(audited);
            }
            try {
                AuditManager.this._auditor.audit(this._broker, news, updates, deletes);
            }
            catch (Exception e) {
                if (AuditManager.this._auditor.isRollbackOnError()) {
                    throw new RuntimeException("dump", e);
                }
                e.printStackTrace();
            }
        }

        protected void save(AuditableOperation op, LifecycleEvent event) {
            StateManagerImpl sm = AuditManager.this.getImpl(event.getSource());
            if (sm != null && !this._audits.containsKey(sm) && AuditManager.this.isAuditable(op, sm)) {
                BrokerImpl broker = sm.getBroker();
                OpenJPASavepoint savepoint = AuditManager.this.newSavepoint("", broker);
                savepoint.save(Collections.singleton(sm));
                Map<StateManagerImpl, SavepointFieldManager> states = savepoint.getStates();
                Map.Entry<StateManagerImpl, SavepointFieldManager> e = states.entrySet().iterator().next();
                PersistenceCapable copy = e.getValue().getCopy();
                copy.pcReplaceStateManager(null);
                this._audits.put(sm, copy);
            }
        }

        void clear() {
            this._audits.clear();
        }

        @Override
        public void afterLoad(LifecycleEvent event) {
            this.save(AuditableOperation.ALL, event);
        }

        @Override
        public void afterPersist(LifecycleEvent event) {
            this.save(AuditableOperation.CREATE, event);
        }

        @Override
        public void beforeDelete(LifecycleEvent event) {
            this.save(AuditableOperation.DELETE, event);
        }

        @Override
        public void beforeDirty(LifecycleEvent event) {
            this.save(AuditableOperation.UPDATE, event);
        }

        @Override
        public void beforePersist(LifecycleEvent event) {
        }

        @Override
        public void afterRefresh(LifecycleEvent event) {
        }

        @Override
        public void beforeStore(LifecycleEvent event) {
            this.save(AuditableOperation.UPDATE, event);
        }

        @Override
        public void afterStore(LifecycleEvent event) {
        }

        @Override
        public void beforeClear(LifecycleEvent event) {
        }

        @Override
        public void afterClear(LifecycleEvent event) {
        }

        @Override
        public void afterDelete(LifecycleEvent event) {
        }

        @Override
        public void afterDirty(LifecycleEvent event) {
            this.save(AuditableOperation.UPDATE, event);
        }

        @Override
        public void beforeDirtyFlushed(LifecycleEvent event) {
        }

        @Override
        public void afterDirtyFlushed(LifecycleEvent event) {
        }

        @Override
        public void beforeDetach(LifecycleEvent event) {
        }

        @Override
        public void afterDetach(LifecycleEvent event) {
        }

        @Override
        public void beforeAttach(LifecycleEvent event) {
        }

        @Override
        public void afterAttach(LifecycleEvent event) {
            this.save(AuditableOperation.UPDATE, event);
        }
    }
}

