/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.compat;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.CommandWithAction;
import org.apache.karaf.shell.commands.CompleterValues;
import org.apache.karaf.shell.commands.HelpOption;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.console.CommandSessionHolder;
import org.apache.karaf.shell.console.CompletableFunction;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.FileCompleter;
import org.apache.karaf.shell.console.completer.NullCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgumentCompleter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentCompleter.class);
    public static final String ARGUMENTS_LIST = "ARGUMENTS_LIST";
    public static final String COMMANDS = ".commands";
    final String scope;
    final String name;
    final Completer commandCompleter;
    final Completer optionsCompleter;
    final List<Completer> argsCompleters;
    final Map<String, Completer> optionalCompleters;
    final CommandWithAction function;
    final Map<Option, Field> fields = new HashMap<Option, Field>();
    final Map<String, Option> options = new HashMap<String, Option>();
    final Map<Integer, Field> arguments = new HashMap<Integer, Field>();
    boolean strict = true;

    public ArgumentCompleter(CommandWithAction function, String scope, String name, boolean scoped) {
        String[] stringArray;
        this.function = function;
        this.scope = scope;
        this.name = name;
        if (scoped) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = name;
            stringArray = stringArray3;
            stringArray3[1] = scope + ":" + name;
        }
        String[] names = stringArray;
        this.commandCompleter = new StringsCompleter(names);
        for (Class<? extends Action> type = function.getActionClass(); type != null; type = type.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                Argument argument;
                Option option = field.getAnnotation(Option.class);
                if (option != null) {
                    this.fields.put(option, field);
                    this.options.put(option.name(), option);
                    String[] aliases = option.aliases();
                    if (aliases != null) {
                        for (String alias : aliases) {
                            this.options.put(alias, option);
                        }
                    }
                }
                if ((argument = field.getAnnotation(Argument.class)) == null) continue;
                Integer key = argument.index();
                if (this.arguments.containsKey(key)) {
                    LOGGER.warn("Duplicate @Argument annotations on class " + type.getName() + " for index: " + key + " see: " + (Field)field);
                    continue;
                }
                this.arguments.put(key, field);
            }
        }
        this.options.put(HelpOption.HELP.name(), HelpOption.HELP);
        this.optionsCompleter = new StringsCompleter(this.options.keySet());
        ArrayList<NullCompleter> argsCompleters = null;
        Map<String, Completer> optionalCompleters = null;
        if (function instanceof CompletableFunction) {
            Map<String, Completer> focl = ((CompletableFunction)((Object)function)).getOptionalCompleters();
            List<Completer> fcl = ((CompletableFunction)((Object)function)).getCompleters();
            if (focl != null || fcl != null) {
                argsCompleters = new ArrayList();
                if (fcl != null) {
                    for (Completer c : fcl) {
                        argsCompleters.add((NullCompleter)(c == null ? NullCompleter.INSTANCE : c));
                    }
                }
                optionalCompleters = focl;
            }
        }
        if (argsCompleters == null) {
            BundleContext context;
            Map<Integer, Object> values = this.getCompleterValues(function);
            argsCompleters = new ArrayList<NullCompleter>();
            boolean multi = false;
            for (int key = 0; key < this.arguments.size(); ++key) {
                Completer completer = null;
                Field field = this.arguments.get(key);
                if (field != null) {
                    Argument argument = field.getAnnotation(Argument.class);
                    multi = argument != null && argument.multiValued();
                    org.apache.karaf.shell.commands.Completer ann = field.getAnnotation(org.apache.karaf.shell.commands.Completer.class);
                    if (ann != null) {
                        Class<? extends Completer> clazz = ann.value();
                        String[] value = ann.values();
                        if (clazz != null) {
                            if (value.length > 0 && clazz == StringsCompleter.class) {
                                completer = new StringsCompleter(value, ann.caseSensitive());
                            } else {
                                context = FrameworkUtil.getBundle(function.getClass()).getBundleContext();
                                completer = new ProxyServiceCompleter(context, clazz);
                            }
                        }
                    } else if (values.containsKey(key)) {
                        Object value = values.get(key);
                        if (value instanceof String[]) {
                            completer = new StringsCompleter((String[])value);
                        } else if (value instanceof Collection) {
                            completer = new StringsCompleter((Collection)value);
                        } else {
                            LOGGER.warn("Could not use value " + value + " as set of completions!");
                        }
                    } else {
                        completer = this.getDefaultCompleter(field);
                    }
                }
                if (completer == null) {
                    completer = NullCompleter.INSTANCE;
                }
                argsCompleters.add((NullCompleter)completer);
            }
            if (argsCompleters.isEmpty() || !multi) {
                argsCompleters.add(NullCompleter.INSTANCE);
            }
            optionalCompleters = new HashMap<String, Completer>();
            for (Option option : this.fields.keySet()) {
                org.apache.karaf.shell.commands.Completer ann;
                Completer completer = null;
                Field field = this.fields.get(option);
                if (field != null && (ann = field.getAnnotation(org.apache.karaf.shell.commands.Completer.class)) != null) {
                    Class<? extends Completer> clazz = ann.value();
                    String[] value = ann.values();
                    if (clazz != null) {
                        if (value.length > 0 && clazz == StringsCompleter.class) {
                            completer = new StringsCompleter(value, ann.caseSensitive());
                        } else {
                            context = FrameworkUtil.getBundle(function.getClass()).getBundleContext();
                            completer = new ProxyServiceCompleter(context, clazz);
                        }
                    }
                }
                if (completer == null) {
                    completer = NullCompleter.INSTANCE;
                }
                optionalCompleters.put(option.name(), completer);
                if (option.aliases() == null) continue;
                for (String alias : option.aliases()) {
                    optionalCompleters.put(alias, completer);
                }
            }
        }
        this.argsCompleters = argsCompleters;
        this.optionalCompleters = optionalCompleters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Object> getCompleterValues(CommandWithAction function) {
        HashMap<Integer, Object> values = new HashMap<Integer, Object>();
        Action action = null;
        try {
            for (Class<? extends Action> type = function.getActionClass(); type != null; type = type.getSuperclass()) {
                for (Method method : type.getDeclaredMethods()) {
                    CompleterValues completerMethod = method.getAnnotation(CompleterValues.class);
                    if (completerMethod == null) continue;
                    int index = completerMethod.index();
                    Integer key = index;
                    if (index >= this.arguments.size() || index < 0) {
                        LOGGER.warn("Index out of range on @CompleterValues on class " + type.getName() + " for index: " + key + " see: " + method);
                        continue;
                    }
                    if (values.containsKey(key)) {
                        LOGGER.warn("Duplicate @CompleterMethod annotations on class " + type.getName() + " for index: " + key + " see: " + method);
                        continue;
                    }
                    try {
                        Object value;
                        if (Modifier.isStatic(method.getModifiers())) {
                            value = method.invoke(null, new Object[0]);
                        } else {
                            if (action == null) {
                                action = function.createNewAction();
                            }
                            value = method.invoke((Object)action, new Object[0]);
                        }
                        values.put(key, value);
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.warn("Could not invoke @CompleterMethod on " + function + ". " + e, (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        Throwable target = e.getTargetException();
                        if (target == null) {
                            target = e;
                        }
                        LOGGER.warn("Could not invoke @CompleterMethod on " + function + ". " + target, target);
                    }
                }
            }
        }
        finally {
            if (action != null) {
                try {
                    function.releaseAction(action);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to release action: " + action + ". " + e, (Throwable)e);
                }
            }
        }
        return values;
    }

    private Completer getDefaultCompleter(Field field) {
        Completer completer = null;
        Class<Object> type = field.getType();
        if (type.isAssignableFrom(File.class)) {
            completer = new FileCompleter(null);
        } else if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE)) {
            completer = new StringsCompleter(new String[]{"false", "true"}, false);
        } else if (type.isAssignableFrom(Enum.class)) {
            HashSet<String> values = new HashSet<String>();
            for (Object o : EnumSet.allOf(type)) {
                values.add(o.toString());
            }
            completer = new StringsCompleter(values, false);
        }
        return completer;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean getStrict() {
        return this.strict;
    }

    public int complete(Session session, CommandLine list, List<String> candidates) {
        int ret;
        Option option;
        Field lastField;
        Option lastOption;
        int lastAgurmentIndex;
        int argpos = list.getArgumentPosition();
        int argIndex = list.getCursorArgumentIndex();
        CommandSession commandSession = CommandSessionHolder.getSession();
        if (commandSession != null) {
            commandSession.put(ARGUMENTS_LIST, list);
        }
        Completer comp = null;
        String[] args = list.getArguments();
        int index = 0;
        if (index < argIndex) {
            if (!"*".equals(this.scope) && !session.resolveCommand(args[index]).equals(this.scope + ":" + this.name)) {
                return -1;
            }
            if (!this.verifyCompleter(this.commandCompleter, args[index])) {
                return -1;
            }
            ++index;
        } else {
            comp = this.commandCompleter;
        }
        if (comp == null) {
            while (index < argIndex && args[index].startsWith("-")) {
                if (!this.verifyCompleter(this.optionsCompleter, args[index])) {
                    return -1;
                }
                Option option2 = this.options.get(args[index]);
                if (option2 == null) {
                    return -1;
                }
                Field field = this.fields.get(option2);
                if (field != null && field.getType() != Boolean.TYPE && field.getType() != Boolean.class && ++index == argIndex) {
                    comp = NullCompleter.INSTANCE;
                }
                ++index;
            }
            if (comp == null && index >= argIndex && index < args.length && args[index].startsWith("-")) {
                comp = this.optionsCompleter;
            }
        }
        if ((lastAgurmentIndex = argIndex - 1) >= 1 && (lastOption = this.options.get(args[lastAgurmentIndex])) != null && (lastField = this.fields.get(lastOption)) != null && lastField.getType() != Boolean.TYPE && lastField.getType() != Boolean.class && (option = lastField.getAnnotation(Option.class)) != null) {
            String[] aliases;
            Completer optionValueCompleter = null;
            String name = option.name();
            if (this.optionalCompleters != null && name != null && (optionValueCompleter = this.optionalCompleters.get(name)) == null && (aliases = option.aliases()).length > 0) {
                for (int i = 0; i < aliases.length && optionValueCompleter == null; ++i) {
                    optionValueCompleter = this.optionalCompleters.get(option.aliases()[i]);
                }
            }
            if (optionValueCompleter != null) {
                comp = optionValueCompleter;
            }
        }
        if (comp == null) {
            int indexArg = 0;
            while (index < argIndex) {
                Completer sub = this.argsCompleters.get(indexArg >= this.argsCompleters.size() ? this.argsCompleters.size() - 1 : indexArg);
                if (!this.verifyCompleter(sub, args[index])) {
                    return -1;
                }
                ++index;
                ++indexArg;
            }
            comp = this.argsCompleters.get(indexArg >= this.argsCompleters.size() ? this.argsCompleters.size() - 1 : indexArg);
        }
        if ((ret = comp.complete(list.getCursorArgument(), argpos, candidates)) == -1) {
            return -1;
        }
        int pos = ret + (list.getBufferPosition() - argpos);
        String buffer = list.getBuffer();
        int cursor = list.getBufferPosition();
        if (buffer != null && cursor != buffer.length() && this.isDelimiter(buffer, cursor)) {
            for (int i = 0; i < candidates.size(); ++i) {
                String val = candidates.get(i);
                while (val.length() > 0 && this.isDelimiter(val, val.length() - 1)) {
                    val = val.substring(0, val.length() - 1);
                }
                candidates.set(i, val);
            }
        }
        return pos;
    }

    protected boolean verifyCompleter(Completer completer, String argument) {
        ArrayList<String> candidates = new ArrayList<String>();
        return completer.complete(argument, argument.length(), candidates) != -1 && !candidates.isEmpty();
    }

    public boolean isDelimiter(String buffer, int pos) {
        return !this.isEscaped(buffer, pos) && this.isDelimiterChar(buffer, pos);
    }

    public boolean isEscaped(String buffer, int pos) {
        return pos > 0 && buffer.charAt(pos) == '\\' && !this.isEscaped(buffer, pos - 1);
    }

    public boolean isDelimiterChar(String buffer, int pos) {
        return Character.isWhitespace(buffer.charAt(pos));
    }

    public static class ProxyServiceCompleter
    implements Completer {
        private final BundleContext context;
        private final Class<? extends Completer> clazz;

        public ProxyServiceCompleter(BundleContext context, Class<? extends Completer> clazz) {
            this.context = context;
            this.clazz = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int complete(String buffer, int cursor, List<String> candidates) {
            Completer completer;
            ServiceReference ref = this.context.getServiceReference(this.clazz);
            if (ref != null && (completer = (Completer)this.context.getService(ref)) != null) {
                try {
                    int n = completer.complete(buffer, cursor, candidates);
                    return n;
                }
                finally {
                    this.context.ungetService(ref);
                }
            }
            return -1;
        }
    }
}

