;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; If you create a new version of this file, please send it to
;; Norman Walsh, ndw@nwalsh.com

;; The generated text for cross references to elements.  See dblink.dsl
;; for a discussion of how substitution is performed on the %x 
;; keywords.
;;

(define (fi-appendix-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Appendix; %n"
      "%t"))

(define (fi-article-xref-string gi-or-name)
  (string-append %gentext-fi-start-quote%
		 "%t"
		 %gentext-fi-end-quote%))

(define (fi-bibliography-xref-string gi-or-name)
  "%t")

(define (fi-book-xref-string gi-or-name)
  "%t")

(define (fi-chapter-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Chapter; %n"
      "%t"))

(define (fi-equation-xref-string gi-or-name)
  "&Equation; %n")

(define (fi-example-xref-string gi-or-name)
  "&Example; %n")

(define (fi-figure-xref-string gi-or-name)
  "&Figure; %n")

(define (fi-listitem-xref-string gi-or-name)
  "%n")

(define (fi-part-xref-string gi-or-name)
  "&Part; %n")

(define (fi-preface-xref-string gi-or-name)
  "%t")

(define (fi-procedure-xref-string gi-or-name)
  "&Procedure; %n, %t")

(define (fi-section-xref-string gi-or-name)
  (if %section-autolabel% 
      "&Section; %n" 
      "%t"))

(define (fi-sect1-xref-string gi-or-name)
  (fi-section-xref-string gi-or-name))

(define (fi-sect2-xref-string gi-or-name)
  (fi-section-xref-string gi-or-name))

(define (fi-sect3-xref-string gi-or-name)
  (fi-section-xref-string gi-or-name))

(define (fi-sect4-xref-string gi-or-name)
  (fi-section-xref-string gi-or-name))

(define (fi-sect5-xref-string gi-or-name)
  (fi-section-xref-string gi-or-name))

(define (fi-sidebar-xref-string gi-or-name)
  "%t")

(define (fi-step-xref-string gi-or-name)
  "&step; %n")

(define (fi-table-xref-string gi-or-name)
  "&Table; %n")

(define (fi-default-xref-string gi-or-name)
  (let* ((giname (if (string? gi-or-name) gi-or-name (gi gi-or-name)))
	 (msg    (string-append "[&xrefto; "
				(if giname giname "&nonexistantelement;")
				" &unsupported;]"))
	 (err    (node-list-error msg (current-node))))
    msg))

(define (gentext-fi-xref-strings gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
      ((equal? name (normalize "appendix")) (fi-appendix-xref-string gind))
      ((equal? name (normalize "article"))  (fi-article-xref-string gind))
      ((equal? name (normalize "bibliography")) (fi-bibliography-xref-string gind))
      ((equal? name (normalize "book"))     (fi-book-xref-string gind))
      ((equal? name (normalize "chapter"))  (fi-chapter-xref-string gind))
      ((equal? name (normalize "equation")) (fi-equation-xref-string gind))
      ((equal? name (normalize "example"))  (fi-example-xref-string gind))
      ((equal? name (normalize "figure"))   (fi-figure-xref-string gind))
      ((equal? name (normalize "listitem")) (fi-listitem-xref-string gind))
      ((equal? name (normalize "part"))     (fi-part-xref-string gind))
      ((equal? name (normalize "preface"))  (fi-preface-xref-string gind))
      ((equal? name (normalize "procedure")) (fi-procedure-xref-string gind))
      ((equal? name (normalize "sect1"))    (fi-sect1-xref-string gind))
      ((equal? name (normalize "sect2"))    (fi-sect2-xref-string gind))
      ((equal? name (normalize "sect3"))    (fi-sect3-xref-string gind))
      ((equal? name (normalize "sect4"))    (fi-sect4-xref-string gind))
      ((equal? name (normalize "sect5"))    (fi-sect5-xref-string gind))
      ((equal? name (normalize "sidebar"))  (fi-sidebar-xref-string gind))
      ((equal? name (normalize "step"))     (fi-step-xref-string gind))
      ((equal? name (normalize "table"))    (fi-table-xref-string gind))
      (else (fi-default-xref-string gind)))))

(define (fi-auto-xref-indirect-connector before) 
  ;; In English, the (cond) is unnecessary since the word is always the
  ;; same, but in other languages, that's not the case.  I've set this
  ;; one up with the (cond) so it stands as an example.
  (cond 
   ((equal? (gi before) (normalize "book"))
    (literal " &in; "))
   ((equal? (gi before) (normalize "chapter"))
    (literal " &in; "))
   ((equal? (gi before) (normalize "sect1"))
    (literal " &in; "))
   (else
    (literal " &in; "))))

;; Should the TOC come first or last?
;;
(define %generate-fi-toc-in-front% #t)

;; gentext-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define fi-abstract-name	"&Abstract;")
(define fi-appendix-name	"&Appendix;")
(define fi-article-name	"&Article;")
(define fi-bibliography-name	"&Bibliography;")
(define fi-book-name		"&Book;")
(define fi-calloutlist-name	"")
(define fi-caution-name	"&Caution;")
(define fi-chapter-name	"&Chapter;")
(define fi-copyright-name	"&Copyright;")
(define fi-dedication-name	"&Dedication;")
(define fi-edition-name	"&Edition;")
(define fi-equation-name	"&Equation;")
(define fi-example-name	"&Example;")
(define fi-figure-name	"&Figure;")
(define fi-glossary-name	"&Glossary;")
(define fi-glosssee-name	"&GlossSee;")
(define fi-glossseealso-name	"&GlossSeeAlso;")
(define fi-important-name	"&Important;")
(define fi-index-name		"&Index;")
(define fi-setindex-name	"&SetIndex;")
(define fi-isbn-name		"&ISBN;")
(define fi-legalnotice-name	"&LegalNotice;")
(define fi-msgaud-name	"&MsgAud;")
(define fi-msglevel-name	"&MsgLevel;")
(define fi-msgorig-name	"&MsgOrig;")
(define fi-note-name		"&Note;")
(define fi-part-name		"&Part;")
(define fi-preface-name	"&Preface;")
(define fi-procedure-name	"&Procedure;")
(define fi-pubdate-name	"&Published;")
(define fi-reference-name	"&Reference;")
(define fi-refname-name	"&RefName;")
(define fi-revhistory-name	"&RevHistory;")
(define fi-revision-name	"&Revision;")
(define fi-sect1-name		"&Section;")
(define fi-sect2-name		"&Section;")
(define fi-sect3-name		"&Section;")
(define fi-sect4-name		"&Section;")
(define fi-sect5-name		"&Section;")
(define fi-simplesect-name	"&Section;")
(define fi-seeie-name		"&See;")
(define fi-seealsoie-name	"&Seealso;")
(define fi-set-name		"&Set;")
(define fi-sidebar-name	"&Sidebar;")
(define fi-step-name		"&step;")
(define fi-table-name		"&Table;")
(define fi-tip-name		"&Tip;")
(define fi-toc-name		"&TableofContents;")
(define fi-warning-name	"&Warning;")

(define (gentext-fi-element-name gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract"))	fi-abstract-name)
     ((equal? name (normalize "appendix"))	fi-appendix-name)
     ((equal? name (normalize "article"))	fi-article-name)
     ((equal? name (normalize "bibliography"))	fi-bibliography-name)
     ((equal? name (normalize "book"))		fi-book-name)
     ((equal? name (normalize "calloutlist"))	fi-calloutlist-name)
     ((equal? name (normalize "caution"))	fi-caution-name)
     ((equal? name (normalize "chapter"))	fi-chapter-name)
     ((equal? name (normalize "copyright"))	fi-copyright-name)
     ((equal? name (normalize "dedication"))	fi-dedication-name)
     ((equal? name (normalize "edition"))	fi-edition-name)
     ((equal? name (normalize "equation"))	fi-equation-name)
     ((equal? name (normalize "example"))	fi-example-name)
     ((equal? name (normalize "figure"))	fi-figure-name)
     ((equal? name (normalize "glossary"))	fi-glossary-name)
     ((equal? name (normalize "glosssee"))	fi-glosssee-name)
     ((equal? name (normalize "glossseealso"))	fi-glossseealso-name)
     ((equal? name (normalize "important"))	fi-important-name)
     ((equal? name (normalize "index"))		fi-index-name)
     ((equal? name (normalize "setindex"))	fi-setindex-name)
     ((equal? name (normalize "isbn"))		fi-isbn-name)
     ((equal? name (normalize "legalnotice"))	fi-legalnotice-name)
     ((equal? name (normalize "msgaud"))	fi-msgaud-name)
     ((equal? name (normalize "msglevel"))	fi-msglevel-name)
     ((equal? name (normalize "msgorig"))	fi-msgorig-name)
     ((equal? name (normalize "note"))		fi-note-name)
     ((equal? name (normalize "part"))		fi-part-name)
     ((equal? name (normalize "preface"))	fi-preface-name)
     ((equal? name (normalize "procedure"))	fi-procedure-name)
     ((equal? name (normalize "pubdate"))	fi-pubdate-name)
     ((equal? name (normalize "reference"))	fi-reference-name)
     ((equal? name (normalize "refname"))	fi-refname-name)
     ((equal? name (normalize "revhistory"))	fi-revhistory-name)
     ((equal? name (normalize "revision"))	fi-revision-name)
     ((equal? name (normalize "sect1"))		fi-sect1-name)
     ((equal? name (normalize "sect2"))		fi-sect2-name)
     ((equal? name (normalize "sect3"))		fi-sect3-name)
     ((equal? name (normalize "sect4"))		fi-sect4-name)
     ((equal? name (normalize "sect5"))		fi-sect5-name)
     ((equal? name (normalize "simplesect"))    fi-simplesect-name)
     ((equal? name (normalize "seeie"))		fi-seeie-name)
     ((equal? name (normalize "seealsoie"))	fi-seealsoie-name)
     ((equal? name (normalize "set"))		fi-set-name)
     ((equal? name (normalize "sidebar"))	fi-sidebar-name)
     ((equal? name (normalize "step"))		fi-step-name)
     ((equal? name (normalize "table"))		fi-table-name)
     ((equal? name (normalize "tip"))		fi-tip-name)
     ((equal? name (normalize "toc"))		fi-toc-name)
     ((equal? name (normalize "warning"))	fi-warning-name)
     (else (let* ((msg (string-append "gentext-fi-element-name: &unexpectedelementname;: " name))
		  (err (node-list-error msg (current-node))))
	     msg)))))

;; gentext-element-name-space returns gentext-element-name with a 
;; trailing space, if gentext-element-name isn't "".
;;
(define (gentext-fi-element-name-space giname)
  (string-with-space (gentext-element-name giname)))

;; gentext-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;

(define fi-equation-intra-label-sep "-")
(define fi-example-intra-label-sep "-")
(define fi-figure-intra-label-sep "-")
(define fi-procedure-intra-label-sep ".")
(define fi-refentry-intra-label-sep ".")
(define fi-reference-intra-label-sep ".")
(define fi-refname-intra-label-sep ", ")
(define fi-refsect1-intra-label-sep ".")
(define fi-refsect2-intra-label-sep ".")
(define fi-refsect3-intra-label-sep ".")
(define fi-sect1-intra-label-sep ".")
(define fi-sect2-intra-label-sep ".")
(define fi-sect3-intra-label-sep ".")
(define fi-sect4-intra-label-sep ".")
(define fi-sect5-intra-label-sep ".")
(define fi-step-intra-label-sep ".")
(define fi-table-intra-label-sep "-")
(define fi-_pagenumber-intra-label-sep "-")
(define fi-default-intra-label-sep "")

(define (gentext-fi-intra-label-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "equation"))	fi-equation-intra-label-sep)
     ((equal? name (normalize "example"))	fi-example-intra-label-sep)
     ((equal? name (normalize "figure"))	fi-figure-intra-label-sep)
     ((equal? name (normalize "procedure"))	fi-procedure-intra-label-sep)
     ((equal? name (normalize "refentry"))	fi-refentry-intra-label-sep)
     ((equal? name (normalize "reference"))	fi-reference-intra-label-sep)
     ((equal? name (normalize "refname"))	fi-refname-intra-label-sep)
     ((equal? name (normalize "refsect1"))	fi-refsect1-intra-label-sep)
     ((equal? name (normalize "refsect2"))	fi-refsect2-intra-label-sep)
     ((equal? name (normalize "refsect3"))	fi-refsect3-intra-label-sep)
     ((equal? name (normalize "sect1"))		fi-sect1-intra-label-sep)
     ((equal? name (normalize "sect2"))		fi-sect2-intra-label-sep)
     ((equal? name (normalize "sect3"))		fi-sect3-intra-label-sep)
     ((equal? name (normalize "sect4"))		fi-sect4-intra-label-sep)
     ((equal? name (normalize "sect5"))		fi-sect5-intra-label-sep)
     ((equal? name (normalize "step"))		fi-step-intra-label-sep)
     ((equal? name (normalize "table"))		fi-table-intra-label-sep)
     ((equal? name (normalize "_pagenumber"))	fi-_pagenumber-intra-label-sep)
     (else fi-default-intra-label-sep))))

;; gentext-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;

(define fi-abstract-label-title-sep " ")
(define fi-appendix-label-title-sep " ")
(define fi-caution-label-title-sep "")
(define fi-chapter-label-title-sep " ")
(define fi-equation-label-title-sep " ")
(define fi-example-label-title-sep " ")
(define fi-figure-label-title-sep " ")
(define fi-footnote-label-title-sep " ")
(define fi-glosssee-label-title-sep ": ")
(define fi-glossseealso-label-title-sep ": ")
(define fi-important-label-title-sep ": ")
(define fi-note-label-title-sep ": ")
(define fi-orderedlist-label-title-sep ". ")
(define fi-part-label-title-sep " ")
(define fi-procedure-label-title-sep " ")
(define fi-prefix-label-title-sep ". ")
(define fi-refentry-label-title-sep "")
(define fi-reference-label-title-sep ". ")
(define fi-refsect1-label-title-sep ". ")
(define fi-refsect2-label-title-sep ". ")
(define fi-refsect3-label-title-sep ". ")
(define fi-sect1-label-title-sep " ")
(define fi-sect2-label-title-sep " ")
(define fi-sect3-label-title-sep " ")
(define fi-sect4-label-title-sep " ")
(define fi-sect5-label-title-sep " ")
(define fi-seeie-label-title-sep " ")
(define fi-seealsoie-label-title-sep " ")
(define fi-step-label-title-sep ". ")
(define fi-table-label-title-sep " ")
(define fi-tip-label-title-sep ": ")
(define fi-warning-label-title-sep "")
(define fi-default-label-title-sep "")

(define (gentext-fi-label-title-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract")) fi-abstract-label-title-sep)
     ((equal? name (normalize "appendix")) fi-appendix-label-title-sep)
     ((equal? name (normalize "caution")) fi-caution-label-title-sep)
     ((equal? name (normalize "chapter")) fi-chapter-label-title-sep)
     ((equal? name (normalize "equation")) fi-equation-label-title-sep)
     ((equal? name (normalize "example")) fi-example-label-title-sep)
     ((equal? name (normalize "figure")) fi-figure-label-title-sep)
     ((equal? name (normalize "footnote")) fi-footnote-label-title-sep)
     ((equal? name (normalize "glosssee")) fi-glosssee-label-title-sep)
     ((equal? name (normalize "glossseealso")) fi-glossseealso-label-title-sep)
     ((equal? name (normalize "important")) fi-important-label-title-sep)
     ((equal? name (normalize "note")) fi-note-label-title-sep)
     ((equal? name (normalize "orderedlist")) fi-orderedlist-label-title-sep)
     ((equal? name (normalize "part")) fi-part-label-title-sep)
     ((equal? name (normalize "procedure")) fi-procedure-label-title-sep)
     ((equal? name (normalize "prefix")) fi-prefix-label-title-sep)
     ((equal? name (normalize "refentry")) fi-refentry-label-title-sep)
     ((equal? name (normalize "reference")) fi-reference-label-title-sep)
     ((equal? name (normalize "refsect1")) fi-refsect1-label-title-sep)
     ((equal? name (normalize "refsect2")) fi-refsect2-label-title-sep)
     ((equal? name (normalize "refsect3")) fi-refsect3-label-title-sep)
     ((equal? name (normalize "sect1")) fi-sect1-label-title-sep)
     ((equal? name (normalize "sect2")) fi-sect2-label-title-sep)
     ((equal? name (normalize "sect3")) fi-sect3-label-title-sep)
     ((equal? name (normalize "sect4")) fi-sect4-label-title-sep)
     ((equal? name (normalize "sect5")) fi-sect5-label-title-sep)
     ((equal? name (normalize "seeie")) fi-seeie-label-title-sep)
     ((equal? name (normalize "seealsoie")) fi-seealsoie-label-title-sep)
     ((equal? name (normalize "step")) fi-step-label-title-sep)
     ((equal? name (normalize "table")) fi-table-label-title-sep)
     ((equal? name (normalize "tip")) fi-tip-label-title-sep)
     ((equal? name (normalize "warning")) fi-warning-label-title-sep)
     (else fi-default-label-title-sep))))

(define (fi-set-label-number-format gind) "1")
(define (fi-book-label-number-format gind) "1")
(define (fi-prefix-label-number-format gind) "1")
(define (fi-part-label-number-format gind) "I")
(define (fi-chapter-label-number-format gind) "1")
(define (fi-appendix-label-number-format gind) "A")
(define (fi-reference-label-number-format gind) "I")
(define (fi-example-label-number-format gind) "1")
(define (fi-figure-label-number-format gind) "1")
(define (fi-table-label-number-format gind) "1")
(define (fi-procedure-label-number-format gind) "1")
(define (fi-step-label-number-format gind) "1")
(define (fi-refsect1-label-number-format gind) "1")
(define (fi-refsect2-label-number-format gind) "1")
(define (fi-refsect3-label-number-format gind) "1")
(define (fi-sect1-label-number-format gind) "1")
(define (fi-sect2-label-number-format gind) "1")
(define (fi-sect3-label-number-format gind) "1")
(define (fi-sect4-label-number-format gind) "1")
(define (fi-sect5-label-number-format gind) "1")
(define (fi-default-label-number-format gind) "1")

(define (fi-label-number-format gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "set")) (fi-set-label-number-format gind))
     ((equal? name (normalize "book")) (fi-book-label-number-format gind))
     ((equal? name (normalize "prefix")) (fi-prefix-label-number-format gind))
     ((equal? name (normalize "part")) (fi-part-label-number-format gind))
     ((equal? name (normalize "chapter")) (fi-chapter-label-number-format gind))
     ((equal? name (normalize "appendix")) (fi-appendix-label-number-format gind))
     ((equal? name (normalize "reference")) (fi-reference-label-number-format gind))
     ((equal? name (normalize "example")) (fi-example-label-number-format gind))
     ((equal? name (normalize "figure")) (fi-figure-label-number-format gind))
     ((equal? name (normalize "table")) (fi-table-label-number-format gind))
     ((equal? name (normalize "procedure")) (fi-procedure-label-number-format gind))
     ((equal? name (normalize "step")) (fi-step-label-number-format gind))
     ((equal? name (normalize "refsect1")) (fi-refsect1-label-number-format gind))
     ((equal? name (normalize "refsect2")) (fi-refsect2-label-number-format gind))
     ((equal? name (normalize "refsect3")) (fi-refsect3-label-number-format gind))
     ((equal? name (normalize "sect1")) (fi-sect1-label-number-format gind))
     ((equal? name (normalize "sect2")) (fi-sect2-label-number-format gind))
     ((equal? name (normalize "sect3")) (fi-sect3-label-number-format gind))
     ((equal? name (normalize "sect4")) (fi-sect4-label-number-format gind))
     ((equal? name (normalize "sect5")) (fi-sect5-label-number-format gind))
     (else (fi-default-label-number-format gind)))))

(define ($lot-title-fi$ gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond ((equal? name (normalize "table"))    "&ListofTables;")
	  ((equal? name (normalize "example"))  "&ListofExamples;")
	  ((equal? name (normalize "figure"))   "&ListofFigures;")
	  ((equal? name (normalize "equation")) "&ListofEquations;")
	  (else (let* ((msg (string-append "&ListofUnknown;: " name))
		       (err (node-list-error msg (current-node))))
		  msg)))))

(define %gentext-fi-start-quote% (dingbat "ldquo"))

(define %gentext-fi-end-quote% (dingbat "rdquo"))

(define %gentext-fi-start-nested-quote% (dingbat "lsquo"))

(define %gentext-fi-end-nested-quote% (dingbat "rsquo"))

(define %gentext-fi-by% "&by;") ;; e.g. Copyright 1997 "by" A. Nonymous
                           ;; Authored "by" Jane Doe

(define %gentext-fi-edited-by% "&Editedby;")
                           ;; "Edited by" Jane Doe

(define %gentext-fi-page% "")

(define %gentext-fi-and% "&and;")

(define %gentext-fi-bibl-pages% "&Pgs;")

(define %gentext-fi-endnotes% "&Notes;")

(define %gentext-fi-table-endnotes% "&TableNotes;:")

(define %gentext-fi-index-see% "&See;")

(define %gentext-fi-index-seealso% "&SeeAlso;")

