;; $Id: dbl1ja.dsl,v 1.2 1999/03/02 11:51:57 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; If you create a new version of this file, please send it to
;; Norman Walsh, ndw@nwalsh.com

;; Contributors:
;; Karl Critz, kcritz@mathworks.com, contributed the original dbl1ja.ent file
;;

(define (ja-appendix-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Appendix; %n"
      "the &appendix; called %t"))

(define (ja-article-xref-string gi-or-name)
  (string-append %gentext-ja-start-quote%
		 "%t"
		 %gentext-ja-end-quote%))

(define (ja-bibliography-xref-string gi-or-name)
  "%t")

(define (ja-book-xref-string gi-or-name)
  "%t")

(define (ja-chapter-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Chapter; %n"
      "the &chapter; called %t"))

(define (ja-equation-xref-string gi-or-name)
  "&Equation; %n")

(define (ja-example-xref-string gi-or-name)
  "&Example; %n")

(define (ja-figure-xref-string gi-or-name)
  "&Figure; %n")

(define (ja-glossary-xref-string gi-or-name)
  "%t")

(define (ja-index-xref-string gi-or-name)
  "%t")

(define (ja-listitem-xref-string gi-or-name)
  "%n")

(define (ja-part-xref-string gi-or-name)
  "&Part; %n")

(define (ja-preface-xref-string gi-or-name)
  "%t")

(define (ja-procedure-xref-string gi-or-name)
  "&Procedure; %n, %t")

(define (ja-reference-xref-string gi-or-name)
  "&Reference; %n, %t")

(define (ja-sectioning-xref-string gi-or-name)
  (if %section-autolabel% 
      "&Section; %n" 
      "the &section; called %t"))

(define (ja-sect1-xref-string gi-or-name)
  (ja-sectioning-xref-string gi-or-name))

(define (ja-sect2-xref-string gi-or-name)
  (ja-sectioning-xref-string gi-or-name))

(define (ja-sect3-xref-string gi-or-name)
  (ja-sectioning-xref-string gi-or-name))

(define (ja-sect4-xref-string gi-or-name)
  (ja-sectioning-xref-string gi-or-name))

(define (ja-sect5-xref-string gi-or-name)
  (ja-sectioning-xref-string gi-or-name))

(define (ja-section-xref-string gi-or-name)
  (ja-sectioning-xref-string gi-or-name))

(define (ja-sidebar-xref-string gi-or-name)
  "the &sidebar; %t")

(define (ja-step-xref-string gi-or-name)
  "&step; %n")

(define (ja-table-xref-string gi-or-name)
  "&Table; %n")

(define (ja-default-xref-string gi-or-name)
  (let* ((giname (if (string? gi-or-name) gi-or-name (gi gi-or-name)))
	 (msg    (string-append "[&xrefto; "
				(if giname giname "&nonexistantelement;")
				" &unsupported;]"))
	 (err    (node-list-error msg (current-node))))
    msg))

(define (gentext-ja-xref-strings gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
      ((equal? name (normalize "appendix")) (ja-appendix-xref-string gind))
      ((equal? name (normalize "article"))  (ja-article-xref-string gind))
      ((equal? name (normalize "bibliography")) (ja-bibliography-xref-string gind))
      ((equal? name (normalize "book"))     (ja-book-xref-string gind))
      ((equal? name (normalize "chapter"))  (ja-chapter-xref-string gind))
      ((equal? name (normalize "equation")) (ja-equation-xref-string gind))
      ((equal? name (normalize "example"))  (ja-example-xref-string gind))
      ((equal? name (normalize "figure"))   (ja-figure-xref-string gind))
      ((equal? name (normalize "glossary")) (ja-glossary-xref-string gind))
      ((equal? name (normalize "index"))    (ja-index-xref-string gind))
      ((equal? name (normalize "listitem")) (ja-listitem-xref-string gind))
      ((equal? name (normalize "part"))     (ja-part-xref-string gind))
      ((equal? name (normalize "preface"))  (ja-preface-xref-string gind))
      ((equal? name (normalize "procedure")) (ja-procedure-xref-string gind))
      ((equal? name (normalize "reference")) (ja-reference-xref-string gind))
      ((equal? name (normalize "sect1"))    (ja-sect1-xref-string gind))
      ((equal? name (normalize "sect2"))    (ja-sect2-xref-string gind))
      ((equal? name (normalize "sect3"))    (ja-sect3-xref-string gind))
      ((equal? name (normalize "sect4"))    (ja-sect4-xref-string gind))
      ((equal? name (normalize "sect5"))    (ja-sect5-xref-string gind))
      ((equal? name (normalize "section"))  (ja-section-xref-string gind))
      ((equal? name (normalize "simplesect"))  (ja-section-xref-string gind))
      ((equal? name (normalize "sidebar"))  (ja-sidebar-xref-string gind))
      ((equal? name (normalize "step"))     (ja-step-xref-string gind))
      ((equal? name (normalize "table"))    (ja-table-xref-string gind))
      (else (ja-default-xref-string gind)))))

(define (ja-auto-xref-indirect-connector before) 
  ;; In English, the (cond) is unnecessary since the word is always the
  ;; same, but in other languages, that's not the case.  I've set this
  ;; one up with the (cond) so it stands as an example.
  (cond 
   ((equal? (gi before) (normalize "book"))
    (literal " &in; "))
   ((equal? (gi before) (normalize "chapter"))
    (literal " &in; "))
   ((equal? (gi before) (normalize "sect1"))
    (literal " &in; "))
   (else
    (literal " &in; "))))

;; Should the TOC come first or last?
;;
(define %generate-ja-toc-in-front% #t)

;; gentext-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define ja-abstract-name	"&Abstract;")
(define ja-appendix-name	"&Appendix;")
(define ja-article-name	"&Article;")
(define ja-bibliography-name	"&Bibliography;")
(define ja-book-name		"&Book;")
(define ja-calloutlist-name	"")
(define ja-caution-name	"&Caution;")
(define ja-chapter-name	"&Chapter;")
(define ja-copyright-name	"&Copyright;")
(define ja-dedication-name	"&Dedication;")
(define ja-edition-name	"&Edition;")
(define ja-equation-name	"&Equation;")
(define ja-example-name	"&Example;")
(define ja-figure-name	"&Figure;")
(define ja-glossary-name	"&Glossary;")
(define ja-glosssee-name	"&GlossSee;")
(define ja-glossseealso-name	"&GlossSeeAlso;")
(define ja-important-name	"&Important;")
(define ja-index-name		"&Index;")
(define ja-setindex-name	"&SetIndex;")
(define ja-isbn-name		"&ISBN;")
(define ja-legalnotice-name	"&LegalNotice;")
(define ja-msgaud-name	"&MsgAud;")
(define ja-msglevel-name	"&MsgLevel;")
(define ja-msgorig-name	"&MsgOrig;")
(define ja-note-name		"&Note;")
(define ja-part-name		"&Part;")
(define ja-preface-name	"&Preface;")
(define ja-procedure-name	"&Procedure;")
(define ja-pubdate-name	"&Published;")
(define ja-reference-name	"&Reference;")
(define ja-refname-name	"&RefName;")
(define ja-revhistory-name	"&RevHistory;")
(define ja-revision-name	"&Revision;")
(define ja-sect1-name		"&Section;")
(define ja-sect2-name		"&Section;")
(define ja-sect3-name		"&Section;")
(define ja-sect4-name		"&Section;")
(define ja-sect5-name		"&Section;")
(define ja-section-name		"&Section;")
(define ja-simplesect-name	"&Section;")
(define ja-seeie-name		"&See;")
(define ja-seealsoie-name	"&Seealso;")
(define ja-set-name		"&Set;")
(define ja-sidebar-name	"&Sidebar;")
(define ja-step-name		"&step;")
(define ja-table-name		"&Table;")
(define ja-tip-name		"&Tip;")
(define ja-toc-name		"&TableofContents;")
(define ja-warning-name	"&Warning;")

(define (gentext-ja-element-name gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract"))	ja-abstract-name)
     ((equal? name (normalize "appendix"))	ja-appendix-name)
     ((equal? name (normalize "article"))	ja-article-name)
     ((equal? name (normalize "bibliography"))	ja-bibliography-name)
     ((equal? name (normalize "book"))		ja-book-name)
     ((equal? name (normalize "calloutlist"))	ja-calloutlist-name)
     ((equal? name (normalize "caution"))	ja-caution-name)
     ((equal? name (normalize "chapter"))	ja-chapter-name)
     ((equal? name (normalize "copyright"))	ja-copyright-name)
     ((equal? name (normalize "dedication"))	ja-dedication-name)
     ((equal? name (normalize "edition"))	ja-edition-name)
     ((equal? name (normalize "equation"))	ja-equation-name)
     ((equal? name (normalize "example"))	ja-example-name)
     ((equal? name (normalize "figure"))	ja-figure-name)
     ((equal? name (normalize "glossary"))	ja-glossary-name)
     ((equal? name (normalize "glosssee"))	ja-glosssee-name)
     ((equal? name (normalize "glossseealso"))	ja-glossseealso-name)
     ((equal? name (normalize "important"))	ja-important-name)
     ((equal? name (normalize "index"))		ja-index-name)
     ((equal? name (normalize "setindex"))	ja-setindex-name)
     ((equal? name (normalize "isbn"))		ja-isbn-name)
     ((equal? name (normalize "legalnotice"))	ja-legalnotice-name)
     ((equal? name (normalize "msgaud"))	ja-msgaud-name)
     ((equal? name (normalize "msglevel"))	ja-msglevel-name)
     ((equal? name (normalize "msgorig"))	ja-msgorig-name)
     ((equal? name (normalize "note"))		ja-note-name)
     ((equal? name (normalize "part"))		ja-part-name)
     ((equal? name (normalize "preface"))	ja-preface-name)
     ((equal? name (normalize "procedure"))	ja-procedure-name)
     ((equal? name (normalize "pubdate"))	ja-pubdate-name)
     ((equal? name (normalize "reference"))	ja-reference-name)
     ((equal? name (normalize "refname"))	ja-refname-name)
     ((equal? name (normalize "revhistory"))	ja-revhistory-name)
     ((equal? name (normalize "revision"))	ja-revision-name)
     ((equal? name (normalize "sect1"))		ja-sect1-name)
     ((equal? name (normalize "sect2"))		ja-sect2-name)
     ((equal? name (normalize "sect3"))		ja-sect3-name)
     ((equal? name (normalize "sect4"))		ja-sect4-name)
     ((equal? name (normalize "sect5"))		ja-sect5-name)
     ((equal? name (normalize "section"))	ja-section-name)
     ((equal? name (normalize "simplesect"))    ja-simplesect-name)
     ((equal? name (normalize "seeie"))		ja-seeie-name)
     ((equal? name (normalize "seealsoie"))	ja-seealsoie-name)
     ((equal? name (normalize "set"))		ja-set-name)
     ((equal? name (normalize "sidebar"))	ja-sidebar-name)
     ((equal? name (normalize "step"))		ja-step-name)
     ((equal? name (normalize "table"))		ja-table-name)
     ((equal? name (normalize "tip"))		ja-tip-name)
     ((equal? name (normalize "toc"))		ja-toc-name)
     ((equal? name (normalize "warning"))	ja-warning-name)
     (else (let* ((msg (string-append "gentext-ja-element-name: &unexpectedelementname;: " name))
		  (err (node-list-error msg (current-node))))
	     msg)))))

;; gentext-element-name-space returns gentext-element-name with a 
;; trailing space, if gentext-element-name isn't "".
;;
(define (gentext-ja-element-name-space giname)
  (string-with-space (gentext-element-name giname)))

;; gentext-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;

(define ja-equation-intra-label-sep "-")
(define ja-informalequation-intra-label-sep "-")
(define ja-example-intra-label-sep "-")
(define ja-figure-intra-label-sep "-")
(define ja-listitem-intra-label-sep ".")
(define ja-procedure-intra-label-sep ".")
(define ja-refentry-intra-label-sep ".")
(define ja-reference-intra-label-sep ".")
(define ja-refname-intra-label-sep ", ")
(define ja-refsect1-intra-label-sep ".")
(define ja-refsect2-intra-label-sep ".")
(define ja-refsect3-intra-label-sep ".")
(define ja-sect1-intra-label-sep ".")
(define ja-sect2-intra-label-sep ".")
(define ja-sect3-intra-label-sep ".")
(define ja-sect4-intra-label-sep ".")
(define ja-sect5-intra-label-sep ".")
(define ja-section-intra-label-sep ".")
(define ja-simplesect-intra-label-sep ".")
(define ja-step-intra-label-sep ".")
(define ja-table-intra-label-sep "-")
(define ja-_pagenumber-intra-label-sep "-")
(define ja-default-intra-label-sep "")

(define (gentext-ja-intra-label-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "equation"))	ja-equation-intra-label-sep)
     ((equal? name (normalize "informalequation"))	ja-informalequation-intra-label-sep)
     ((equal? name (normalize "example"))	ja-example-intra-label-sep)
     ((equal? name (normalize "figure"))	ja-figure-intra-label-sep)
     ((equal? name (normalize "listitem"))	ja-listitem-intra-label-sep)
     ((equal? name (normalize "procedure"))	ja-procedure-intra-label-sep)
     ((equal? name (normalize "refentry"))	ja-refentry-intra-label-sep)
     ((equal? name (normalize "reference"))	ja-reference-intra-label-sep)
     ((equal? name (normalize "refname"))	ja-refname-intra-label-sep)
     ((equal? name (normalize "refsect1"))	ja-refsect1-intra-label-sep)
     ((equal? name (normalize "refsect2"))	ja-refsect2-intra-label-sep)
     ((equal? name (normalize "refsect3"))	ja-refsect3-intra-label-sep)
     ((equal? name (normalize "sect1"))		ja-sect1-intra-label-sep)
     ((equal? name (normalize "sect2"))		ja-sect2-intra-label-sep)
     ((equal? name (normalize "sect3"))		ja-sect3-intra-label-sep)
     ((equal? name (normalize "sect4"))		ja-sect4-intra-label-sep)
     ((equal? name (normalize "sect5"))		ja-sect5-intra-label-sep)
     ((equal? name (normalize "section"))	ja-section-intra-label-sep)
     ((equal? name (normalize "simplesect"))	ja-simplesect-intra-label-sep)
     ((equal? name (normalize "step"))		ja-step-intra-label-sep)
     ((equal? name (normalize "table"))		ja-table-intra-label-sep)
     ((equal? name (normalize "_pagenumber"))	ja-_pagenumber-intra-label-sep)
     (else ja-default-intra-label-sep))))

;; gentext-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;

(define ja-abstract-label-title-sep ": ")
(define ja-appendix-label-title-sep ". ")
(define ja-caution-label-title-sep "")
(define ja-chapter-label-title-sep ". ")
(define ja-equation-label-title-sep ". ")
(define ja-example-label-title-sep ". ")
(define ja-figure-label-title-sep ". ")
(define ja-footnote-label-title-sep ". ")
(define ja-glosssee-label-title-sep ": ")
(define ja-glossseealso-label-title-sep ": ")
(define ja-important-label-title-sep ": ")
(define ja-note-label-title-sep ": ")
(define ja-orderedlist-label-title-sep ". ")
(define ja-part-label-title-sep ". ")
(define ja-procedure-label-title-sep ". ")
(define ja-prefix-label-title-sep ". ")
(define ja-refentry-label-title-sep "")
(define ja-reference-label-title-sep ". ")
(define ja-refsect1-label-title-sep ". ")
(define ja-refsect2-label-title-sep ". ")
(define ja-refsect3-label-title-sep ". ")
(define ja-sect1-label-title-sep ". ")
(define ja-sect2-label-title-sep ". ")
(define ja-sect3-label-title-sep ". ")
(define ja-sect4-label-title-sep ". ")
(define ja-sect5-label-title-sep ". ")
(define ja-section-label-title-sep ". ")
(define ja-simplesect-label-title-sep ". ")
(define ja-seeie-label-title-sep " ")
(define ja-seealsoie-label-title-sep " ")
(define ja-step-label-title-sep ". ")
(define ja-table-label-title-sep ". ")
(define ja-tip-label-title-sep ": ")
(define ja-warning-label-title-sep "")
(define ja-default-label-title-sep "")

(define (gentext-ja-label-title-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract")) ja-abstract-label-title-sep)
     ((equal? name (normalize "appendix")) ja-appendix-label-title-sep)
     ((equal? name (normalize "caution")) ja-caution-label-title-sep)
     ((equal? name (normalize "chapter")) ja-chapter-label-title-sep)
     ((equal? name (normalize "equation")) ja-equation-label-title-sep)
     ((equal? name (normalize "example")) ja-example-label-title-sep)
     ((equal? name (normalize "figure")) ja-figure-label-title-sep)
     ((equal? name (normalize "footnote")) ja-footnote-label-title-sep)
     ((equal? name (normalize "glosssee")) ja-glosssee-label-title-sep)
     ((equal? name (normalize "glossseealso")) ja-glossseealso-label-title-sep)
     ((equal? name (normalize "important")) ja-important-label-title-sep)
     ((equal? name (normalize "note")) ja-note-label-title-sep)
     ((equal? name (normalize "orderedlist")) ja-orderedlist-label-title-sep)
     ((equal? name (normalize "part")) ja-part-label-title-sep)
     ((equal? name (normalize "procedure")) ja-procedure-label-title-sep)
     ((equal? name (normalize "prefix")) ja-prefix-label-title-sep)
     ((equal? name (normalize "refentry")) ja-refentry-label-title-sep)
     ((equal? name (normalize "reference")) ja-reference-label-title-sep)
     ((equal? name (normalize "refsect1")) ja-refsect1-label-title-sep)
     ((equal? name (normalize "refsect2")) ja-refsect2-label-title-sep)
     ((equal? name (normalize "refsect3")) ja-refsect3-label-title-sep)
     ((equal? name (normalize "sect1")) ja-sect1-label-title-sep)
     ((equal? name (normalize "sect2")) ja-sect2-label-title-sep)
     ((equal? name (normalize "sect3")) ja-sect3-label-title-sep)
     ((equal? name (normalize "sect4")) ja-sect4-label-title-sep)
     ((equal? name (normalize "sect5")) ja-sect5-label-title-sep)
     ((equal? name (normalize "section")) ja-section-label-title-sep)
     ((equal? name (normalize "simplesect")) ja-simplesect-label-title-sep)
     ((equal? name (normalize "seeie")) ja-seeie-label-title-sep)
     ((equal? name (normalize "seealsoie")) ja-seealsoie-label-title-sep)
     ((equal? name (normalize "step")) ja-step-label-title-sep)
     ((equal? name (normalize "table")) ja-table-label-title-sep)
     ((equal? name (normalize "tip")) ja-tip-label-title-sep)
     ((equal? name (normalize "warning")) ja-warning-label-title-sep)
     (else ja-default-label-title-sep))))

(define (ja-set-label-number-format gind) "1")
(define (ja-book-label-number-format gind) "1")
(define (ja-prefix-label-number-format gind) "1")
(define (ja-part-label-number-format gind) "I")
(define (ja-chapter-label-number-format gind) "1")
(define (ja-appendix-label-number-format gind) "A")
(define (ja-reference-label-number-format gind) "I")
(define (ja-example-label-number-format gind) "1")
(define (ja-figure-label-number-format gind) "1")
(define (ja-table-label-number-format gind) "1")
(define (ja-procedure-label-number-format gind) "1")
(define (ja-step-label-number-format gind) "1")
(define (ja-refsect1-label-number-format gind) "1")
(define (ja-refsect2-label-number-format gind) "1")
(define (ja-refsect3-label-number-format gind) "1")
(define (ja-sect1-label-number-format gind) "1")
(define (ja-sect2-label-number-format gind) "1")
(define (ja-sect3-label-number-format gind) "1")
(define (ja-sect4-label-number-format gind) "1")
(define (ja-sect5-label-number-format gind) "1")
(define (ja-section-label-number-format gind) "1")
(define (ja-default-label-number-format gind) "1")

(define (ja-label-number-format gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "set")) (ja-set-label-number-format gind))
     ((equal? name (normalize "book")) (ja-book-label-number-format gind))
     ((equal? name (normalize "prefix")) (ja-prefix-label-number-format gind))
     ((equal? name (normalize "part")) (ja-part-label-number-format gind))
     ((equal? name (normalize "chapter")) (ja-chapter-label-number-format gind))
     ((equal? name (normalize "appendix")) (ja-appendix-label-number-format gind))
     ((equal? name (normalize "reference")) (ja-reference-label-number-format gind))
     ((equal? name (normalize "example")) (ja-example-label-number-format gind))
     ((equal? name (normalize "figure")) (ja-figure-label-number-format gind))
     ((equal? name (normalize "table")) (ja-table-label-number-format gind))
     ((equal? name (normalize "procedure")) (ja-procedure-label-number-format gind))
     ((equal? name (normalize "step")) (ja-step-label-number-format gind))
     ((equal? name (normalize "refsect1")) (ja-refsect1-label-number-format gind))
     ((equal? name (normalize "refsect2")) (ja-refsect2-label-number-format gind))
     ((equal? name (normalize "refsect3")) (ja-refsect3-label-number-format gind))
     ((equal? name (normalize "sect1")) (ja-sect1-label-number-format gind))
     ((equal? name (normalize "sect2")) (ja-sect2-label-number-format gind))
     ((equal? name (normalize "sect3")) (ja-sect3-label-number-format gind))
     ((equal? name (normalize "sect4")) (ja-sect4-label-number-format gind))
     ((equal? name (normalize "sect5")) (ja-sect5-label-number-format gind))
     ((equal? name (normalize "section")) (ja-section-label-number-format gind))
     (else (ja-default-label-number-format gind)))))

(define ($lot-title-ja$ gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond ((equal? name (normalize "table"))    "&ListofTables;")
	  ((equal? name (normalize "example"))  "&ListofExamples;")
	  ((equal? name (normalize "figure"))   "&ListofFigures;")
	  ((equal? name (normalize "equation")) "&ListofEquations;")
	  (else (let* ((msg (string-append "&ListofUnknown;: " name))
		       (err (node-list-error msg (current-node))))
		  msg)))))

(define %gentext-ja-start-quote% (dingbat "ldquo"))

(define %gentext-ja-end-quote% (dingbat "rdquo"))

(define %gentext-ja-start-nested-quote% (dingbat "lsquo"))

(define %gentext-ja-end-nested-quote% (dingbat "rsquo"))

(define %gentext-ja-by% "&by;") ;; e.g. Copyright 1997 "by" A. Nonymous
                           ;; Authored "by" Jane Doe

(define %gentext-ja-edited-by% "&Editedby;")
                           ;; "Edited by" Jane Doe

(define %gentext-ja-page% "")

(define %gentext-ja-and% "&and;")

(define %gentext-ja-bibl-pages% "&Pgs;")

(define %gentext-ja-endnotes% "&Notes;")

(define %gentext-ja-table-endnotes% "&TableNotes;:")

(define %gentext-ja-index-see% "&See;")

(define %gentext-ja-index-seealso% "&SeeAlso;")

