/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="3.0.0", label="dataformat,transformation,json", title="CBOR")
@XmlRootElement(name="cbor")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CBORDataFormat
extends DataFormatDefinition {
    @XmlTransient
    private Class<?> collectionType;
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlAttribute
    @Metadata(label="advanced")
    private String objectMapper;
    @XmlAttribute
    @Metadata(defaultValue="true", javaType="java.lang.Boolean")
    private String useDefaultObjectMapper;
    @XmlAttribute(name="unmarshalType")
    private String unmarshalTypeName;
    @XmlAttribute(name="collectionType")
    @Metadata(label="advanced")
    private String collectionTypeName;
    @XmlAttribute
    @Metadata(defaultValue="false", javaType="java.lang.Boolean")
    private String useList;
    @XmlAttribute
    @Metadata(defaultValue="false", javaType="java.lang.Boolean")
    private String allowUnmarshallType;
    @XmlAttribute
    @Metadata(defaultValue="false", javaType="java.lang.Boolean")
    private String prettyPrint;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="false", javaType="java.lang.Boolean")
    private String allowJmsType;
    @XmlAttribute
    private String enableFeatures;
    @XmlAttribute
    private String disableFeatures;

    public CBORDataFormat() {
        super("cbor");
    }

    protected CBORDataFormat(CBORDataFormat source) {
        super(source);
        this.collectionType = source.collectionType;
        this.unmarshalType = source.unmarshalType;
        this.objectMapper = source.objectMapper;
        this.useDefaultObjectMapper = source.useDefaultObjectMapper;
        this.unmarshalTypeName = source.unmarshalTypeName;
        this.collectionTypeName = source.collectionTypeName;
        this.useList = source.useList;
        this.allowUnmarshallType = source.allowUnmarshallType;
        this.prettyPrint = source.prettyPrint;
        this.allowJmsType = source.allowJmsType;
        this.enableFeatures = source.enableFeatures;
        this.disableFeatures = source.disableFeatures;
    }

    private CBORDataFormat(Builder builder) {
        this();
        this.collectionType = builder.collectionType;
        this.unmarshalType = builder.unmarshalType;
        this.objectMapper = builder.objectMapper;
        this.useDefaultObjectMapper = builder.useDefaultObjectMapper;
        this.unmarshalTypeName = builder.unmarshalTypeName;
        this.collectionTypeName = builder.collectionTypeName;
        this.useList = builder.useList;
        this.allowUnmarshallType = builder.allowUnmarshallType;
        this.prettyPrint = builder.prettyPrint;
        this.allowJmsType = builder.allowJmsType;
        this.enableFeatures = builder.enableFeatures;
        this.disableFeatures = builder.disableFeatures;
    }

    @Override
    public CBORDataFormat copyDefinition() {
        return new CBORDataFormat(this);
    }

    public String getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(String objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String getUseDefaultObjectMapper() {
        return this.useDefaultObjectMapper;
    }

    public void setUseDefaultObjectMapper(String useDefaultObjectMapper) {
        this.useDefaultObjectMapper = useDefaultObjectMapper;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(String prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getAllowJmsType() {
        return this.allowJmsType;
    }

    public void setAllowJmsType(String allowJmsType) {
        this.allowJmsType = allowJmsType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    public void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Class<?> collectionType) {
        this.collectionType = collectionType;
    }

    public String getUseList() {
        return this.useList;
    }

    public void setUseList(String useList) {
        this.useList = useList;
    }

    public String getAllowUnmarshallType() {
        return this.allowUnmarshallType;
    }

    public void setAllowUnmarshallType(String allowUnmarshallType) {
        this.allowUnmarshallType = allowUnmarshallType;
    }

    public String getEnableFeatures() {
        return this.enableFeatures;
    }

    public void setEnableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
    }

    public String getDisableFeatures() {
        return this.disableFeatures;
    }

    public void setDisableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<CBORDataFormat> {
        private Class<?> collectionType;
        private Class<?> unmarshalType;
        private String objectMapper;
        private String useDefaultObjectMapper;
        private String unmarshalTypeName;
        private String collectionTypeName;
        private String useList;
        private String allowUnmarshallType;
        private String prettyPrint;
        private String allowJmsType;
        private String enableFeatures;
        private String disableFeatures;

        public Builder objectMapper(String objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder useDefaultObjectMapper(String useDefaultObjectMapper) {
            this.useDefaultObjectMapper = useDefaultObjectMapper;
            return this;
        }

        public Builder useDefaultObjectMapper(boolean useDefaultObjectMapper) {
            this.useDefaultObjectMapper = Boolean.toString(useDefaultObjectMapper);
            return this;
        }

        public Builder unmarshalTypeName(String unmarshalTypeName) {
            this.unmarshalTypeName = unmarshalTypeName;
            return this;
        }

        public Builder prettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public Builder prettyPrint(boolean prettyPrint) {
            this.prettyPrint = Boolean.toString(prettyPrint);
            return this;
        }

        public Builder allowJmsType(String allowJmsType) {
            this.allowJmsType = allowJmsType;
            return this;
        }

        public Builder allowJmsType(boolean allowJmsType) {
            this.allowJmsType = Boolean.toString(allowJmsType);
            return this;
        }

        public Builder unmarshalType(Class<?> unmarshalType) {
            this.unmarshalType = unmarshalType;
            return this;
        }

        public Builder collectionTypeName(String collectionTypeName) {
            this.collectionTypeName = collectionTypeName;
            return this;
        }

        public Builder collectionType(Class<?> collectionType) {
            this.collectionType = collectionType;
            return this;
        }

        public Builder useList(String useList) {
            this.useList = useList;
            return this;
        }

        public Builder useList(boolean useList) {
            this.useList = Boolean.toString(useList);
            return this;
        }

        public Builder allowUnmarshallType(String allowUnmarshallType) {
            this.allowUnmarshallType = allowUnmarshallType;
            return this;
        }

        public Builder allowUnmarshallType(boolean allowUnmarshallType) {
            this.allowUnmarshallType = Boolean.toString(allowUnmarshallType);
            return this;
        }

        public Builder enableFeatures(String enableFeatures) {
            this.enableFeatures = enableFeatures;
            return this;
        }

        public Builder disableFeatures(String disableFeatures) {
            this.disableFeatures = disableFeatures;
            return this;
        }

        @Override
        public CBORDataFormat end() {
            return new CBORDataFormat(this);
        }
    }
}

