/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerAware;
import org.apache.camel.util.ObjectHelper;

public final class ExpressionToPredicateAdapter
implements Predicate,
CamelContextAware,
PropertyConfigurerAware {
    private final Expression expression;

    public ExpressionToPredicateAdapter(Expression expression) {
        this.expression = expression;
    }

    public boolean matches(Exchange exchange) {
        Expression expression = this.expression;
        if (expression instanceof Predicate) {
            Predicate predicate = (Predicate)expression;
            return predicate.matches(exchange);
        }
        Object value = this.expression.evaluate(exchange, Object.class);
        return ObjectHelper.evaluateValuePredicate((Object)value);
    }

    public String toString() {
        return this.expression.toString();
    }

    public static Predicate toPredicate(Expression expression) {
        if (expression instanceof Predicate) {
            Predicate predicate = (Predicate)expression;
            return predicate;
        }
        return new ExpressionToPredicateAdapter(expression);
    }

    public void init(CamelContext context) {
        this.expression.init(context);
    }

    public void setCamelContext(CamelContext camelContext) {
        CamelContextAware.trySetCamelContext((Object)this.expression, (CamelContext)camelContext);
    }

    public CamelContext getCamelContext() {
        Expression expression = this.expression;
        if (expression instanceof CamelContextAware) {
            CamelContextAware camelContext = (CamelContextAware)expression;
            return camelContext.getCamelContext();
        }
        return null;
    }

    public PropertyConfigurer getPropertyConfigurer(Object instance) {
        Expression expression = this.expression;
        if (expression instanceof PropertyConfigurer) {
            PropertyConfigurer propertyConfigurer = (PropertyConfigurer)expression;
            return propertyConfigurer;
        }
        expression = this.expression;
        if (expression instanceof PropertyConfigurerAware) {
            PropertyConfigurerAware propertyConfigurer = (PropertyConfigurerAware)expression;
            return propertyConfigurer.getPropertyConfigurer((Object)this.expression);
        }
        return null;
    }
}

