/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.ProcessNode;

public abstract class TwoChildProcessNode
extends ProcessNode {
    protected PlanNode leftChild;
    protected PlanNode rightChild;

    protected TwoChildProcessNode(PlanNodeId id) {
        super(id);
    }

    protected TwoChildProcessNode(PlanNodeId id, PlanNode leftChild, PlanNode rightChild) {
        super(id);
        this.leftChild = leftChild;
        this.rightChild = rightChild;
    }

    public PlanNode getLeftChild() {
        return this.leftChild;
    }

    public void setLeftChild(PlanNode leftChild) {
        this.leftChild = leftChild;
    }

    public PlanNode getRightChild() {
        return this.rightChild;
    }

    public void setRightChild(PlanNode rightChild) {
        this.rightChild = rightChild;
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of((Object)this.leftChild, (Object)this.rightChild);
    }

    @Override
    public void addChild(PlanNode child) {
        if (this.leftChild == null) {
            this.leftChild = child;
        } else if (this.rightChild == null) {
            this.rightChild = child;
        } else {
            throw new UnsupportedOperationException("This node doesn't support more than two children");
        }
    }

    @Override
    public int allowedChildCount() {
        return 2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TwoChildProcessNode that = (TwoChildProcessNode)o;
        return Objects.equals(this.leftChild, that.leftChild) && Objects.equals(this.rightChild, that.rightChild);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.leftChild, this.rightChild);
    }
}

