/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.lang;

import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.utils.AssertionUtils;

public class DoubleValue
extends Value<Double> {
    public static DoubleValue create() {
        return DoubleValue.of(0.0);
    }

    public static DoubleValue of(Double value) {
        return new DoubleValue(value);
    }

    public DoubleValue(Double value) {
        super(value);
    }

    public boolean is(double other, double precision) {
        AssertionUtils.assertArg(precision >= 0.0, "Precision must be non-negative", new Object[0]);
        Double v = (Double)this.get();
        if (v == null) {
            return false;
        }
        return Math.abs(v - other) <= precision;
    }

    public boolean isAny(double precision, double ... values) {
        AssertionUtils.assertArg(precision >= 0.0, "Precision must be non-negative", new Object[0]);
        AssertionUtils.assertArgNotNull("values", values);
        Double v = (Double)this.get();
        if (v == null) {
            return false;
        }
        for (double value : values) {
            if (!(Math.abs(v - value) <= precision)) continue;
            return true;
        }
        return false;
    }
}

