/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ibm.as400.access;

import java.nio.charset.StandardCharsets;

public class ReplyDQReadNormal extends DQReadNormalReplyDataStream {

    private final int hashCode;
    private final String senderInformation;
    private final String entry;
    private final String key;

    public ReplyDQReadNormal(int hashCode, String senderInformation, String entry, String key) {
        this.hashCode = hashCode;
        this.senderInformation = senderInformation;
        this.entry = entry;
        this.key = key;
    }

    @Override
    public int hashCode() {
        return hashCode;
    }

    @Override
    byte[] getSenderInformation() {
        return senderInformation.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    byte[] getEntry() {
        return entry.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    byte[] getKey() {
        return key.getBytes(StandardCharsets.UTF_8);
    }
}
