/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.metadata.cost;

import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.ignite.internal.sql.engine.metadata.cost.IgniteCost;

public class IgniteCostFactory
implements RelOptCostFactory {
    private final double cpuWeight;
    private final double memoryWeight;
    private final double ioWeight;
    private final double networkWeight;

    public IgniteCostFactory() {
        this.cpuWeight = 1.0;
        this.memoryWeight = 1.0;
        this.ioWeight = 1.0;
        this.networkWeight = 1.0;
    }

    public IgniteCostFactory(double cpuWeight, double memoryWeight, double ioWeight, double networkWeight) {
        if (cpuWeight < 0.0 || memoryWeight < 0.0 || ioWeight < 0.0 || networkWeight < 0.0) {
            throw new IllegalArgumentException("Weight should be non negative: cpu=" + cpuWeight + ", memory=" + memoryWeight + ", io=" + ioWeight + ", network=" + networkWeight);
        }
        this.cpuWeight = cpuWeight;
        this.memoryWeight = memoryWeight;
        this.ioWeight = ioWeight;
        this.networkWeight = networkWeight;
    }

    public RelOptCost makeCost(double rowCount, double cpu, double io) {
        return this.makeCost(rowCount, cpu, io, 0.0, 0.0);
    }

    public RelOptCost makeCost(double rowCount, double cpu, double io, double memory, double network) {
        return new IgniteCost(rowCount, cpu * this.cpuWeight, memory * this.memoryWeight, io * this.ioWeight, network * this.networkWeight);
    }

    public RelOptCost makeHugeCost() {
        return IgniteCost.HUGE;
    }

    public RelOptCost makeInfiniteCost() {
        return IgniteCost.INFINITY;
    }

    public RelOptCost makeTinyCost() {
        return IgniteCost.TINY;
    }

    public RelOptCost makeZeroCost() {
        return IgniteCost.ZERO;
    }
}

