/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline;

import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.cache.query.index.SortOrder;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparator;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.util.lang.GridCursor;

public class SortedSegmentedIndexCursor
implements GridCursor<IndexRow> {
    private final Queue<GridCursor<IndexRow>> cursors;
    private final Comparator<GridCursor<IndexRow>> cursorComp;
    private IndexRow head;

    public SortedSegmentedIndexCursor(GridCursor<IndexRow>[] cursors, final SortedIndexDefinition idxDef) throws IgniteCheckedException {
        this.cursorComp = new Comparator<GridCursor<IndexRow>>(){
            private final IndexRowComparator rowComparator;
            private final IndexKeyDefinition[] keyDefs;
            {
                this.rowComparator = idxDef.rowComparator();
                this.keyDefs = idxDef.indexKeyDefinitions().values().toArray(new IndexKeyDefinition[0]);
            }

            @Override
            public int compare(GridCursor<IndexRow> o1, GridCursor<IndexRow> o2) {
                try {
                    int keysLen = o1.get().keysCount();
                    for (int i = 0; i < keysLen; ++i) {
                        int cmp = this.rowComparator.compareRow(o1.get(), o2.get(), i);
                        if (cmp == 0) continue;
                        boolean desc = this.keyDefs[i].order().sortOrder() == SortOrder.DESC;
                        return desc ? -cmp : cmp;
                    }
                    return 0;
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException("Failed to sort remote index rows", e);
                }
            }
        };
        this.cursors = this.cursorsQueue(cursors);
    }

    @Override
    public boolean next() throws IgniteCheckedException {
        if (this.cursors.isEmpty()) {
            return false;
        }
        GridCursor<IndexRow> c = this.cursors.poll();
        this.head = c.get();
        if (c.next()) {
            this.cursors.add(c);
        }
        return true;
    }

    @Override
    public IndexRow get() throws IgniteCheckedException {
        return this.head;
    }

    protected Queue<GridCursor<IndexRow>> cursorsQueue(GridCursor<IndexRow>[] cursors) throws IgniteCheckedException {
        PriorityQueue<GridCursor<IndexRow>> q = new PriorityQueue<GridCursor<IndexRow>>(cursors.length, this.cursorComp);
        for (GridCursor<IndexRow> c : cursors) {
            if (!c.next()) continue;
            q.add(c);
        }
        return q;
    }
}

