/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.distributionzones;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite3.internal.distributionzones.NodeWithAttributesSerializer;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerialization;
import org.apache.ignite3.internal.versioned.VersionedSerializer;

public class NodesAttributesSerializer
extends VersionedSerializer<Map<UUID, NodeWithAttributes>> {
    public static final NodesAttributesSerializer INSTANCE = new NodesAttributesSerializer();
    private final NodeWithAttributesSerializer nodeWithAttributesSerializer = NodeWithAttributesSerializer.INSTANCE;

    @Override
    protected void writeExternalData(Map<UUID, NodeWithAttributes> map, IgniteDataOutput out) throws IOException {
        out.writeVarInt(map.size());
        for (Map.Entry<UUID, NodeWithAttributes> entry : map.entrySet()) {
            NodeWithAttributes value = entry.getValue();
            assert (entry.getKey().equals(value.nodeId())) : map;
            this.nodeWithAttributesSerializer.writeExternal(value, out);
        }
    }

    @Override
    protected Map<UUID, NodeWithAttributes> readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        ArrayList<NodeWithAttributes> nodes = new ArrayList<NodeWithAttributes>(length);
        for (int i = 0; i < length; ++i) {
            nodes.add((NodeWithAttributes)this.nodeWithAttributesSerializer.readExternal(in));
        }
        return nodes.stream().collect(Collectors.toMap(NodeWithAttributes::nodeId, Function.identity(), (x, y) -> y, ConcurrentHashMap::new));
    }

    public static byte[] serialize(Map<UUID, NodeWithAttributes> map) {
        return VersionedSerialization.toBytes(map, INSTANCE);
    }

    public static Map<UUID, NodeWithAttributes> deserialize(byte[] bytes) {
        return VersionedSerialization.fromBytes(bytes, INSTANCE);
    }
}

