/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.memberlist.agent;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.schedulers.Timed;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.basecluster.agent.proto.AgentMemberAddr;
import org.apache.bifromq.basecluster.agent.proto.AgentMessage;
import org.apache.bifromq.basecluster.agent.proto.AgentMessageEnvelope;
import org.apache.bifromq.basecluster.memberlist.IHostAddressResolver;
import org.apache.bifromq.basecluster.memberlist.agent.IAgentMessenger;
import org.apache.bifromq.basecluster.messenger.IMessenger;
import org.apache.bifromq.basecluster.proto.ClusterMessage;

public class AgentMessenger
implements IAgentMessenger {
    private final String agentId;
    private final IHostAddressResolver addressResolver;
    private final IMessenger messenger;

    public AgentMessenger(String agentId, IHostAddressResolver addressResolver, IMessenger messenger) {
        this.agentId = agentId;
        this.addressResolver = addressResolver;
        this.messenger = messenger;
    }

    @Override
    public CompletableFuture<Void> send(AgentMessage message, AgentMemberAddr receiver, boolean reliable) {
        InetSocketAddress memberAddress = this.addressResolver.resolve(receiver.getEndpoint());
        if (memberAddress != null) {
            return this.messenger.send(ClusterMessage.newBuilder().setAgentMessage(AgentMessageEnvelope.newBuilder().setAgentId(this.agentId).setReceiver(receiver).setMessage(message).build()).build(), memberAddress, reliable);
        }
        return CompletableFuture.failedFuture(new UnknownHostException("Unknown host"));
    }

    @Override
    public Observable<AgentMessageEnvelope> receive() {
        return this.messenger.receive().map(Timed::value).filter(msg -> msg.message.hasAgentMessage() && msg.message.getAgentMessage().getAgentId().equals(this.agentId)).map(msg -> msg.message.getAgentMessage());
    }
}

